/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public abstract class StateController {
    protected TDSession session;
    protected TDPacket packet;
    protected TDNetworkIOIF io;
    protected Log log;

    public StateController(TDSession tDSession) throws JDBCException {
        this.session = tDSession;
        this.io = tDSession.getIO();
        this.log = tDSession.getLog();
    }

    protected abstract void run() throws SQLException;

    public TDPacket getPacket() {
        if (this.packet != null) {
            this.packet.clear();
        } else {
            this.packet = this.session.getPacket();
        }
        this.packet.newLanHeader();
        return this.packet;
    }

    public TDPacket getPacket(int n) {
        if (this.packet != null) {
            if (this.packet.getBuffer().capacity() >= n) {
                this.packet.clear();
            } else {
                this.session.returnPacket(this.packet);
                this.packet = this.session.getPacket(n);
            }
        } else {
            this.packet = this.session.getPacket(n);
        }
        this.packet.newLanHeader();
        return this.packet;
    }

    public TDSession getSession() {
        return this.session;
    }

    public TDNetworkIOIF getNetworkIO() {
        return this.io;
    }
}

