/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StateController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.SQLException;

public class StatementController
extends StateController
implements RowFetchController {
    private String query;
    private Statement statement;
    private boolean packetDispose = false;
    private byte mode = (byte)66;
    private int resultTypeExpected;
    private TDParcelState historicalState;
    private TDParcelState historicalReturnState;
    protected boolean clearStatementStateLock = false;
    private int currentRequestNumber;
    private SQLException storedException;
    private byte lobSelect = (byte)83;
    private int currentStatementNumber;
    public static final int UPDATE_EXPECTED = 1;
    public static final int RS_EXPECTED = 2;
    public static final int RS_OR_UPDATE = 3;
    public static final int NO_RS_OR_UPDATE = 4;
    public static final int BATCH_UPDATE_EXPECTED = 5;

    public StatementController(Statement statement, TDSession tDSession) throws JDBCException {
        super(tDSession);
        this.statement = statement;
        if (tDSession.isJavaSPDefaultConnection()) {
            this.lobSelect = (byte)67;
        }
    }

    public StatementController(Statement statement, TDSession tDSession, String string) throws JDBCException {
        this(statement, tDSession);
        this.query = string;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void run() throws SQLException {
        TDParcelState tDParcelState = null;
        this.storedException = null;
        if (this.historicalState == null) {
            tDParcelState = new StatementSendState(this);
            this.clearStatementStateLock = false;
        } else {
            tDParcelState = this.historicalState;
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementController.run setting hist state to null; it was=" + this.historicalState + " this=" + this);
            }
            this.historicalState = null;
        }
        this.runBody(tDParcelState);
    }

    public void runBody(TDParcelState tDParcelState) throws SQLException {
        JDBCException jDBCException = null;
        while (tDParcelState != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("StatementController.runBody invoking action for state=" + tDParcelState + " this=" + this);
                }
                tDParcelState = tDParcelState.action();
                if (!this.packetDispose) continue;
                this.packetDispose();
            }
            catch (JDBCException jDBCException2) {
                this.packetDispose();
                if (this.clearStatementStateLock) {
                    this.statement.releaseStatementStateLock();
                    this.clearStatementStateLock = false;
                }
                if (jDBCException2.getErrorCode() == 3510) {
                    throw jDBCException2;
                }
                jDBCException = jDBCException2;
                tDParcelState = this.handleRunException(jDBCException2);
            }
        }
        if (jDBCException != null) {
            throw jDBCException;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementController.runBody completed while loop with null state, this=" + this);
        }
        if (this.clearStatementStateLock) {
            this.statement.releaseStatementStateLock();
            this.clearStatementStateLock = false;
        }
        if (this.storedException != null) {
            this.packetDispose();
            this.handleRunException(this.storedException);
            throw this.storedException;
        }
    }

    protected TDParcelState handleRunException(SQLException sQLException) throws JDBCException {
        return null;
    }

    private void packetDispose() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementController.packetDispose packet=" + this.packet + " this=" + this);
        }
        if (this.packet != null) {
            this.session.returnPacket(this.packet);
            this.packet = null;
        }
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getResultTypeExpected() {
        return this.resultTypeExpected;
    }

    public void setResultTypeExpected(int n) {
        this.resultTypeExpected = n;
    }

    public void setHistoricalState(TDParcelState tDParcelState) {
        this.historicalState = tDParcelState;
    }

    public TDParcelState getHistoricalState() {
        return this.historicalState;
    }

    public void setHistoricalReturnState(TDParcelState tDParcelState) {
        this.historicalReturnState = tDParcelState;
    }

    public TDParcelState getHistoricalReturnState() {
        return this.historicalReturnState;
    }

    public void setPacketDispose(boolean bl) {
        this.packetDispose = bl;
    }

    public int getCurrentRequestNumber() {
        return this.currentRequestNumber;
    }

    public void setCurrentRequestNumber(int n) {
        this.currentRequestNumber = n;
    }

    public void setStoredException(SQLException sQLException) {
        this.storedException = sQLException;
    }

    public SQLException getStoredException() {
        return this.storedException;
    }

    public byte getLobSelect() {
        return this.lobSelect;
    }

    public void setLobSelect(byte by) {
        this.lobSelect = by;
    }

    public boolean usePositioning() {
        if (this.mode == 83 || this.mode == 80) {
            return false;
        }
        switch (this.statement.getResultSetType()) {
            case 1004: 
            case 1005: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String string = String.valueOf(this.query).replaceAll("\\s", "");
        string = string.substring(0, Math.min(string.length(), 20));
        return super.toString() + "(sql=" + string + " stmt=" + this.statement + ")";
    }

    public void setCurrentStatementNumber(int n) {
        this.currentStatementNumber = n;
    }

    public int getCurrentStatementNumber() {
        return this.currentStatementNumber;
    }

    public StatementController(StatementController statementController) throws SQLException {
        this(statementController.statement, statementController.session, statementController.query);
        this.mode = statementController.mode;
        this.resultTypeExpected = statementController.resultTypeExpected;
        this.historicalState = statementController.historicalState;
        this.clearStatementStateLock = statementController.clearStatementStateLock;
        this.currentRequestNumber = statementController.currentRequestNumber;
        this.storedException = statementController.storedException;
        this.lobSelect = statementController.lobSelect;
        this.currentStatementNumber = statementController.currentStatementNumber;
        this.historicalReturnState = null;
        if (!(this.historicalState instanceof StatementContinueState)) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", this.historicalState.toString());
        }
        StatementContinueState statementContinueState = (StatementContinueState)this.historicalState;
        int n = statementContinueState.getReceiveState().getRequestNum();
        StatementReceiveState statementReceiveState = new StatementReceiveState(this);
        statementReceiveState.setRequestNum(n);
        StatementContinueState statementContinueState2 = new StatementContinueState(this, statementReceiveState);
        this.historicalState = statementContinueState2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchRows(ResultSet resultSet, int n, int n2, int n3, int n4) throws SQLException {
        block7: {
            this.session.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            try {
                boolean bl;
                boolean bl2 = bl = this.session.isStatementPositioningSupported() && this.statement.getResultSetType() == 1004;
                if (n3 == n4 && !bl) {
                    this.log.debug("StatementController.fetchRows fetching sequentially");
                } else {
                    TeraResultSetMetaData teraResultSetMetaData = resultSet.getMetaData();
                    StatementReceiveState statementReceiveState = new StatementReceiveState(this);
                    statementReceiveState.setHistoricalState(new ReceiveRecordSubState(statementReceiveState, null));
                    statementReceiveState.setRequestNum(n);
                    statementReceiveState.setActivityType((short)teraResultSetMetaData.getActivityType());
                    statementReceiveState.setActivityCount(resultSet.getNumberOfRows());
                    statementReceiveState.setPrepInfo(teraResultSetMetaData.getPrepInfoParcel());
                    statementReceiveState.setCurrentResultSet(resultSet);
                    StatementContinueState statementContinueState = new StatementContinueState(this, statementReceiveState);
                    statementContinueState.setDesiredStatementNumber(n2);
                    statementContinueState.setDesiredRowNumber(n3);
                    this.historicalState = statementContinueState;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("StatementController.fetchRows: before StatementController.run: hist state=" + this.historicalState);
                }
                this.statement.changeStatementState(2);
                this.run();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("StatementController.fetchRows: after StatementController.run: hist state=" + this.historicalState);
                }
                Object var11_10 = null;
                if (this.session.isCleanUpStatementsStarted()) break block7;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!this.session.isCleanUpStatementsStarted()) {
                    this.statement.changeStatementState(1);
                }
                this.session.releaseSessionLock();
                throw throwable;
            }
            this.statement.changeStatementState(1);
        }
        this.session.releaseSessionLock();
    }

    public void suppressResponseCancel() {
        this.statement.suppressResponseCancel();
    }

    public void closingResultSet(boolean bl) throws SQLException {
        boolean bl2 = this.statement.getResults().areAllResultSetsClosed();
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementController.closingResultSet: areAllResultSetsClosed=" + bl2 + ", this=" + this);
        }
        if (bl2) {
            this.statement.closeRequest(bl);
        }
    }

    public Object getCloseMutex() {
        return this.statement;
    }

    public int getRowFetchDirection() {
        return this.statement.getFetchDirection();
    }

    public int getRowFetchSize() {
        return this.statement.getFetchSize();
    }

    public TDSession getLobSession() {
        return this.session;
    }

    public int getMaxFetchRows() {
        return this.statement.getMaxRows();
    }

    public int getMaxFetchFieldSize() {
        return this.statement.getMaxFieldSize();
    }

    public boolean registerStatement() {
        return this.session.registerStatement(this.statement);
    }

    public void unregisterStatement() {
        this.session.unregisterStatement(this.statement);
    }
}

