/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveInitSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;

public class StatementReceiveState
implements TDParcelState {
    private StatementController controller;
    private TDParcelState historicalSubState;
    private TDParcelState subState;
    private TDParcelState returnState;
    private TDPacket packet;
    private ResultSet currentResultSet;
    private int requestNum;
    private short statementNumber;
    private short activityType;
    private int activityCount;
    private long m_startingRowPosition = 0L;
    private short warningCode;
    private JDBCException exception;
    private boolean packetInUse = false;
    private PrepInfoParcel savedPrepInfo;
    private boolean cancelFlag = false;
    private int statementReceiveType;
    protected Log log;
    public static final int RCV_PREPARE = 1;
    public static final int RCV_EXEC_AFTER_PREP = 2;
    public static final int RCV_EXECUTE_ONLY = 3;
    public static final int RCV_BOTH_PREP_EXEC = 4;

    public StatementReceiveState(StatementController statementController) {
        this.controller = statementController;
        this.log = statementController.getSession().getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDParcelState action() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementReceiveState.action this=" + this);
        }
        this.exception = null;
        this.setStatementReceiveType();
        if (!this.packetInUse) {
            this.packet = this.controller.getPacket();
            this.controller.setPacketDispose(false);
            TDNetworkIOIF tDNetworkIOIF = this.controller.getNetworkIO();
            Object var2_3 = null;
            this.packet.clear();
            tDNetworkIOIF.acquireReadLock();
            try {
                if (this.controller.getStatement().getState() != 8) {
                    this.packet.getBuffer().readStream(tDNetworkIOIF, this.controller.getSession().getTeraEncrypt(), this.controller.getStatement().isFinalized(), this.controller.getStatement().getRemainingTime(), true);
                    if (this.controller.getStatement().getState() == 3) {
                        this.controller.getStatement().setState(4);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("StatementReceiveState.action returned from reading IO, this=" + this);
                    }
                } else {
                    this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ159", "StatementState.TIMEOUT before receive"));
                    this.setUpAbortRequest();
                }
            }
            catch (JDBCException jDBCException) {
                if (jDBCException.getErrorCode() != 802) {
                    this.controller.getSession().setClosed();
                    throw jDBCException;
                }
                if (this.controller.getStatement().getState() == 9 || this.controller.getStatement().getState() == 10) {
                    tDNetworkIOIF.close();
                    this.controller.getSession().setClosed();
                    throw ErrorFactory.makeIoJDBCException("TJ164", "Read timeout after abort was sent", tDNetworkIOIF, jDBCException, this.controller.getStatement().isFinalized() ? null : this.log);
                }
                this.controller.setStoredException(jDBCException);
                this.setUpAbortRequest();
            }
            finally {
                tDNetworkIOIF.releaseReadLock();
            }
            if (!this.cancelFlag) {
                this.packet.initParcelFactory(this.controller.getSession().getCharSet(), this.log);
                this.controller.getSession().setTransactionInProgress(this.packet.inTransaction());
                if (this.savedPrepInfo != null) {
                    this.packet.setParcelFactoryPrepInfo(this.savedPrepInfo);
                }
                this.requestNum = this.packet.getRequestNumber();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("StatementReceiveState.action obtained request number, this=" + this);
                }
                if (this.historicalSubState == null) {
                    this.historicalSubState = new ReceiveInitSubState(this);
                }
            }
        }
        if (!this.cancelFlag) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementReceiveState.action packet=" + this.packet + " this=" + this);
                this.log.debug(this.packet.getBuffer());
            }
            try {
                this.subStateMachine();
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            catch (SQLException sQLException) {
                this.returnState = null;
                this.controller.setHistoricalReturnState(null);
                throw sQLException;
            }
        }
        if (this.returnState == null && this.controller.getHistoricalReturnState() != null) {
            this.returnState = this.controller.getHistoricalReturnState();
            this.controller.setHistoricalReturnState(null);
        }
        return this.returnState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    public TDParcelState getReturnState() {
        return this.returnState;
    }

    public void setReturnState(TDParcelState tDParcelState) {
        this.returnState = tDParcelState;
    }

    public TDParcelState getSubState() {
        return this.subState;
    }

    public void setSubState(TDParcelState tDParcelState) {
        this.subState = tDParcelState;
    }

    public TDParcelState getHistoricalState() {
        return this.historicalSubState;
    }

    public void setHistoricalState(TDParcelState tDParcelState) {
        this.historicalSubState = tDParcelState;
    }

    public StatementController getController() {
        return this.controller;
    }

    public void setController(StatementController statementController) {
        this.controller = statementController;
    }

    public TDPacket getPacket() {
        return this.packet;
    }

    public void setPacket(TDPacket tDPacket) {
        this.packet = tDPacket;
    }

    public Parcel getNextParcel() throws SQLException {
        return this.packet.nextParcel();
    }

    public Parcel scanForEndParcel(boolean bl) throws SQLException {
        return this.packet.scanForEndParcel(bl);
    }

    public void subStateMachine() throws SQLException {
        this.subState = this.historicalSubState;
        while (this.subState != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("StatementReceiveState.subStateMachine executing substate=" + this.subState + " this=" + this);
            }
            this.subState = this.subState.action();
        }
    }

    public void addResult(Result result) throws SQLException {
        if (ActivityAnalyzer.outParamResultSet(this.activityType) && result.getType() == 2) {
            result.getResultSet().next();
            this.controller.getStatement().setOutParamResultSet(result.getResultSet());
            if (this.controller.getResultTypeExpected() == 1 || this.controller.getResultTypeExpected() == 5) {
                result = new Result(0);
            } else {
                result = null;
                this.controller.getStatement().getResults().enableDynamicResultSets(this.controller);
            }
        }
        if (result != null) {
            this.controller.getStatement().getResults().addResult(this.controller, result);
        }
    }

    public ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    public void setCurrentResultSet(ResultSet resultSet) {
        this.currentResultSet = resultSet;
        if (this.log.isDebugEnabled()) {
            this.log.debug("StatementReceiveState.setCurrentResultSet this=" + this);
        }
    }

    public int getRequestNum() {
        return this.requestNum;
    }

    public void setRequestNum(int n) {
        this.requestNum = n;
    }

    public short getStatementNumber() {
        return this.statementNumber;
    }

    public void setStatementNumber(short s) {
        this.statementNumber = s;
    }

    public short getActivityType() {
        return this.activityType;
    }

    public void setActivityType(short s) {
        this.activityType = s;
    }

    public int getActivityCount() {
        return this.activityCount;
    }

    public void setActivityCount(int n) {
        this.activityCount = n;
    }

    public short getWarningCode() {
        return this.warningCode;
    }

    public void setWarningCode(short s) {
        this.warningCode = s;
    }

    public void addWarning(SQLWarning sQLWarning) {
        this.controller.getStatement().addWarning(sQLWarning);
    }

    public void addException(JDBCException jDBCException) {
        if (this.exception == null) {
            this.exception = jDBCException;
        } else {
            this.exception.setNextException(jDBCException);
        }
    }

    public boolean isPacketInUse() {
        return this.packetInUse;
    }

    public void setPacketInUse(boolean bl) {
        this.packetInUse = bl;
        this.controller.setPacketDispose(!bl);
    }

    public void setPrepInfo(PrepInfoParcel prepInfoParcel) {
        this.savedPrepInfo = prepInfoParcel;
    }

    public void savePrepInfo() {
        this.savedPrepInfo = this.packet.getParcelFactoryPrepInfo();
    }

    private void setUpAbortRequest() {
        this.controller.getStatement().setState(8);
        this.getController().setResultTypeExpected(4);
        StatementAbortState statementAbortState = new StatementAbortState(this.getController());
        this.returnState = statementAbortState;
        this.controller.setHistoricalReturnState(null);
        this.getController().setPacketDispose(true);
        this.cancelFlag = true;
    }

    public boolean preparingRequest() {
        return this.statementReceiveType == 1;
    }

    public void initPrepInfo() throws JDBCException {
        if (this.statementReceiveType != 2) {
            return;
        }
        if (this.currentResultSet == null) {
            TeraResultSetMetaData teraResultSetMetaData = this.controller.getStatement().getMetaDataList().getMetaDataForStatement(this.statementNumber);
            this.createCurrentResultSet(teraResultSetMetaData);
            this.savedPrepInfo = teraResultSetMetaData.getPrepInfoParcel();
        } else if (this.controller.getStatement().returnGeneratedKeys() && this.controller.getResultTypeExpected() == 5) {
            TeraResultSetMetaData teraResultSetMetaData = this.currentResultSet.getMetaData();
            this.currentResultSet.setNumberOfRows(this.currentResultSet.getNumberOfRows() + (teraResultSetMetaData.getColumnCount() == 0 ? 0 : this.getActivityCount()));
        }
        this.getPacket().setParcelFactoryPrepInfo(this.savedPrepInfo);
    }

    public void setStartingRowPosition(long l) {
        this.m_startingRowPosition = l;
    }

    public void createCurrentResultSet(TeraResultSetMetaData teraResultSetMetaData) throws JDBCException {
        ResultSet resultSet = ResultSet.createResultSet(null, this.getController(), this.log, teraResultSetMetaData);
        this.setCurrentResultSet(resultSet);
        resultSet.setNumberOfRows(teraResultSetMetaData.getColumnCount() == 0 ? 0 : this.getActivityCount());
        resultSet.setStartingRowPosition(this.m_startingRowPosition);
    }

    private void setStatementReceiveType() throws JDBCException {
        switch (this.controller.getMode()) {
            case 66: {
                this.statementReceiveType = 4;
                break;
            }
            case 69: {
                if (this.controller instanceof PreparedStatementController || this.controller.getStatement().returnGeneratedKeys()) {
                    this.statementReceiveType = 2;
                    break;
                }
                this.statementReceiveType = 3;
                break;
            }
            case 80: 
            case 83: {
                this.statementReceiveType = 1;
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ392");
            }
        }
    }

    public String toString() {
        return super.toString() + "(req#=" + this.requestNum + " stmt#=" + this.statementNumber + " atype=" + this.activityType + " acnt=" + this.activityCount + " currs=" + this.currentResultSet + " ctlr=" + this.controller + ")";
    }

    public void setParameterMarkerMetaData(ArrayList arrayList) {
        Statement statement = this.controller.getStatement();
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)this.controller.getStatement();
            ArrayList arrayList2 = preparedStatement.getParameterMarkerMetaData();
            if (arrayList2 != null) {
                arrayList2.addAll(arrayList);
            } else {
                preparedStatement.setParameterMarkerMetaData(arrayList);
            }
        }
    }
}

