/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.util.HashMap;

public class ColumnDisplaySizes {
    private static final Integer SINGLE_BYTE = new Integer(1);
    private static final Integer MULTI_BYTE_UTF8 = new Integer(2);
    private static final Integer MULTI_BYTE_UTF16 = new Integer(3);
    private static final Integer MULTI_BYTE1 = new Integer(4);
    private static final Integer MULTI_BYTE2 = new Integer(5);
    private static final int UNKNOWN = 0;
    private static final int LATIN = 1;
    private static final int UNICODE = 2;
    private static final int KANJI_SJIS = 3;
    private static final int GRAPHIC = 4;
    private static final int KANJI = 5;
    private static final HashMap tdCharTypeAdjustments = new HashMap();
    private static final HashMap javaCharsetNameToCategory = new HashMap();
    private static final String SEP = "_";

    public static int getCharDisplaySize(int n, String string, int n2) throws JDBCException {
        if (n2 > -1) {
            String string2 = ColumnDisplaySizes.getJavaCharSetCategory(string) + SEP + n2;
            int[] nArray = (int[])tdCharTypeAdjustments.get(string2);
            return (n - nArray[1]) / nArray[0];
        }
        return 0;
    }

    private static Integer getJavaCharSetCategory(String string) throws JDBCException {
        Integer n = (Integer)javaCharsetNameToCategory.get(string);
        if (n == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ495", string);
        }
        return n;
    }

    static {
        javaCharsetNameToCategory.put("ASCII", SINGLE_BYTE);
        javaCharsetNameToCategory.put("ISO8859_1", SINGLE_BYTE);
        javaCharsetNameToCategory.put("ISO8859_15_FDIS", SINGLE_BYTE);
        javaCharsetNameToCategory.put("Cp037", SINGLE_BYTE);
        javaCharsetNameToCategory.put("Cp1252", SINGLE_BYTE);
        javaCharsetNameToCategory.put("Cp273", SINGLE_BYTE);
        javaCharsetNameToCategory.put("Cp277", SINGLE_BYTE);
        javaCharsetNameToCategory.put("UTF8", MULTI_BYTE_UTF8);
        javaCharsetNameToCategory.put("UnicodeBigUnmarked", MULTI_BYTE_UTF16);
        javaCharsetNameToCategory.put("MS932", MULTI_BYTE1);
        javaCharsetNameToCategory.put("MS949", MULTI_BYTE1);
        javaCharsetNameToCategory.put("EUC_CN", MULTI_BYTE1);
        javaCharsetNameToCategory.put("BIG5", MULTI_BYTE1);
        javaCharsetNameToCategory.put("EUC_JP", MULTI_BYTE1);
        javaCharsetNameToCategory.put("Cp933", MULTI_BYTE2);
        javaCharsetNameToCategory.put("Cp935", MULTI_BYTE2);
        javaCharsetNameToCategory.put("Cp937", MULTI_BYTE2);
        javaCharsetNameToCategory.put("Cp930", MULTI_BYTE2);
        javaCharsetNameToCategory.put("Cp939", MULTI_BYTE2);
        tdCharTypeAdjustments.put(SINGLE_BYTE + SEP + 1, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF8 + SEP + 1, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF16 + SEP + 1, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE1 + SEP + 1, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE2 + SEP + 1, new int[]{1, 0});
        tdCharTypeAdjustments.put(SINGLE_BYTE + SEP + 2, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF8 + SEP + 2, new int[]{3, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF16 + SEP + 2, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE1 + SEP + 2, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE2 + SEP + 2, new int[]{2, 2});
        tdCharTypeAdjustments.put(SINGLE_BYTE + SEP + 3, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF8 + SEP + 3, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF16 + SEP + 3, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE1 + SEP + 3, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE2 + SEP + 3, new int[]{1, 0});
        tdCharTypeAdjustments.put(SINGLE_BYTE + SEP + 4, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF8 + SEP + 4, new int[]{3, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF16 + SEP + 4, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE1 + SEP + 4, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE2 + SEP + 4, new int[]{2, 0});
        tdCharTypeAdjustments.put(SINGLE_BYTE + SEP + 5, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF8 + SEP + 5, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF16 + SEP + 5, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE1 + SEP + 5, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE2 + SEP + 5, new int[]{1, 0});
        tdCharTypeAdjustments.put(SINGLE_BYTE + SEP + 0, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF8 + SEP + 0, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE_UTF16 + SEP + 0, new int[]{2, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE1 + SEP + 0, new int[]{1, 0});
        tdCharTypeAdjustments.put(MULTI_BYTE2 + SEP + 0, new int[]{1, 0});
    }
}

