/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.IOException;
import java.io.InterruptedIOException;

public class ErrorAnalyzer {
    public static JDBCException analyzeError(JDBCException jDBCException) {
        JDBCException jDBCException2 = null;
        switch (jDBCException.getErrorCode()) {
            case 3110: {
                jDBCException2 = ErrorFactory.makeDriverJDBCException("TJ057");
                break;
            }
            default: {
                jDBCException2 = jDBCException;
            }
        }
        return jDBCException2;
    }

    public static JDBCException analyzeIoError(String string, TDNetworkIOIF tDNetworkIOIF, Throwable throwable, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = throwable instanceof InterruptedIOException || throwable instanceof IOException && throwable.getMessage().toUpperCase().indexOf("TIMED OUT") >= 0;
        String string2 = bl2 ? (bl3 ? "TJ159" : "TJ164") : (bl3 ? "TJ590" : "TJ300");
        return ErrorFactory.makeIoJDBCException(string2, string, tDNetworkIOIF, throwable, bl ? null : tDNetworkIOIF.getLog());
    }

    public static JDBCException analyzeInterrupt(int n, Throwable throwable) {
        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException(n == 11 ? "TJ057" : "TJ626");
        jDBCException.initCause(throwable);
        return jDBCException;
    }

    public static boolean warningIsReallyError(int n) {
        switch (n) {
            case 5526: 
            case 5603: 
            case 7980: {
                return true;
            }
        }
        return false;
    }
}

