/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.Errors;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.TDDataTruncation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;

public class ErrorFactory {
    private static final String TERAJDBC_VERSION = " [TeraJDBC " + Const.DRIVER_VERSION + "]";
    private static final String DBMS_ERROR = "[Teradata Database]" + TERAJDBC_VERSION;
    private static final String DRIVER_ERROR = "[Teradata JDBC Driver]" + TERAJDBC_VERSION;

    private ErrorFactory() {
    }

    private static String formatExceptionMessage(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, String string8) {
        string2 = String.valueOf(string2);
        return string + " [Error " + n + "] [SQLState " + string3 + "] " + ErrorMessage.Format5(string2, string4, string5, string6, string7, string8);
    }

    public static JDBCException makeDriverJDBCException(String string) {
        return ErrorFactory.makeDriverJDBCException(string, null, null, null, null, null);
    }

    public static JDBCException makeDriverJDBCException(String string, String string2) {
        return ErrorFactory.makeDriverJDBCException(string, string2, null, null, null, null);
    }

    public static JDBCException makeDriverJDBCException(String string, String string2, String string3) {
        return ErrorFactory.makeDriverJDBCException(string, string2, string3, null, null, null);
    }

    public static JDBCException makeDriverJDBCException(String string, String string2, String string3, String string4) {
        return ErrorFactory.makeDriverJDBCException(string, string2, string3, string4, null, null);
    }

    public static JDBCException makeDriverJDBCException(String string, String string2, String string3, String string4, String string5) {
        return ErrorFactory.makeDriverJDBCException(string, string2, string3, string4, string5, null);
    }

    public static JDBCException makeDriverJDBCException(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n = errorDescriptor.getCode();
        String string8 = Errors.getSQLState(n);
        string7 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string7, string8, n, string2, string3, string4, string5, string6);
        return new JDBCException(string7, string8, n);
    }

    public static JDBCException makeDriverJDBCException(String string, int n) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n));
    }

    public static JDBCException makeDriverJDBCException(String string, int n, int n2) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2));
    }

    public static JDBCException makeDriverJDBCException(String string, int n, int n2, int n3) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3));
    }

    public static JDBCException makeDriverJDBCException(String string, int n, int n2, int n3, int n4) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4));
    }

    public static JDBCException makeDriverJDBCException(String string, int n, int n2, int n3, int n4, int n5) {
        return ErrorFactory.makeDriverJDBCException(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4), Integer.toString(n5));
    }

    public static BatchUpdateException convertToBatchUpdateException(SQLException sQLException, int[] nArray) {
        BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        batchUpdateException.setNextException(sQLException);
        batchUpdateException.initCause(sQLException);
        return batchUpdateException;
    }

    public static BatchUpdateException makeBatchUpdateException(String string, int[] nArray) {
        return ErrorFactory.makeBatchUpdateException(string, nArray, null, null, null, null, null);
    }

    public static BatchUpdateException makeBatchUpdateException(String string, int[] nArray, String string2) {
        return ErrorFactory.makeBatchUpdateException(string, nArray, string2, null, null, null, null);
    }

    public static BatchUpdateException makeBatchUpdateException(String string, int[] nArray, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n = errorDescriptor.getCode();
        String string8 = Errors.getSQLState(n);
        string7 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string7, string8, n, string2, string3, string4, string5, string6);
        return new BatchUpdateException(string7, string8, n, nArray);
    }

    public static SQLException makeLegacyDriverException(String string, String string2, int n) {
        return ErrorFactory.makeLegacyDriverException(string, string2, n, null, null, null, null, null);
    }

    public static SQLException makeLegacyDriverException(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        String string8 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string, string2, n, string3, string4, string5, string6, string7);
        return new SQLException(string8, string2, n);
    }

    public static JDBCException makeIoJDBCException(String string, String string2, TDNetworkIOIF tDNetworkIOIF, Throwable throwable, Log log) {
        StringWriter stringWriter = new StringWriter();
        if (throwable != null) {
            throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        }
        StringBuffer stringBuffer = new StringBuffer(string2 + " " + new Date() + " " + tDNetworkIOIF + " " + stringWriter);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\t' && c != '\r' && c != '\n') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        String string3 = stringBuffer.toString();
        if (log != null) {
            log.error(string3);
        }
        JDBCException jDBCException = ErrorFactory.makeDriverJDBCException(string, string3);
        jDBCException.initCause(throwable);
        return jDBCException;
    }

    public static TDDataTruncation makeTDDataTruncation(String string, int n, boolean bl, boolean bl2, int n2, int n3, int n4) {
        String string2 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n5 = errorDescriptor.getCode();
        String string3 = Errors.getSQLState(n5);
        string2 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string2, string3, n5, Integer.toString(n2), Integer.toString(n), Integer.toString(n4), Integer.toString(n3), null);
        return new TDDataTruncation(string2, string3, n5, n, bl, bl2, n2, n3);
    }

    public static TDDataTruncation makeTDDataTruncation(String string, int n, boolean bl, boolean bl2, int n2, int n3) {
        String string2 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n4 = errorDescriptor.getCode();
        String string3 = Errors.getSQLState(n4);
        string2 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string2, string3, n4, Integer.toString(n2), Integer.toString(n), Integer.toString(n3), null, null);
        return new TDDataTruncation(string2, string3, n4, n, bl, bl2, n2, n3);
    }

    public static SQLWarning makeSQLWarning(String string) {
        return ErrorFactory.makeSQLWarning(string, null, null, null, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2) {
        return ErrorFactory.makeSQLWarning(string, string2, null, null, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3) {
        return ErrorFactory.makeSQLWarning(string, string2, string3, null, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3, String string4) {
        return ErrorFactory.makeSQLWarning(string, string2, string3, string4, null, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3, String string4, String string5) {
        return ErrorFactory.makeSQLWarning(string, string2, string3, string4, string5, null);
    }

    public static SQLWarning makeSQLWarning(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = ErrorMessage.messages.getString(string);
        Errors.ErrorDescriptor errorDescriptor = Errors.getErrorDescriptor(string);
        int n = errorDescriptor.getCode();
        String string8 = Errors.getSQLState(n);
        string7 = ErrorFactory.formatExceptionMessage(DRIVER_ERROR, string7, string8, n, string2, string3, string4, string5, string6);
        return new SQLWarning(string7, string8, n);
    }

    public static SQLWarning makeDatabaseSQLWarning(String string, int n) {
        String string2 = Errors.getSQLState(n);
        string = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string, string2, n, null, null, null, null, null);
        return new SQLWarning(string, string2, n);
    }

    public static JDBCException makeDatabaseSQLException(String string, int n) {
        String string2 = Errors.getSQLState(n);
        string = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string, string2, n, null, null, null, null, null);
        return new JDBCException(string, string2, n);
    }

    public static JDBCException makeDatabaseSQLException(String string, int n, int n2) {
        String string2 = Errors.getSQLState(n, n2);
        string = ErrorFactory.formatExceptionMessage(DBMS_ERROR, string, string2, n, null, null, null, null, null);
        return new JDBCException(string, string2, n);
    }

    public static SQLWarning makeSQLWarning(String string, int n) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2, int n3) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2, int n3, int n4) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4));
    }

    public static SQLWarning makeSQLWarning(String string, int n, int n2, int n3, int n4, int n5) {
        return ErrorFactory.makeSQLWarning(string, Integer.toString(n), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4), Integer.toString(n5));
    }
}

