/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.util;

import java.util.HashMap;

public class JDBC4Constants {
    public static final int DEFAULT_BUFFER_SIZE = 65104;
    public static final int ONE_MB_BUFFER_SIZE = 1048500;
    public static final int MAX_TOTAL_MSG_SIZE_64KB = 65156;
    public static final int MAX_TOTAL_MSG_SIZE_1MB = 1048552;
    public static final int MAX_TOTAL_MSG_SIZE_AFTER_ENCRYPTION = 2097104;
    public static final int MAX_LOB_DATA_SIZE = 64000;
    public static final int MAX_APH_LOB_DATA_SIZE = 1024000;
    public static final byte TD_DEFAULT_CHARSET_CODE = -1;
    public static final String TD_DEFAULT_CHARSET = "ASCII";
    public static final int MAX_INDIC_DATA_SIZE = 65100;
    public static final int PRECISION_BYTEINT = 3;
    public static final int PRECISION_SMALLINT = 5;
    public static final int PRECISION_INTEGER = 10;
    private static final HashMap tdToJavaSQLTypes = new HashMap();
    private static final HashMap nullable = new HashMap();
    private static final HashMap tdTypesToTypeNames = new HashMap();
    private static final HashMap tdTypesToDispSize = new HashMap();
    private static final HashMap JavaSQLTypesToSQLTypeName = new HashMap();
    private static final HashMap JavaSQLTypesToJavaClassName = new HashMap();
    private static final HashMap tdTypesToParameterMode = new HashMap();
    private static final HashMap tdTypeToBasicTDType = new HashMap();
    private static final HashMap tdTypesToIsCharType = new HashMap();
    private static final HashMap tdTypesToIsTemporalType = new HashMap();
    private static final Integer RSMD_NO_NULLS = new Integer(0);
    private static final Integer RSMD_NULLABLE = new Integer(1);
    private static final Integer PARAMETER_UNKNOWN = new Integer(0);
    private static final Integer PARAMETER_IN = new Integer(1);
    private static final Integer PARAMETER_INOUT = new Integer(2);
    private static final Integer PARAMETER_OUT = new Integer(4);
    private static final Integer[] RSMD_NULLABILITES = new Integer[]{RSMD_NO_NULLS, RSMD_NULLABLE, RSMD_NULLABLE, RSMD_NULLABLE, RSMD_NULLABLE};
    private static final Integer[] PARAMETER_MODES = new Integer[]{PARAMETER_UNKNOWN, PARAMETER_UNKNOWN, PARAMETER_IN, PARAMETER_INOUT, PARAMETER_OUT};

    private static void putMaps(int n, int n2, boolean bl, boolean bl2, String string, int n3, String string2, String string3) {
        Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n + 1), new Integer(n + 500), new Integer(n + 501), new Integer(n + 502)};
        Integer n4 = new Integer(n2);
        Integer n5 = new Integer(n3);
        for (int i = 0; i < integerArray.length; ++i) {
            if (n != 0) {
                tdTypeToBasicTDType.put(integerArray[i], integerArray[0]);
                tdToJavaSQLTypes.put(integerArray[i], n5);
                nullable.put(integerArray[i], RSMD_NULLABILITES[i]);
                tdTypesToParameterMode.put(integerArray[i], PARAMETER_MODES[i]);
                tdTypesToDispSize.put(integerArray[i], n4);
                tdTypesToIsCharType.put(integerArray[i], bl ? Boolean.TRUE : Boolean.FALSE);
                tdTypesToIsTemporalType.put(integerArray[i], bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
            if (string == null) continue;
            tdTypesToTypeNames.put(integerArray[i], string);
        }
        JavaSQLTypesToSQLTypeName.put(n5, string2);
        if (string3 != null) {
            JavaSQLTypesToJavaClassName.put(n5, string3);
        }
    }

    public static int getJavaSQLType(int n) {
        Integer n2 = (Integer)tdToJavaSQLTypes.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public static String getJavaSQLTypeName(int n) {
        return (String)JavaSQLTypesToSQLTypeName.get(new Integer(n));
    }

    public static String getJavaClassName(int n) {
        return (String)JavaSQLTypesToJavaClassName.get(new Integer(n));
    }

    public static int getNullable(int n) {
        return (Integer)nullable.get(new Integer(n));
    }

    public static String getTDTypeName(int n) {
        return (String)tdTypesToTypeNames.get(new Integer(n));
    }

    public static int getDisplaySize(int n) {
        Integer n2 = (Integer)tdTypesToDispSize.get(new Integer(n));
        return n2 != null ? n2 : 0;
    }

    public static int getTDTypeParameterMode(int n) {
        Object v = tdTypesToParameterMode.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    public static short getTDBasicType(int n) {
        Integer n2 = (Integer)tdTypeToBasicTDType.get(new Integer(n));
        return n2 != null ? n2.shortValue() : (short)0;
    }

    public static boolean isCharType(int n) {
        Boolean bl = (Boolean)tdTypesToIsCharType.get(new Integer(n));
        return bl != null && bl != false;
    }

    public static boolean isTemporalType(int n) {
        Boolean bl = (Boolean)tdTypesToIsTemporalType.get(new Integer(n));
        return bl != null && bl != false;
    }

    static {
        JDBC4Constants.putMaps(400, 0, false, false, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(404, 0, false, false, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(408, 0, false, false, "BLOB", 2004, "BLOB", "java.sql.Blob");
        JDBC4Constants.putMaps(416, 0, true, false, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(420, 0, true, false, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(424, 0, true, false, "CLOB", 2005, "CLOB", "java.sql.Clob");
        JDBC4Constants.putMaps(448, 0, true, false, "VARCHAR", 12, "VARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(452, 0, true, false, "CHAR", 1, "CHAR", "java.lang.String");
        JDBC4Constants.putMaps(456, 0, true, false, "LONGVARCHAR", -1, "LONGVARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(464, 0, true, false, "VARGRAPHIC", 12, "VARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(468, 0, true, false, "GRAPHIC", 1, "CHAR", "java.lang.String");
        JDBC4Constants.putMaps(472, 0, true, false, "LONGVARGRAPHIC", -1, "LONGVARCHAR", "java.lang.String");
        JDBC4Constants.putMaps(480, 22, false, false, "FLOAT", 6, "FLOAT", "java.lang.Double");
        JDBC4Constants.putMaps(484, 20, false, false, "DECIMAL", 3, "DECIMAL", "java.math.BigDecimal");
        JDBC4Constants.putMaps(496, 11, false, false, "INTEGER", 4, "INTEGER", "java.lang.Integer");
        JDBC4Constants.putMaps(500, 6, false, false, "SMALLINT", 5, "SMALLINT", "java.lang.Integer");
        JDBC4Constants.putMaps(600, 20, false, false, "BIGINT", -5, "BIGINT", "java.lang.Long");
        JDBC4Constants.putMaps(688, 0, false, false, "VARBYTE", -3, "VARBINARY", "[B");
        JDBC4Constants.putMaps(692, 0, false, false, "BYTE", -2, "BINARY", "[B");
        JDBC4Constants.putMaps(696, 0, false, false, "LONGVARBYTE", -4, "LONGVARBINARY", "[B");
        JDBC4Constants.putMaps(748, 10, false, true, "DATE", 91, "DATE", "java.sql.Date");
        JDBC4Constants.putMaps(752, 10, false, true, "DATE", 91, "DATE", "java.sql.Date");
        JDBC4Constants.putMaps(756, 4, false, false, "BYTEINT", -6, "TINYINT", "java.lang.Integer");
        JDBC4Constants.putMaps(760, 8, false, true, "TIME", 92, "TIME", "java.sql.Time");
        JDBC4Constants.putMaps(764, 19, false, true, "TIMESTAMP", 93, "TIMESTAMP", "java.sql.Timestamp");
        JDBC4Constants.putMaps(768, 14, false, true, "TIME WITH TIME ZONE", 92, "TIME", "java.sql.Time");
        JDBC4Constants.putMaps(772, 25, false, true, "TIMESTAMP WITH TIME ZONE", 93, "TIMESTAMP", "java.sql.Timestamp");
        JDBC4Constants.putMaps(776, 1, false, true, "INTERVAL YEAR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(780, 4, false, true, "INTERVAL YEAR TO MONTH", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(784, 1, false, true, "INTERVAL MONTH", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(788, 1, false, true, "INTERVAL DAY", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(792, 4, false, true, "INTERVAL DAY TO HOUR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(796, 7, false, true, "INTERVAL DAY TO MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(800, 10, false, true, "INTERVAL DAY TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(804, 1, false, true, "INTERVAL HOUR", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(808, 4, false, true, "INTERVAL HOUR TO MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(812, 7, false, true, "INTERVAL HOUR TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(816, 1, false, true, "INTERVAL MINUTE", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(820, 4, false, true, "INTERVAL MINUTE TO SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(824, 1, false, true, "INTERVAL SECOND", 1111, "OTHER", "java.lang.String");
        JDBC4Constants.putMaps(440, 0, false, true, "STRUCT", 2002, "STRUCT", "java.sql.Struct");
        JDBC4Constants.putMaps(0, 0, false, false, null, -7, "BIT", "java.lang.Boolean");
        JDBC4Constants.putMaps(0, 0, false, false, null, 8, "DOUBLE", "java.lang.Double");
        JDBC4Constants.putMaps(0, 0, false, false, null, 0, "NULL", null);
        JDBC4Constants.putMaps(0, 0, false, false, null, 2, "NUMERIC", "java.math.BigDecimal");
        JDBC4Constants.putMaps(0, 0, false, false, null, 7, "REAL", "java.lang.Double");
    }
}

