/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssContext;
import com.teradata.tdgss.jgssp2gss.GssUtil;
import com.teradata.tdgss.jgssspi.TDGSSb;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SspiMechanism
implements TDGSSb {
    private static Oid _mechOid;
    private static Oid _gssOid;
    private static Oid GSS_C_NT_TDAT_MECHDATA;
    private static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    private String userName = null;
    private String realm = null;
    private static final String prog = "SspiMechanism";
    private GSSManager mgr = GSSManager.getInstance();
    protected static final Oid mechOid;
    protected static final Oid gssOid;
    protected static final short servicesAvailable = 127;

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        String string = "SspiMechanism-acceptable:\t";
        if (object == null) {
            GssUtil.prtdbg(string + "Token is null");
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return (byArray[8] & 1) != 1 && byArray[1] == 1;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        String string = "SspiMechanism-getContextForAccept:\t";
        GssUtil.prtdbg(string + "Getting an acceptable context ");
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new GSSException(10);
        }
        GSSContext gSSContext = this.mgr.createContext(gSSCredential);
        return new GssContext(gSSContext, mechOid);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        String string = "SspiMechanism-getContextForInit:\t";
        GssUtil.prtdbg(string + "Getting an initable context ");
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new GSSException(10);
        }
        GSSContext gSSContext = this.mgr.createContext(gSSName, gssOid, gSSCredential, n);
        this.setServices(gSSContext, s);
        return new GssContext(gSSContext, mechOid);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        String string = "SspiMechanism-initable:\t";
        if (gSSName == null) {
            GssUtil.prtdbg(string + "GSSException.BAD_NAME: " + "target name cannot be null");
            return false;
        }
        if ((0x7F & s) == s) {
            return true;
        }
        GssUtil.prtdbg(string + "unable to support requested services");
        GssUtil.prtdbg(string + "servicesAvailable are " + 127);
        GssUtil.prtdbg(string + "servicesRequested are " + s);
        return false;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        return this.mgr.createCredential(gSSName, n, gssOid, n2);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "SspiMechanism-createName:\t";
        if (oid != null) {
            if (oid.equals(GSSName.NT_HOSTBASED_SERVICE)) {
                return this.mgr.createName(byArray, oid);
            }
            if (oid.equals(GSS_C_NT_TDAT_MECHDATA_UTF8) || oid.equals(GSS_C_NT_TDAT_MECHDATA_UTF16) || oid.equals(GSS_C_NT_TDAT_MECHDATA_UTF32)) {
                try {
                    string = new String(byArray, "UTF-16");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return null;
                }
            } else if (oid.equals(GSS_C_NT_TDAT_MECHDATA)) {
                string = new String(byArray);
            }
            int n = string.indexOf("@@");
            if (n != -1) {
                String string5 = string.substring(0, n);
                int n2 = string5.indexOf("@");
                if (n2 != -1) {
                    string2 = string5.substring(0, n2);
                    this.realm = string5.substring(++n2);
                    int n3 = string2.indexOf("/");
                    if (n3 != -1) {
                        this.userName = string2.substring(0, n3);
                        string3 = string2.substring(++n3);
                    } else {
                        this.userName = string2;
                    }
                } else {
                    int n4 = string5.indexOf("/");
                    if (n4 == -1) {
                        this.userName = string5;
                    } else {
                        this.userName = string5.substring(0, n4);
                        string3 = string5.substring(++n4);
                    }
                }
            } else {
                return null;
            }
            GssUtil.prtdbg(string4 + "Principal= " + this.userName + " instance = " + string3 + " realm = " + this.realm);
            return this.mgr.createName(this.userName.getBytes(), GSSName.NT_USER_NAME);
        }
        return this.mgr.createName(byArray, oid);
    }

    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{GSSName.NT_HOSTBASED_SERVICE, GSS_C_NT_TDAT_MECHDATA, GSS_C_NT_TDAT_MECHDATA_UTF8, GSS_C_NT_TDAT_MECHDATA_UTF16, GSS_C_NT_TDAT_MECHDATA_UTF32};
        return oidArray;
    }

    public Oid getMech() {
        return mechOid;
    }

    public short getServices() {
        return 127;
    }

    public void setServices(GSSContext gSSContext, short s) throws GSSException {
        if ((s & 1) != 0) {
            gSSContext.requestCredDeleg(true);
        }
        if ((s & 2) != 0) {
            gSSContext.requestMutualAuth(true);
        }
        if ((s & 4) != 0) {
            gSSContext.requestReplayDet(true);
        }
        if ((s & 8) != 0) {
            gSSContext.requestSequenceDet(true);
        }
        if ((s & 0x10) != 0) {
            gSSContext.requestAnonymity(true);
        }
        if ((s & 0x20) != 0) {
            gSSContext.requestConf(true);
        }
        if ((s & 0x40) != 0) {
            gSSContext.requestInteg(true);
        }
    }

    static {
        try {
            _mechOid = new Oid("1.2.840.113554.1.2.2");
            _gssOid = new Oid("1.2.840.113554.1.2.2");
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError("Oid string is incorrectly formatted");
        }
        mechOid = _mechOid;
        gssOid = _gssOid;
    }
}

