/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.jgssp2ldap.LdapCredential;
import com.teradata.tdgss.jgssp2ldap.LdapDH;
import com.teradata.tdgss.jgssp2ldap.LdapException;
import com.teradata.tdgss.jgssp2ldap.LdapMechanism;
import com.teradata.tdgss.jgssp2ldap.LdapName;
import com.teradata.tdgss.jgssp2ldap.LdapUtil;
import com.teradata.tdgss.jgssp2ldap.LdapVersion;
import com.teradata.tdgss.jgssp2ldap.TDGSSd;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class LdapContext
implements GSSContext {
    private static final short maxshort = Short.MAX_VALUE;
    private byte contextInit = 0;
    private int msgsequence = 0;
    private byte server_client = 1;
    private TdgssVersion mylibraryversion;
    private LdapVersion mymethodversion;
    private byte myendien = 1;
    private boolean established = false;
    private byte myencryptionmode = (byte)-1;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] Key = null;
    private String[] endien_txt = new String[]{"small endien", "big endien"};
    private MessageDigest WrapDigest;
    private MessageDigest GetMicDigest;
    private MessageDigest UnwrapDigest;
    private MessageDigest VerifyMicDigest;
    private int DigestLength;
    private short state;
    private boolean initiator;
    private LdapCredential credential;
    private LdapName targetName;
    private int lifetime;
    private short requestedServices;
    private LdapDH DH;
    private TDGSSd AES;
    private static final String prog = "LdapContext";
    private static final int HEADERLEN = 16;
    private static final int MAXMSGSEQUENCESERVER = 1;
    private static final int MAXMSGSEQUENCECLIENT = 4;
    protected static final int LIB_MAJOR_REL_VER_INDEX = 16;
    private static final int LIB_MINOR_REL_VER_INDEX = 17;
    private static final int LIB_MAINT_REL_VER_INDEX = 18;
    private static final int LIB_EMG_REL_VER_INDEX = 19;
    protected static final int PKEY_LENGTH = 20;
    private static final int GKEY_LENGTH = 24;
    private static final int PUBLICKEY_LENGTH = 28;
    private static final int KEY_DATA = 80;
    private static final int TRAILER_LENGTH = 30;
    private static final byte TDGSS_BIGENDIEN = 1;
    private static final byte TDGSS_SMALLENDIEN = 0;
    private static final byte TDGSS_SERVER = 1;
    private static final byte TDGSS_CLIENT = 0;
    private static final byte TDGSS_ECB = 0;
    private static final byte PROTOCOL_VERSION = 1;
    protected static final byte INITCTXMSG = 1;
    private static final byte ACCEPTCTXMSG = 2;
    private static final byte ENCRYPTMSG = 3;
    private static final byte SIGNATUREMSG = 4;
    private static final byte INITMSG = 1;
    private static final byte CONTMSG = 2;
    private static final byte CLIENT = 0;
    private static final byte SERVER = 1;
    protected static final byte BIT0 = 1;
    private static final byte BIT1 = 2;
    private static final byte BIT2 = 4;
    private static final byte BIT4 = 16;
    private static final int BYTESININT = 4;
    private static final int BITSPERBYTE = 8;
    protected static final byte FLAG_BYTE = 12;
    private static final int INITMSGLEN = 64;
    private static final int PUBLICKEYLEN = 64;
    private static final int NOTAPPLICABLE = 65535;
    static final int keysize = 64;
    static final String[] msgexttxt = new String[]{"client", "server"};
    private byte[] UserPropBytes = null;

    public LdapContext(LdapCredential ldapCredential, Object[] objectArray) throws GSSException {
        this.initiator = false;
        this.credential = ldapCredential;
        this.InitialiseData();
        this.requestedServices = (short)99;
    }

    public LdapContext(LdapCredential ldapCredential, LdapName ldapName, int n, Object[] objectArray, short s) throws GSSException {
        this.initiator = true;
        this.credential = ldapCredential;
        this.targetName = ldapName;
        this.lifetime = n;
        this.requestedServices = s;
        this.InitialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static LdapVersion InquireMethodVersion() {
        LdapVersion ldapVersion = new LdapVersion();
        return ldapVersion;
    }

    private void InitialiseData() throws GSSException {
        this.msgsequence = 0;
        this.mylibraryversion = LdapContext.InquireLibraryVersion();
        this.mymethodversion = LdapContext.InquireMethodVersion();
        this.myendien = 1;
        this.myencryptionmode = 0;
        this.mycbmaxtoken = 80;
        this.DH = new LdapDH();
        String[] stringArray = this.ParseQOP(1);
        try {
            this.WrapDigest = MessageDigest.getInstance(stringArray[1]);
            this.UnwrapDigest = MessageDigest.getInstance(stringArray[1]);
            this.GetMicDigest = MessageDigest.getInstance(stringArray[1]);
            this.VerifyMicDigest = MessageDigest.getInstance(stringArray[1]);
        }
        catch (Exception exception) {
            int n = -486538748;
            throw new GSSException(11, n, LdapException.ErrStr(n));
        }
        byte[] byArray = this.WrapDigest.digest(new byte[0]);
        this.DigestLength = byArray.length;
    }

    private byte[] GetMsgInfo(byte by, byte by2, int n, int n2, int n3) {
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = by;
        byArray[2] = by2;
        try {
            byArray[3] = this.isserver() ? (byte)1 : 0;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
        }
        byte[] byArray2 = LdapUtil.inttobytearray(n);
        System.arraycopy(byArray2, 0, byArray, 4, 4);
        byArray2 = LdapUtil.inttobytearray(n2);
        System.arraycopy(byArray2, 0, byArray, 8, 4);
        if (n3 != 65535 && n3 == 1) {
            byArray[12] = (byte)(byArray[12] | 4);
        }
        if ((this.requestedServices & 1) != 0) {
            byArray[12] = (byte)(byArray[12] | 0x10);
        }
        for (int i = 13; i < 16; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    private int[] ValidateMsgInfo(byte[] byArray, int n, int n2, byte by, byte by2) throws GSSException {
        int[] nArray = new int[2];
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        if (byArray2[0] != 1 || byArray2[1] != by || byArray2[2] != by2) {
            throw new GSSException(10);
        }
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray2, 4, byArray3, 0, 4);
        BigInteger bigInteger = new BigInteger(byArray3);
        nArray[0] = bigInteger.intValue();
        if (n2 != nArray[0] + 16) {
            throw new GSSException(10);
        }
        System.arraycopy(byArray2, 8, byArray3, 0, 4);
        bigInteger = new BigInteger(byArray3);
        nArray[1] = bigInteger.intValue();
        return nArray;
    }

    public String[] ParseQOP(int n) throws GSSException {
        String[] stringArray = new String[5];
        switch (n) {
            case 0: {
                stringArray[0] = "AES";
                stringArray[1] = "MD5";
                stringArray[2] = "128";
                stringArray[3] = "CFB";
                stringArray[4] = "PKCS5Padding";
                break;
            }
            case 1: {
                stringArray[0] = "AES";
                stringArray[1] = "SHA1";
                stringArray[2] = "128";
                stringArray[3] = "OFB";
                stringArray[4] = "PKCS5Padding";
                break;
            }
            default: {
                throw new GSSException(16);
            }
        }
        return stringArray;
    }

    private byte[] BuildInitMsg(byte by) throws GSSException {
        String string = "LdapContext-BuildInitMsg:\t";
        byte[] byArray = null;
        Object var5_4 = null;
        byte[] byArray2 = new byte[]{6, 12, 43, 6, 1, 4, 1, -127, 63, 1, -121, 116, 1, 20, 70, 8, 0, 1, -127, 0, 3, 0, 0, 0, 1, 0, 0, 0, 30, 1};
        LdapUtil.prtdbg(string + "We will initiate the handshake now...");
        byArray = new byte[this.mycbmaxtoken + byArray2.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byte[] byArray3 = this.GetMsgInfo(by, (byte)1, 128, 0, 65535);
        System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        byArray[16] = this.mylibraryversion.MajorRelease;
        byArray[17] = this.mylibraryversion.MinorRelease;
        byArray[18] = this.mylibraryversion.MaintenanceRelease;
        byArray[19] = this.mylibraryversion.EmergencyRelease;
        System.arraycopy(byArray2, 0, byArray, this.mycbmaxtoken, byArray2.length);
        LdapUtil.prtdbg(string + "Successfully generated first message as");
        LdapUtil.hexDump(System.out, byArray);
        return byArray;
    }

    private int ProcessInitMsg(byte[] byArray, int n, int n2) throws GSSException {
        Object var7_4 = null;
        Object var8_5 = null;
        Object var9_6 = null;
        String string = "LdapContext-ProcessInitMsg:\t";
        LdapUtil.prtdbg(string + "Receiving and processing first message");
        if (n != 0) {
            LdapUtil.prtdbg(string + "Only offset = 0 is allowed!");
            return -486538752;
        }
        this.mytargetendien = 0;
        if ((byArray[12] & 0x10) != 16) {
            this.requestedServices = (short)(this.requestedServices & 0x7FFE);
        }
        LdapUtil.prtdbg(string + "Checking target endien as " + this.mytargetendien);
        if (this.byteflipneeded()) {
            LdapUtil.prtdbg(string + "We have to byte-flip!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            LdapUtil.prtdbg(string + "*** Illegal library version *** ");
            return -486538760;
        }
        if (byArray[0] != 1 || byArray[1] != 1 && byArray[1] != 2 || byArray[2] != 1) {
            LdapUtil.prtdbg(string + " Message header is not proper");
            return -486538751;
        }
        LdapUtil.prtdbg(string + "The received message is OK!");
        return 587203060;
    }

    private byte[] BuildServerMsg(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = new byte[4];
        String string = "LdapContext-BuildServerMsg:\t";
        System.arraycopy(byArray, 20, byArray3, 0, 4);
        int n3 = LdapUtil.ByteAtoInt(byArray3);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 80, byArray2, 0, n3);
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        int n4 = LdapUtil.ByteAtoInt(byArray5);
        byArray4 = new byte[n4];
        System.arraycopy(byArray, 80 + n3, byArray4, 0, n4);
        System.arraycopy(byArray, 28, byArray8, 0, 4);
        int n5 = LdapUtil.ByteAtoInt(byArray8);
        byArray7 = new byte[n5];
        System.arraycopy(byArray, 80 + n3 + n4, byArray7, 0, n5);
        LdapUtil.prtdbg(string + "Generate DH Parameters ...");
        this.DH.GenerateParameters(1, byArray4, byArray2);
        LdapUtil.prtdbg(string + "Generate DH Public Key ...");
        byte[] byArray9 = this.DH.GenerateKey();
        byArray6 = new byte[16 + n5];
        for (int i = 0; i < byArray6.length; ++i) {
            byArray6[i] = 0;
        }
        byte[] byArray10 = this.GetMsgInfo((byte)1, (byte)2, n5, 0, 65535);
        System.arraycopy(byArray10, 0, byArray6, 0, byArray10.length);
        System.arraycopy(byArray9, 0, byArray6, byArray10.length, byArray9.length);
        LdapUtil.prtdbg(string + "Compute  DH Private Key ...");
        this.Key = this.DH.ComputeKey(byArray7);
        LdapUtil.prtdbg(string + "The received message is OK!");
        return byArray6;
    }

    public void setkey(byte[] byArray) {
        this.Key = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        String string = "LdapContext-byteflipneeded:\t";
        if (this.mytargetendien != this.myendien) {
            LdapUtil.prtdbg(string + "target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            try {
                if (this.isserver()) {
                    LdapUtil.prtdbg(string + "We are server! No need to byte-flip!");
                } else {
                    LdapUtil.prtdbg(string + "We are client, we have to byte-flip!");
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        String string = "LdapContext-msgcvt:\t";
        if (!this.byteflipneeded()) {
            LdapUtil.prtdbg(string + "No flipping needed!");
            return byArray;
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[16] >= 6;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        Object var7_5 = null;
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        String string = "LdapContext-initSecContext:\t";
        LdapUtil.prtdbg(string + "msgsequence is now " + this.msgsequence);
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                LdapUtil.prtdbg(string + "Confirming that we are now " + msgexttxt[this.server_client]);
                byArray2 = this.BuildInitMsg((byte)1);
                break;
            }
            case 1: {
                LdapUtil.prtdbg(string + "Just receive info-data from server as:");
                LdapUtil.hexDump(System.out, byArray);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 != 587203060) {
                    throw new GSSException(11, n3, LdapException.ErrStr(n3));
                }
                byArray2 = this.BuildServerMsg(byArray, n, n2);
                break;
            }
            case 2: {
                byte[] byArray3 = null;
                String string2 = ((Object)this.getSrcName()).toString();
                try {
                    byArray3 = string2.getBytes("US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                byte[] byArray4 = new byte[16 + string2.length()];
                byte[] byArray5 = this.GetMsgInfo((byte)1, (byte)2, string2.length(), 0, 65535);
                System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length);
                System.arraycopy(byArray3, 0, byArray4, 16, string2.length());
                MessageProp messageProp = new MessageProp(0, true);
                byArray2 = this.wrap(byArray4, 0, byArray4.length, messageProp);
                break;
            }
            case 3: {
                LdapUtil.prtdbg(string + "Receive info-data from server as:");
                LdapUtil.hexDump(System.out, byArray);
                byte[] byArray6 = new byte[4];
                System.arraycopy(byArray, 4, byArray6, 0, 4);
                BigInteger bigInteger = new BigInteger(byArray6);
                int n4 = bigInteger.intValue();
                this.UserPropBytes = new byte[n4];
                System.arraycopy(byArray, 16, this.UserPropBytes, 0, n4);
                break;
            }
            default: {
                int n5 = -486538758;
                throw new GSSException(11, n5, LdapException.ErrStr(n5));
            }
        }
        ++this.msgsequence;
        LdapUtil.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "LdapContext-acceptSecContext:\t";
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                LdapUtil.prtdbg(string + "Just receive info-data from client as:");
                LdapUtil.hexDump(System.out, byArray);
                byArray2 = this.BuildInitMsg((byte)2);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 == 587203060) break;
                throw new GSSException(11, n3, LdapException.ErrStr(n3));
            }
            default: {
                int n4 = -486538758;
                throw new GSSException(11, n4, LdapException.ErrStr(n4));
            }
        }
        ++this.msgsequence;
        LdapUtil.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        String string = "LdapContext-isEstablished:\t";
        try {
            n = this.isserver() ? 1 : 4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        LdapUtil.prtdbg(string + "Leaving with retcode = " + bl);
        return bl;
    }

    public boolean isserver() throws GSSException {
        String string = "LdapContext-isserver:\t";
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new GSSException(11);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (n2 < 16) {
            return 0;
        }
        int n3 = n2 - 16;
        int n4 = n3 - 20;
        return n4;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        Object object;
        String string = "LdapContext-wrap:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            LdapUtil.prtdbg(string + " INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        String[] stringArray = this.ParseQOP(1);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n3 = Integer.parseInt(stringArray[2]) / 8;
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        SecretKey secretKey = this.DH.BytetoKey(string2, this.Key, 0, n3);
        this.WrapDigest.update(byArray, n, n2);
        byte[] byArray3 = this.WrapDigest.digest();
        byte[] byArray4 = new byte[n2 + byArray3.length];
        LdapUtil.prtdbg(string + "OrigLen " + n2 + " MicBuf.length " + byArray3.length);
        System.arraycopy(byArray, n, byArray4, 0, n2);
        System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
        if (this.getConfState() && messageProp.getPrivacy()) {
            object = string2 + "/" + string4 + "/" + string5;
            int n4 = byArray4.length;
            if (string2.equalsIgnoreCase("AES")) {
                try {
                    this.AES = new TDGSSd();
                    this.AES.a(secretKey);
                    LdapUtil.hexDump(System.out, secretKey.getEncoded());
                    byArray2 = this.AES.a(byArray4, 0, n4);
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                    int n5 = -486538755;
                    throw new GSSException(11, n5, LdapException.ErrStr(n5));
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                    int n6 = -486538755;
                    throw new GSSException(11, n6, LdapException.ErrStr(n6));
                }
            } else {
                try {
                    Cipher cipher = Cipher.getInstance((String)object);
                    if (string5.equalsIgnoreCase("NoPadding")) {
                        int n7 = cipher.getBlockSize();
                        n4 = byArray4.length / n7 * n7;
                    }
                    if (string4.equalsIgnoreCase("ECB")) {
                        cipher.init(1, secretKey);
                    } else {
                        byte[] byArray5 = new byte[cipher.getBlockSize()];
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray5[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
                        cipher.init(1, (Key)secretKey, ivParameterSpec);
                    }
                    byArray2 = cipher.doFinal(byArray4, 0, n4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    int n8 = -486538755;
                    throw new GSSException(11, n8, LdapException.ErrStr(n8));
                }
            }
        } else {
            byArray2 = byArray4;
        }
        object = new byte[16 + byArray2.length];
        int n9 = this.getConfState() ? 1 : 0;
        byte[] byArray6 = this.GetMsgInfo((byte)3, (byte)2, byArray2.length, messageProp.getQOP(), n9);
        System.arraycopy(byArray2, 0, object, 0, byArray2.length);
        LdapUtil.prtdbg(string + "EncBuf " + byArray2.length);
        System.arraycopy(byArray6, 0, object, byArray2.length, byArray6.length);
        LdapUtil.prtdbg(string + "Leaving!");
        return object;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        Object object;
        byte[] byArray2;
        byte[] byArray3 = new byte[4];
        String string = "LdapContext-unwrap:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            LdapUtil.prtdbg(string + " INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        int[] nArray = this.ValidateMsgInfo(byArray, n, n2, (byte)3, (byte)2);
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, n2 + n - 16, byArray4, 0, 16);
        boolean bl = (byArray4[12] & 4) == 4;
        String[] stringArray = this.ParseQOP(1);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n3 = Integer.parseInt(stringArray[2]) / 8;
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        SecretKey secretKey = this.DH.BytetoKey(string2, this.Key, 0, n3);
        if (bl) {
            String string6 = string2 + "/" + string4 + "/" + string5;
            if (string2.equalsIgnoreCase("AES")) {
                try {
                    this.AES.a(secretKey);
                    byArray2 = this.AES.b(byArray, n, nArray[0]);
                    LdapUtil.hexDump(System.out, byArray2);
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                    int n4 = -486538755;
                    throw new GSSException(11, n4, LdapException.ErrStr(n4));
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                    int n5 = -486538755;
                    throw new GSSException(11, n5, LdapException.ErrStr(n5));
                }
                catch (BadPaddingException badPaddingException) {
                    badPaddingException.printStackTrace();
                    int n6 = -486538755;
                    throw new GSSException(11, n6, LdapException.ErrStr(n6));
                }
            } else {
                try {
                    object = Cipher.getInstance(string6);
                    if (string4.equalsIgnoreCase("ECB")) {
                        ((Cipher)object).init(2, secretKey);
                    } else {
                        byte[] byArray5 = new byte[((Cipher)object).getBlockSize()];
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray5[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
                        ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
                    }
                    byArray2 = ((Cipher)object).doFinal(byArray, n, nArray[0]);
                }
                catch (Exception exception) {
                    int n7 = -486538755;
                    throw new GSSException(11, n7, LdapException.ErrStr(n7));
                }
            }
        } else {
            byArray2 = new byte[nArray[0]];
            System.arraycopy(byArray, n, byArray2, 0, nArray[0]);
        }
        int n8 = byArray2.length - this.DigestLength;
        this.UnwrapDigest.update(byArray2, 0, n8);
        object = this.UnwrapDigest.digest();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] == byArray2[n8 + i]) continue;
            throw new GSSException(6);
        }
        byte[] byArray6 = new byte[n8];
        System.arraycopy(byArray2, 0, byArray6, 0, n8);
        LdapUtil.prtdbg(string + "Leaving!");
        return byArray6;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        String string = "LdapContext-getMIC:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            LdapUtil.prtdbg(string + " INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        this.GetMicDigest.update(byArray, n, n2);
        byte[] byArray2 = this.GetMicDigest.digest();
        byte[] byArray3 = this.GetMsgInfo((byte)4, (byte)2, byArray2.length, messageProp.getQOP(), 65535);
        byte[] byArray4 = new byte[16 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, 16);
        LdapUtil.prtdbg(string + "Leaving!");
        return byArray4;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        String string = "LdapContext-verifyMIC:\t";
        LdapUtil.prtdbg(string + "Entering!");
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            LdapUtil.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            LdapUtil.prtdbg(string + " INPUT BUFFER SIZE " + byArray2.length + " IS SMALLER THAN LENGTH + OFFSET " + (n4 + n3));
            throw new GSSException(11);
        }
        int[] nArray = this.ValidateMsgInfo(byArray, n, n2, (byte)4, (byte)2);
        String[] stringArray = this.ParseQOP(1);
        this.VerifyMicDigest.update(byArray2, n3, n4);
        byte[] byArray3 = this.VerifyMicDigest.digest();
        if (n2 != byArray3.length + 16) {
            LdapUtil.prtdbg(string + "Input Mic Length for " + stringArray[1] + " is not " + (byArray3.length + 16) + " bytes");
            throw new GSSException(6);
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray[n + i]) continue;
            throw new GSSException(6);
        }
        LdapUtil.prtdbg(string + "Leaving!");
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public byte[] export() throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
    }

    public boolean getCredDelegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            if (this.isEstablished()) {
                return (this.requestedServices & 1) != 0;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return (this.requestedServices & 2) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return (this.requestedServices & 4) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return (this.requestedServices & 8) != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.lifetime;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new GSSException(11, 0, "No Context");
        }
        return false;
    }

    public boolean isProtReady() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.isEstablished();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return LdapMechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        int n = -486538754;
        throw new GSSException(16, n, LdapException.ErrStr(n));
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }
}

