/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.TDGSSc;
import com.teradata.tdgss.jgssp2td1.Td1Credential;
import com.teradata.tdgss.jgssp2td1.Td1DH;
import com.teradata.tdgss.jgssp2td1.Td1Exception;
import com.teradata.tdgss.jgssp2td1.Td1Mechanism;
import com.teradata.tdgss.jgssp2td1.Td1Name;
import com.teradata.tdgss.jgssp2td1.Td1Pkey;
import com.teradata.tdgss.jgssp2td1.Td1Util;
import com.teradata.tdgss.jgssp2td1.Td1Version;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class Td1Context
implements GSSContext {
    private static final short maxshort = Short.MAX_VALUE;
    private int msgsequence = 0;
    private byte server_client = 1;
    private byte contextInit = 0;
    private TdgssVersion mylibraryversion;
    private Td1Version mymethodversion;
    private byte myendien = 1;
    private boolean established = false;
    private byte myencryptionmode = (byte)-1;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] Key = null;
    private boolean newDHkey = false;
    private int BFKEYBYTES = 52;
    private byte[] bfKey = null;
    private String[] endien_txt = new String[]{"small endien", "big endien"};
    private static final String prog = "Td1Context";
    static final int MAXMSGSEQUENCESERVER = 2;
    static final int MAXMSGSEQUENCECLIENT = 3;
    static final int LIB_MAJOR_REL_VER_INDEX = 0;
    static final int LIB_MINOR_REL_VER_INDEX = 1;
    static final int LIB_MAINT_REL_VER_INDEX = 2;
    static final int LIB_EMG_REL_VER_INDEX = 3;
    static final int METHOD_MAJOR_REL_VER_INDEX = 4;
    static final int METHOD_MINOR_REL_VER_INDEX = 5;
    static final int METHOD_MAINT_REL_VER_INDEX = 6;
    static final int METHOD_EMG_REL_VER_INDEX = 7;
    static final int ENDIENINDEX = 8;
    static final int ENCRYPTIONMODEINDEX = 9;
    private static final int ENCRYPTIONTYPEINDEX = 10;
    private static final int DHINDEX = 12;
    static final byte TDGSS_BIGENDIEN = 1;
    static final byte TDGSS_SMALLENDIEN = 0;
    static final byte TDGSS_CLIENT = 0;
    static final byte TDGSS_SERVER = 1;
    static final byte TDGSS_ECB = 0;
    static final int TDGSS_SHARED_G = 4068;
    static final int TDGSS_SHARED_N = 7919;
    private byte[] TDGSS_SHARED_N_NEW = null;
    private byte[] TDGSS_SHARED_G_NEW = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int BITSPERBYTE = 8;
    static final int BYTESININT = 4;
    private int MAXKEYBYTES = 56;
    static final int MAX_EXPONENTIAL = Short.MAX_VALUE;
    private int CURRENTKEYBYTES = 52;
    private int keysize = this.CURRENTKEYBYTES / 4 * 4;
    static final String[] msgexttxt = new String[]{"client", "server"};
    private short state;
    private boolean initiator;
    private Td1Credential credential;
    private Td1Name targetName;
    private int lifetime;
    private short requestedServices;
    private Td1DH DH;
    private TDGSSc blf;

    public Td1Context(Td1Credential td1Credential, Object[] objectArray) throws GSSException {
        this.initiator = false;
        this.credential = td1Credential;
        this.initialiseData();
        this.requestedServices = (short)98;
    }

    public Td1Context(Td1Credential td1Credential, Td1Name td1Name, int n, Object[] objectArray, short s) throws GSSException {
        this.initiator = true;
        this.credential = td1Credential;
        this.targetName = td1Name;
        this.lifetime = n;
        this.requestedServices = s;
        this.initialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static Td1Version InquireMethodVersion() {
        Td1Version td1Version = new Td1Version();
        return td1Version;
    }

    private void initialiseData() {
        this.msgsequence = 0;
        this.mylibraryversion = Td1Context.InquireLibraryVersion();
        this.mymethodversion = Td1Context.InquireMethodVersion();
        this.myendien = 1;
        this.myencryptionmode = 0;
        this.mycbmaxtoken = 64;
        this.DH = new Td1DH(this.keysize, 4068, 7919);
        this.blf = new TDGSSc();
    }

    private byte[] buildinitmsg() {
        byte[] byArray = null;
        String string = "Td1Context-buildinitmsg:\t";
        Td1Util.prtdbg(string + "First time entering - We will" + " initiate the handshake now...");
        byArray = new byte[this.mycbmaxtoken];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byArray[0] = this.mylibraryversion.MajorRelease;
        byArray[1] = this.mylibraryversion.MinorRelease;
        byArray[2] = this.mylibraryversion.MaintenanceRelease;
        byArray[3] = this.mylibraryversion.EmergencyRelease;
        byArray[4] = this.mymethodversion.MajorRelease;
        byArray[5] = this.mymethodversion.MinorRelease;
        byArray[6] = this.mymethodversion.MaintenanceRelease;
        byArray[7] = this.mymethodversion.EmergencyRelease;
        byArray[8] = this.myendien;
        byArray[9] = this.myencryptionmode;
        byArray[10] = 1;
        Td1Util.prtdbg(string + "Successfully generate first message as");
        Td1Util.hexDump(System.out, byArray);
        return byArray;
    }

    private int processinitmsg(byte[] byArray, int n) throws GSSException {
        String string = "Td1Context-processinitmsg:\t";
        Td1Util.prtdbg(string + "Receiving and processing" + "first message, length = " + n);
        Td1Util.prtdbg(string + "incoming buffer is ");
        Td1Util.hexDump(System.out, byArray);
        if (this.server_client == 0) {
            if (byArray[10] == 1) {
                if (n != 16) {
                    Td1Util.prtdbg(string + "*** ILLEGAL INPUT LENGTH " + " EXPECTING " + 16 + " RECEVING " + n);
                    return -486538963;
                }
            } else if (n != this.mycbmaxtoken) {
                Td1Util.prtdbg(string + "*** ILLEGAL INPUT LENGTH " + " EXPECTING " + this.mycbmaxtoken + " RECEVING " + n);
                return -486538963;
            }
        }
        Td1Util.prtdbg(string + "Length is good...");
        this.mytargetendien = byArray[8];
        Td1Util.prtdbg(string + "Checking target endien as " + this.mytargetendien);
        if (this.mytargetendien != 1 && this.mytargetendien != 0) {
            Td1Util.prtdbg(string + "*** ILLEGAL PEER ENDIEN! ****");
            return -486538955;
        }
        if (this.byteflipneeded()) {
            Td1Util.prtdbg(string + "WE HAVE TO BYTE-FLIP!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            Td1Util.prtdbg(string + "*** ILLEGAL LIBRARY VERSION ");
            return -486538962;
        }
        this.chkmethod(byArray);
        if (this.myencryptionmode != byArray[9]) {
            Td1Util.prtdbg(string + " OR ENCRYPTION MODE ");
            return 587202887;
        }
        Td1Util.prtdbg(string + "Library version and encryption mode are good!");
        return 587202860;
    }

    public void setkey(byte[] byArray) {
        this.Key = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        String string = "Td1Context-byteflipneeded:\t";
        if (this.mytargetendien != this.myendien) {
            Td1Util.prtdbg(string + "target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            try {
                if (this.isserver()) {
                    Td1Util.prtdbg(string + "We are server! No need to byte-flip!");
                } else {
                    Td1Util.prtdbg(string + "We are CLIENT, WE HAVE TO BYTE-FLIP!");
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        String string = "Td1Context-msgcvt:\t";
        if (!this.byteflipneeded()) {
            Td1Util.prtdbg(string + "No flipping needed!");
            return byArray;
        }
        Td1Util.prtdbg(string + "Data before byte-flip!");
        Td1Util.hexDump(System.out, byArray);
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        Td1Util.prtdbg(string + "Data after byte-flip!");
        Td1Util.hexDump(System.out, byArray);
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[0] >= 5;
    }

    private int ByteAtoInt(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger.intValue();
    }

    private void chkmethod(byte[] byArray) throws GSSException {
        byte[] byArray2 = new byte[4];
        if (byArray[10] == 1) {
            this.newDHkey = true;
            this.MAXKEYBYTES = 128;
            this.CURRENTKEYBYTES = 80;
            this.keysize = this.CURRENTKEYBYTES / 4 * 4;
            this.BFKEYBYTES = 16;
            System.arraycopy(byArray, 12, byArray2, 0, 4);
            Td1Util.prtdbg("pindex =" + this.ByteAtoInt(byArray2));
            this.TDGSS_SHARED_N_NEW = Td1Pkey.getPkey(this.ByteAtoInt(byArray2));
            if (this.TDGSS_SHARED_N_NEW == null) {
                throw new GSSException(11, -486538960, Td1Exception.ErrStr(-486538960));
            }
            this.DH = new Td1DH(this.keysize, this.TDGSS_SHARED_G_NEW, this.TDGSS_SHARED_N_NEW, 2);
        }
        this.bfKey = new byte[this.BFKEYBYTES];
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        byte[] byArray2 = null;
        Object var7_5 = null;
        String string = "Td1Context-initSecContext:\t";
        Td1Util.prtdbg(string + "msgsequence is now " + this.msgsequence);
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                Td1Util.prtdbg(string + "Confirming that we are now " + msgexttxt[this.server_client]);
                byArray2 = this.buildinitmsg();
                break;
            }
            case 1: {
                Td1Util.prtdbg(string + "len = " + byArray.length + "Just receive info-data from server as:");
                Td1Util.hexDump(System.out, byArray);
                int n3 = this.processinitmsg(byArray, n2);
                if (n3 != 587202860) {
                    throw new GSSException(11, n3, Td1Exception.ErrStr(n3));
                }
                byArray2 = this.DH.genseed();
                if (byArray2.length != this.keysize) {
                    throw new GSSException(11, -486538961, Td1Exception.ErrStr(-486538961));
                }
                if (!this.newDHkey) {
                    this.msgcvt(byArray2);
                }
                Td1Util.prtdbg(string + "Successfully produce seed-generator as ");
                Td1Util.hexDump(System.out, byArray2);
                break;
            }
            case 2: {
                Td1Util.prtdbg(string + "Just received seed-generator from server as:");
                Td1Util.hexDump(System.out, byArray);
                if (byArray.length != this.keysize) {
                    Td1Util.prtdbg(string + "*** ERROR! ILLEGAL LENGTH " + byArray.length + " EXPECTING " + this.keysize);
                    throw new GSSException(11, -486538963, Td1Exception.ErrStr(-486538963));
                }
                if (!this.newDHkey) {
                    this.msgcvt(byArray);
                }
                Td1Util.prtdbg(string + "Client is now satisfied - No more message!");
                break;
            }
            default: {
                throw new GSSException(11, -486538960, Td1Exception.ErrStr(-486538960));
            }
        }
        ++this.msgsequence;
        if (this.isEstablished()) {
            this.Key = this.DH.compute_key(byArray);
            System.arraycopy(this.Key, 0, this.bfKey, 0, this.BFKEYBYTES);
            if (!this.newDHkey) {
                this.msgcvt(this.bfKey);
            }
        }
        Td1Util.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "Td1Context-acceptSecContext:\t";
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                Td1Util.prtdbg(string + "Just receive info-data from client as:");
                Td1Util.hexDump(System.out, byArray);
                int n3 = this.processinitmsg(byArray, n2);
                if (n3 != 587202860) {
                    throw new GSSException(11, n3, Td1Exception.ErrStr(n3));
                }
                byArray2 = this.buildinitmsg();
                Td1Util.prtdbg(string + "Successfully produce info-data as ");
                Td1Util.hexDump(System.out, byArray2);
                break;
            }
            case 1: {
                Td1Util.prtdbg(string + "Just receive seed-generator from client as:");
                Td1Util.hexDump(System.out, byArray);
                if (byArray.length != this.keysize) {
                    Td1Util.prtdbg(string + "*** ERROR! ILLEGAL LENGTH " + byArray.length + " EXPECTING " + this.keysize);
                    throw new GSSException(11, -486538963, Td1Exception.ErrStr(-486538963));
                }
                byArray2 = this.DH.genseed();
                if (byArray2.length != this.keysize) {
                    throw new GSSException(11, -486538961, Td1Exception.ErrStr(-486538961));
                }
                this.msgcvt(byArray2);
                Td1Util.prtdbg(string + "Successfully produce seed-generator as ");
                Td1Util.hexDump(System.out, byArray2);
                Td1Util.prtdbg(string + "Server satisfied now - No more message!");
                break;
            }
            default: {
                throw new GSSException(11, -486538960, Td1Exception.ErrStr(-486538960));
            }
        }
        ++this.msgsequence;
        if (this.isEstablished()) {
            this.Key = this.DH.compute_key(byArray);
            System.arraycopy(this.Key, 0, this.bfKey, 0, this.BFKEYBYTES);
            this.msgcvt(this.bfKey);
        }
        Td1Util.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public int compute_enc_size(int n) {
        int n2 = n & 7;
        int n3 = n;
        if (n2 != 0) {
            n3 = (n & 0xFFFFFFF8) + 8;
        }
        return n3;
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        String string = "Td1Context-isEstablished:\t";
        Td1Util.prtdbg(string + "Entering!");
        try {
            n = this.isserver() ? 2 : 3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        Td1Util.prtdbg(string + "Leaving with retcode = " + bl);
        return bl;
    }

    public boolean isserver() throws GSSException {
        String string = "Td1Context-isserver:\t";
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new GSSException(11);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (n2 < 4) {
            return 0;
        }
        int n3 = n2 - 4;
        int n4 = n3 % 8;
        if (n4 != 0) {
            n3 -= n4;
        }
        return n3;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = n2;
        int n4 = 0;
        String string = "Td1Context-wrap:\t";
        Td1Util.prtdbg(string + "Entering!");
        if (n != 0) {
            Td1Util.prtdbg(string + "ONLY OFFSET = 0 IS ALLOWED!");
            throw new GSSException(16, 587202888, Td1Exception.ErrStr(587202888));
        }
        if (n2 > byArray.length) {
            Td1Util.prtdbg(string + "INPUT LENGTH " + n2 + " IS LARGER THAN BUFFER SIZE " + byArray.length);
            throw new GSSException(11);
        }
        if (!this.blf.d()) {
            this.blf.a(this.bfKey);
        }
        if (this.blf.c()) {
            Td1Util.prtdbg(string + "ECB key is weak!");
        } else {
            Td1Util.prtdbg(string + "Key set Ok!");
        }
        Td1Util.hexDump(System.out, this.bfKey);
        n3 = this.compute_enc_size(n2);
        n4 = n3 + 4;
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = 0;
        }
        byte[] byArray3 = new byte[n4];
        Td1Util.prtdbg(string + "Incoming unencrypted data is ");
        Td1Util.hexDump(System.out, byArray);
        System.arraycopy(byArray, n, byArray2, 0, n2);
        Td1Util.prtdbg(string + "Message with " + n2 + " bytes aligned to " + byArray2.length + " bytes");
        this.msgcvt(byArray2);
        Td1Util.prtdbg(string + "Encrypting now...");
        this.blf.b(byArray2);
        Td1Util.prtdbg(string + "Buffer after encryption");
        Td1Util.hexDump(System.out, byArray2);
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        this.msgcvt(byArray3);
        byte[] byArray4 = this.DH.normalize_key(n3 - n2);
        System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
        Td1Util.prtdbg(string + "Final buffer after byteflip and " + "adding token length into the last 4 bytes ");
        Td1Util.hexDump(System.out, byArray3);
        return byArray3;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = new byte[4];
        String string = "Td1Context-unwrap:\t";
        Td1Util.prtdbg(string + "Entering!");
        if (n != 0) {
            Td1Util.prtdbg(string + "ONLY OFFSET = 0 IS ALLOWED!");
            throw new GSSException(16, 587202888, Td1Exception.ErrStr(587202888));
        }
        if (n2 > byArray.length) {
            Td1Util.prtdbg(string + "INPUT LENGTH " + n2 + " IS LARGER THAN BUFFER SIZE " + byArray.length);
            throw new GSSException(11);
        }
        if (!this.blf.d()) {
            this.blf.a(this.bfKey);
        }
        if (this.blf.c()) {
            Td1Util.prtdbg(string + "ECB key is weak!");
        } else {
            Td1Util.prtdbg(string + "Key set Ok!");
        }
        Td1Util.hexDump(System.out, this.bfKey);
        System.arraycopy(byArray, n2 - 4, byArray2, 0, 4);
        BigInteger bigInteger = new BigInteger(byArray2);
        int n3 = n2 - bigInteger.intValue() - 4;
        Td1Util.prtdbg(string + "original encrypted length in INTEGER is " + n3);
        int n4 = this.compute_enc_size(n3);
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, 0, byArray3, 0, n4);
        Td1Util.prtdbg(string + " Before unwrap");
        Td1Util.hexDump(System.out, byArray3);
        this.msgcvt(byArray3);
        Td1Util.prtdbg(string + "Decrypt now...");
        this.blf.c(byArray3);
        Td1Util.prtdbg(string + " after unwrap");
        Td1Util.hexDump(System.out, byArray3);
        this.msgcvt(byArray3);
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray4, 0, n3);
        Td1Util.prtdbg(string + "Final buffer after byteflip : ");
        Td1Util.hexDump(System.out, byArray4);
        Td1Util.prtdbg(string + "Leaving!");
        return byArray4;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
    }

    public boolean getCredDelegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        if (this.isEstablished()) {
            return this.lifetime;
        }
        return 0;
    }

    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new GSSException(11, 0, "No Context");
        }
        return false;
    }

    public boolean isProtReady() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.isEstablished();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return Td1Mechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new GSSException(16, 1660944692, Td1Exception.ErrStr(1660944692));
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }
}

