/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.Td1Context;
import com.teradata.tdgss.jgssp2td1.Td1Credential;
import com.teradata.tdgss.jgssp2td1.Td1Name;
import com.teradata.tdgss.jgssp2td1.Td1Util;
import com.teradata.tdgss.jgssspi.TDGSSb;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Td1Mechanism
implements TDGSSb {
    private static Oid _mechOid;
    private static Oid GSS_C_NT_TDAT_MECHDATA;
    private static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    private static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    static final int TDATMETHODMAXTOKEN = 64;
    static final int AUTHTERADATA = 8;
    static final String AUTHTERADATASTR;
    static final String prog = "Td1Mechanism";
    static final Oid mechOid;
    static final short servicesAvailable = 98;
    private short servicesNeeded = (short)98;

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        String string = "Td1Mechanism-acceptable:\t";
        if (object == null) {
            Td1Util.prtdbg(string + "Token is null");
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (byArray.length <= 0 || byArray.length > 64) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof Td1Credential)) {
            Td1Util.prtdbg("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            return false;
        }
        return true;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        Td1Util.prtdbg("getContextForAccept ");
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new GSSException(10);
        }
        return new Td1Context((Td1Credential)gSSCredential, objectArray);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        Td1Util.prtdbg("getContextForInit ");
        s = (short)(s & 0x62);
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new GSSException(10);
        }
        return new Td1Context((Td1Credential)gSSCredential, (Td1Name)gSSName, n, objectArray, s);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        String string = "Td1Mechanism-initable:\t";
        if (gSSCredential != null && !(gSSCredential instanceof Td1Credential)) {
            Td1Util.prtdbg(string + "GSSException.DEFECTIVE_CREDENTIAL: " + "must be a credential created by this mech");
            return false;
        }
        if (gSSName != null && !(gSSName instanceof Td1Name)) {
            Td1Util.prtdbg(string + "must be a name created by this mech");
            return false;
        }
        Td1Util.prtdbg(string + "servicesAvailable are " + new Short(98));
        Td1Util.prtdbg(string + "servicesRequested are " + new Short(s));
        return true;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        Td1Name td1Name;
        if (gSSName == null) {
            td1Name = null;
        } else if (gSSName instanceof Td1Name) {
            td1Name = (Td1Name)gSSName;
        } else {
            throw new GSSException(3);
        }
        return new Td1Credential(td1Name, n, n2);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new Td1Name(byArray, oid);
    }

    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA, GSS_C_NT_TDAT_MECHDATA, GSS_C_NT_TDAT_MECHDATA_UTF8, GSS_C_NT_TDAT_MECHDATA_UTF16, GSS_C_NT_TDAT_MECHDATA_UTF32};
        return oidArray;
    }

    public Oid getMech() {
        return mechOid;
    }

    public short getServices() {
        return 98;
    }

    static {
        AUTHTERADATASTR = new String("TERADATA");
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.1.8");
            GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError("Oid string is incorrectly formatted");
        }
        mechOid = _mechOid;
    }
}

