/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jgssp2td2.TDGSSf;
import com.teradata.tdgss.jgssp2td2.Td2Credential;
import com.teradata.tdgss.jgssp2td2.Td2DH;
import com.teradata.tdgss.jgssp2td2.Td2Exception;
import com.teradata.tdgss.jgssp2td2.Td2Mechanism;
import com.teradata.tdgss.jgssp2td2.Td2Name;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jgssp2td2.Td2Version;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class Td2Context
implements GSSContext {
    private static final short maxshort = Short.MAX_VALUE;
    private int msgsequence = 0;
    private byte server_client = 1;
    private byte contextInit = 0;
    private TdgssVersion mylibraryversion;
    private Td2Version mymethodversion;
    private byte myendien = 1;
    private boolean established = false;
    private byte myencryptionmode = (byte)-1;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] Key = null;
    private String[] endien_txt = new String[]{"small endien", "big endien"};
    private short state;
    private boolean initiator;
    private Td2Credential credential;
    private Td2Name targetName;
    private int lifetime;
    private short requestedServices;
    private Td2DH DH;
    private TDGSSf AES;
    private byte[] TrailerBytes;
    private static String[] QOPComp;
    private static Integer[] QOPValues;
    private MessageDigest WrapDigest;
    private MessageDigest GetMicDigest;
    private MessageDigest UnwrapDigest;
    private MessageDigest VerifyMicDigest;
    private int DigestLength;
    private static final String prog = "Td2Context";
    private static final int HEADERLEN = 16;
    private static final int MAXMSGSEQUENCESERVER = 1;
    private int MAXMSGSEQUENCECLIENT = 2;
    protected static final int LIB_MAJOR_REL_VER_INDEX = 16;
    private static final int LIB_MINOR_REL_VER_INDEX = 17;
    private static final int LIB_MAINT_REL_VER_INDEX = 18;
    private static final int LIB_EMG_REL_VER_INDEX = 19;
    protected static final int PKEY_LENGTH = 20;
    private static final int GKEY_LENGTH = 24;
    private static final int PUBLICKEY_LENGTH = 28;
    private static final int VERIFYDHKEY = 32;
    private static final int KEY_DATA = 80;
    private static final int TRAILER_LENGTH = 31;
    private static final byte TDGSS_BIGENDIEN = 1;
    private static final byte TDGSS_SMALLENDIEN = 0;
    private static final byte TDGSS_SERVER = 1;
    private static final byte TDGSS_CLIENT = 0;
    private static final byte TDGSS_ECB = 0;
    private static final byte PROTOCOL_VERSION = 1;
    protected static final byte INITCTXMSG = 1;
    private static final byte ACCEPTCTXMSG = 2;
    private static final byte ENCRYPTMSG = 3;
    private static final byte SIGNATUREMSG = 4;
    private static final byte INITMSG = 1;
    private static final byte CONTMSG = 2;
    private static final byte CLIENT = 0;
    private static final byte SERVER = 1;
    protected static final byte BIT0 = 1;
    private static final byte BIT1 = 2;
    private static final byte BIT2 = 4;
    private static final int BYTESININT = 4;
    private static final int BITSPERBYTE = 8;
    protected static final byte FLAG_BYTE = 12;
    private static final int INITMSGLEN = 64;
    private static final int PUBLICKEYLEN = 64;
    private static final int NOTAPPLICABLE = 65535;
    private int verifyDHKey;
    private int keysize = 64;
    static final String[] msgexttxt;
    static /* synthetic */ Class class$com$teradata$tdgss$jgssp2td2$Td2Context;

    public Td2Context(Td2Credential td2Credential, Object[] objectArray) throws GSSException {
        this.initiator = false;
        this.credential = td2Credential;
        this.requestedServices = (short)98;
        this.InitialiseData();
    }

    public Td2Context(Td2Credential td2Credential, Td2Name td2Name, int n, Object[] objectArray, short s) throws GSSException {
        this.initiator = true;
        this.credential = td2Credential;
        this.targetName = td2Name;
        this.lifetime = n;
        this.requestedServices = s;
        this.InitialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static Td2Version InquireMethodVersion() {
        Td2Version td2Version = new Td2Version();
        return td2Version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitialiseData() throws GSSException {
        this.msgsequence = 0;
        this.mylibraryversion = Td2Context.InquireLibraryVersion();
        this.mymethodversion = Td2Context.InquireMethodVersion();
        this.myendien = 1;
        this.myencryptionmode = 0;
        this.mycbmaxtoken = 80;
        this.DH = new Td2DH();
        Object object = class$com$teradata$tdgss$jgssp2td2$Td2Context == null ? (class$com$teradata$tdgss$jgssp2td2$Td2Context = Td2Context.class$("com.teradata.tdgss.jgssp2td2.Td2Context")) : class$com$teradata$tdgss$jgssp2td2$Td2Context;
        synchronized (object) {
            if (QOPComp == null) {
                TdgssConfigApi tdgssConfigApi = new TdgssConfigApi();
                if (tdgssConfigApi == null) {
                    int n = -520093543;
                    throw new GSSException(11, n, "TdgssConfigApi failure");
                }
                QOPComp = tdgssConfigApi.GetInforForOID(this.getMech().toString());
                if (QOPComp == null) {
                    int n = -520093543;
                    throw new GSSException(11, n, "TdgssConfigApi.GetInfoForOid Failure");
                }
                QOPValues = new Integer[5];
                Td2Context.QOPValues[0] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", QOPComp[0]);
                Td2Context.QOPValues[1] = tdgssConfigApi.GetPropertyForLegal("KeyLength", QOPComp[1]);
                Td2Context.QOPValues[2] = tdgssConfigApi.GetPropertyForLegal("Mode", QOPComp[2]);
                Td2Context.QOPValues[3] = tdgssConfigApi.GetPropertyForLegal("Padding", QOPComp[3]);
                Td2Context.QOPValues[4] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", QOPComp[4]);
                tdgssConfigApi = null;
            }
        }
        try {
            this.WrapDigest = MessageDigest.getInstance(QOPComp[4]);
            this.UnwrapDigest = MessageDigest.getInstance(QOPComp[4]);
            this.GetMicDigest = MessageDigest.getInstance(QOPComp[4]);
            this.VerifyMicDigest = MessageDigest.getInstance(QOPComp[4]);
        }
        catch (Exception exception) {
            int n = -486538839;
            throw new GSSException(11, n, Td2Exception.ErrStr(n));
        }
        object = this.WrapDigest.digest(new byte[0]);
        this.DigestLength = ((Object)object).length;
        this.TrailerBytes = this.GetTrailerBytes();
    }

    private byte[] GetMsgInfo(byte by, byte by2, int n, int n2, int n3) {
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = by;
        byArray[2] = by2;
        try {
            byArray[3] = this.isserver() ? (byte)1 : 0;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
        }
        byte[] byArray2 = Td2Util.inttobytearray(n);
        System.arraycopy(byArray2, 0, byArray, 4, 4);
        byArray2 = Td2Util.inttobytearray(n2);
        System.arraycopy(byArray2, 0, byArray, 8, 4);
        byArray[12] = 2;
        if (n3 != 65535 && n3 == 1) {
            byArray[12] = (byte)(byArray[12] | 4);
        }
        for (int i = 13; i < 16; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    private int[] ValidateMsgInfo(byte[] byArray, int n, int n2, byte by, byte by2) throws GSSException {
        int[] nArray = new int[2];
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        if (byArray2[0] != 1 || byArray2[1] != by || byArray2[2] != by2) {
            throw new GSSException(10);
        }
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray2, 4, byArray3, 0, 4);
        BigInteger bigInteger = new BigInteger(byArray3);
        nArray[0] = bigInteger.intValue();
        if (n2 != nArray[0] + 16) {
            throw new GSSException(10);
        }
        System.arraycopy(byArray2, 8, byArray3, 0, 4);
        bigInteger = new BigInteger(byArray3);
        nArray[1] = bigInteger.intValue();
        return nArray;
    }

    public String[] ParseQOP(int n) throws GSSException {
        return QOPComp;
    }

    private byte[] GetTrailerBytes() throws GSSException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = this.getMech().getDER();
            String string = "0.0." + QOPValues[0] + "." + QOPValues[1] + "." + QOPValues[2] + "." + QOPValues[3] + "." + QOPValues[4] + ".0";
            Oid oid = new Oid(string);
            byte[] byArray3 = oid.getDER();
            byArray = new byte[byArray2.length + 1 + byArray3.length - 1 + 1 + 4 + 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray2.length] = 70;
            System.arraycopy(byArray3, 1, byArray, byArray2.length + 1, byArray3.length - 1);
            byArray[byArray2.length + 1 + byArray3.length - 1] = 1;
            byte[] byArray4 = Td2Util.inttobytearray(byArray.length);
            System.arraycopy(byArray4, 0, byArray, byArray2.length + byArray3.length + 1, 4);
            byArray[byArray2.length + byArray3.length + 1 + 4] = 1;
        }
        catch (GSSException gSSException) {
            System.out.println(gSSException);
        }
        return byArray;
    }

    private byte[] BuildInitMsg(byte by) throws GSSException {
        String string = "Td2Context-BuildInitMsg:\t";
        byte[] byArray = null;
        Object var5_4 = null;
        byte[] byArray2 = null;
        Td2Util.prtdbg(string + "We will initiate the handshake now...");
        Td2Util.prtdbg(string + "Trailer Bytes :");
        byArray2 = this.TrailerBytes;
        if (byArray2 == null) {
            int n = -486538841;
            throw new GSSException(11, n, Td2Exception.ErrStr(n));
        }
        Td2Util.hexDump(System.out, byArray2);
        byArray = new byte[this.mycbmaxtoken + byArray2.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byte[] byArray3 = this.GetMsgInfo(by, (byte)1, 128, 0, 65535);
        System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        byArray[16] = this.mylibraryversion.MajorRelease;
        byArray[17] = this.mylibraryversion.MinorRelease;
        byArray[18] = this.mylibraryversion.MaintenanceRelease;
        byArray[19] = this.mylibraryversion.EmergencyRelease;
        System.arraycopy(byArray2, 0, byArray, this.mycbmaxtoken, byArray2.length);
        Td2Util.prtdbg(string + "Successfully generated first message as");
        Td2Util.hexDump(System.out, byArray);
        return byArray;
    }

    private int ProcessInitMsg(byte[] byArray, int n, int n2) throws GSSException {
        Object var7_4 = null;
        Object var8_5 = null;
        Object var9_6 = null;
        byte[] byArray2 = new byte[4];
        String string = "Td2Context-ProcessInitMsg:\t";
        Td2Util.prtdbg(string + "Receiving and processing first message");
        if (n != 0) {
            Td2Util.prtdbg(string + "Only offset = 0 is allowed!");
            return 587202984;
        }
        this.mytargetendien = (byArray[12] & 2) == 2 ? (byte)1 : 0;
        Td2Util.prtdbg(string + "Checking target endien as " + this.mytargetendien);
        if (this.byteflipneeded()) {
            Td2Util.prtdbg(string + "We have to byte-flip!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            Td2Util.prtdbg(string + "*** Illegal library version *** ");
            return -486538862;
        }
        if (byArray[0] != 1 || byArray[1] != 1 && byArray[1] != 2 || byArray[2] != 1) {
            Td2Util.prtdbg(string + " Message header is not proper");
            return -486538855;
        }
        System.arraycopy(byArray, 32, byArray2, 0, 4);
        this.verifyDHKey = Td2Util.ByteAtoInt(byArray2);
        Td2Util.prtdbg(string + "verifyDHKey= " + this.verifyDHKey);
        Td2Util.prtdbg(string + "The received message is OK!");
        return 587202960;
    }

    private byte[] BuildServerMsg(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = null;
        String string = "Td2Context-BuildServerMsg:\t";
        System.arraycopy(byArray, 20, byArray3, 0, 4);
        int n3 = Td2Util.ByteAtoInt(byArray3);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 80, byArray2, 0, n3);
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        int n4 = Td2Util.ByteAtoInt(byArray5);
        byArray4 = new byte[n4];
        System.arraycopy(byArray, 80 + n3, byArray4, 0, n4);
        System.arraycopy(byArray, 28, byArray8, 0, 4);
        int n5 = Td2Util.ByteAtoInt(byArray8);
        byArray7 = new byte[n5];
        System.arraycopy(byArray, 80 + n3 + n4, byArray7, 0, n5);
        Td2Util.prtdbg(string + "Generate DH Parameters ...");
        this.DH.GenerateParameters(1, byArray4, byArray2);
        Td2Util.prtdbg(string + "Generate DH Public Key ...");
        byte[] byArray10 = this.DH.GenerateKey();
        Td2Util.prtdbg(string + "Compute  DH Private Key ...");
        this.Key = this.DH.ComputeKey(byArray7);
        byte[] byArray11 = this.GetMsgInfo((byte)1, (byte)2, n5, 0, 65535);
        if (this.verifyDHKey > 0) {
            this.MAXMSGSEQUENCECLIENT = 3;
            MessageProp messageProp = new MessageProp(0, true);
            byArray9 = this.wrap(this.Key, 0, this.Key.length, messageProp);
            byArray6 = new byte[16 + n5 + byArray9.length];
            for (int i = 0; i < byArray6.length; ++i) {
                byArray6[i] = 0;
            }
            System.arraycopy(byArray11, 0, byArray6, 0, byArray11.length);
            System.arraycopy(byArray10, 0, byArray6, byArray11.length, byArray10.length);
            System.arraycopy(byArray9, 0, byArray6, byArray11.length + byArray10.length, byArray9.length);
        } else {
            byArray6 = new byte[16 + n5];
            for (int i = 0; i < byArray6.length; ++i) {
                byArray6[i] = 0;
            }
            System.arraycopy(byArray11, 0, byArray6, 0, byArray11.length);
            System.arraycopy(byArray10, 0, byArray6, byArray11.length, byArray10.length);
        }
        Td2Util.prtdbg(string + "The received message is OK!");
        return byArray6;
    }

    public void setkey(byte[] byArray) {
        this.Key = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        String string = "Td2Context-byteflipneeded:\t";
        if (this.mytargetendien != this.myendien) {
            Td2Util.prtdbg(string + "target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            try {
                if (this.isserver()) {
                    Td2Util.prtdbg(string + "We are server! No need to byte-flip!");
                } else {
                    Td2Util.prtdbg(string + "We are client, we have to byte-flip!");
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        String string = "Td2Context-msgcvt:\t";
        if (!this.byteflipneeded()) {
            Td2Util.prtdbg(string + "No flipping needed!");
            return byArray;
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[16] >= 6;
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        Object var7_5 = null;
        String string = "Td2Context-initSecContext:\t";
        Td2Util.prtdbg(string + "msgsequence is now " + this.msgsequence);
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 0;
                Td2Util.prtdbg(string + "Confirming that we are now " + msgexttxt[this.server_client]);
                byArray2 = this.BuildInitMsg((byte)1);
                break;
            }
            case 1: {
                Td2Util.prtdbg(string + "Just receive info-data from server as:");
                Td2Util.hexDump(System.out, byArray);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 != 587202960) {
                    throw new GSSException(11, n3, Td2Exception.ErrStr(n3));
                }
                byArray2 = this.BuildServerMsg(byArray, n, n2);
                break;
            }
            case 2: {
                Td2Util.prtdbg(string + "Key Match Result From Srvr " + byArray[0]);
                if (byArray[0] == 0) break;
                throw new GSSException(11, -486538842, Td2Exception.ErrStr(-486538842));
            }
            default: {
                int n4 = -486538860;
                throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
            }
        }
        ++this.msgsequence;
        Td2Util.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        String string = "Td2Context-acceptSecContext:\t";
        switch (this.msgsequence) {
            case 0: {
                this.server_client = 1;
                Td2Util.prtdbg(string + "Just receive info-data from client as:");
                Td2Util.hexDump(System.out, byArray);
                byArray2 = this.BuildInitMsg((byte)2);
                int n3 = this.ProcessInitMsg(byArray, n, n2);
                if (n3 == 587202960) break;
                throw new GSSException(11, n3, Td2Exception.ErrStr(n3));
            }
            default: {
                int n4 = -486538860;
                throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
            }
        }
        ++this.msgsequence;
        Td2Util.prtdbg(string + "Leaving after incrementing msgsequence to " + this.msgsequence);
        return byArray2;
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public boolean isEstablished() {
        boolean bl = false;
        int n = 0;
        String string = "Td2Context-isEstablished:\t";
        try {
            n = this.isserver() ? 1 : this.MAXMSGSEQUENCECLIENT;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.msgsequence >= n) {
            bl = true;
        }
        Td2Util.prtdbg(string + "Leaving with retcode = " + bl);
        return bl;
    }

    public boolean isserver() throws GSSException {
        String string = "Td2Context-isserver:\t";
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new GSSException(11);
    }

    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (n2 < 16) {
            return 0;
        }
        int n3 = n2 - 16;
        int n4 = n3 - 20;
        return n4;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        Object object;
        String string = "Td2Context-wrap:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        String[] stringArray = this.ParseQOP(messageProp.getQOP());
        String string2 = stringArray[0];
        String string3 = stringArray[1].substring(1);
        int n3 = Integer.parseInt(string3) / 8;
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        Td2Util.prtdbg(string + "EncAlg =" + string2 + "MicAlg = " + stringArray[4] + "kLen = " + string3 + "Mode = " + string4 + "Padding = " + string5);
        SecretKey secretKey = this.DH.BytetoKey(string2, this.Key, 0, n3);
        this.WrapDigest.update(byArray, n, n2);
        byte[] byArray3 = this.WrapDigest.digest();
        byte[] byArray4 = new byte[n2 + byArray3.length];
        Td2Util.prtdbg(string + "OrigLen " + n2 + " MicBuf.length " + byArray3.length);
        System.arraycopy(byArray, n, byArray4, 0, n2);
        System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
        if (this.getConfState() && messageProp.getPrivacy()) {
            object = string2 + "/" + string4 + "/" + string5;
            int n4 = byArray4.length;
            if (string2.equalsIgnoreCase("AES")) {
                try {
                    this.AES = new TDGSSf();
                    this.AES.a(secretKey);
                    Td2Util.hexDump(System.out, secretKey.getEncoded());
                    byArray2 = this.AES.a(byArray4, 0, n4);
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                    int n5 = -486538838;
                    throw new GSSException(11, n5, Td2Exception.ErrStr(n5));
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                    int n6 = -486538838;
                    throw new GSSException(11, n6, Td2Exception.ErrStr(n6));
                }
            } else {
                try {
                    Cipher cipher = Cipher.getInstance((String)object);
                    if (string5.equalsIgnoreCase("NoPadding")) {
                        int n7 = cipher.getBlockSize();
                        n4 = byArray4.length / n7 * n7;
                    }
                    if (string4.equalsIgnoreCase("ECB")) {
                        cipher.init(1, secretKey);
                    } else {
                        byte[] byArray5 = new byte[cipher.getBlockSize()];
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray5[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
                        cipher.init(1, (Key)secretKey, ivParameterSpec);
                    }
                    byArray2 = cipher.doFinal(byArray4, 0, n4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    int n8 = -486538838;
                    throw new GSSException(11, n8, Td2Exception.ErrStr(n8));
                }
            }
        } else {
            byArray2 = byArray4;
        }
        object = new byte[16 + byArray2.length];
        int n9 = this.getConfState() ? 1 : 0;
        byte[] byArray6 = this.GetMsgInfo((byte)3, (byte)2, byArray2.length, messageProp.getQOP(), n9);
        System.arraycopy(byArray2, 0, object, 0, byArray2.length);
        Td2Util.prtdbg(string + "EncBuf " + byArray2.length);
        System.arraycopy(byArray6, 0, object, byArray2.length, byArray6.length);
        Td2Util.prtdbg(string + "Leaving!");
        return object;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        Object object;
        byte[] byArray2;
        byte[] byArray3 = new byte[4];
        String string = "Td2Context-unwrap:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        int[] nArray = this.ValidateMsgInfo(byArray, n, n2, (byte)3, (byte)2);
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, n2 + n - 16, byArray4, 0, 16);
        boolean bl = (byArray4[12] & 4) == 4;
        String[] stringArray = this.ParseQOP(nArray[1]);
        String string2 = stringArray[0];
        String string3 = stringArray[1].substring(1);
        int n3 = Integer.parseInt(string3) / 8;
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        String string6 = stringArray[4];
        SecretKey secretKey = this.DH.BytetoKey(string2, this.Key, 0, n3);
        if (bl) {
            String string7 = string2 + "/" + string4 + "/" + string5;
            if (string2.equalsIgnoreCase("AES")) {
                try {
                    this.AES.a(secretKey);
                    byArray2 = this.AES.b(byArray, n, nArray[0]);
                    Td2Util.hexDump(System.out, byArray2);
                }
                catch (InvalidKeyException invalidKeyException) {
                    invalidKeyException.printStackTrace();
                    int n4 = -486538838;
                    throw new GSSException(11, n4, Td2Exception.ErrStr(n4));
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    illegalBlockSizeException.printStackTrace();
                    int n5 = -486538838;
                    throw new GSSException(11, n5, Td2Exception.ErrStr(n5));
                }
                catch (BadPaddingException badPaddingException) {
                    badPaddingException.printStackTrace();
                    int n6 = -486538838;
                    throw new GSSException(11, n6, Td2Exception.ErrStr(n6));
                }
            } else {
                try {
                    object = Cipher.getInstance(string7);
                    if (string4.equalsIgnoreCase("ECB")) {
                        ((Cipher)object).init(2, secretKey);
                    } else {
                        byte[] byArray5 = new byte[((Cipher)object).getBlockSize()];
                        for (int i = 0; i < byArray5.length; ++i) {
                            byArray5[i] = 0;
                        }
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
                        ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
                    }
                    byArray2 = ((Cipher)object).doFinal(byArray, n, nArray[0]);
                }
                catch (Exception exception) {
                    int n7 = -486538838;
                    throw new GSSException(11, n7, Td2Exception.ErrStr(n7));
                }
            }
        } else {
            byArray2 = new byte[nArray[0]];
            System.arraycopy(byArray, n, byArray2, 0, nArray[0]);
        }
        int n8 = byArray2.length - this.DigestLength;
        this.UnwrapDigest.update(byArray2, 0, n8);
        object = this.UnwrapDigest.digest();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] == byArray2[n8 + i]) continue;
            throw new GSSException(6);
        }
        byte[] byArray6 = new byte[n8];
        System.arraycopy(byArray2, 0, byArray6, 0, n8);
        Td2Util.prtdbg(string + "Leaving!");
        return byArray6;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        String string = "Td2Context-getMIC:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (n < 0 || n2 < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (byArray.length < n2 + n) {
            Td2Util.prtdbg(string + "INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            throw new GSSException(11);
        }
        this.GetMicDigest.update(byArray, n, n2);
        byte[] byArray2 = this.GetMicDigest.digest();
        byte[] byArray3 = this.GetMsgInfo((byte)4, (byte)2, byArray2.length, messageProp.getQOP(), 65535);
        byte[] byArray4 = new byte[16 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, 16);
        Td2Util.prtdbg(string + "Leaving!");
        return byArray4;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        String string = "Td2Context-verifyMIC:\t";
        Td2Util.prtdbg(string + "Entering!");
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            Td2Util.prtdbg(string + "Argument out of Range");
            throw new GSSException(11);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            Td2Util.prtdbg(string + "Input length " + " is larger than buffer size ");
            throw new GSSException(11);
        }
        int[] nArray = this.ValidateMsgInfo(byArray, n, n2, (byte)4, (byte)2);
        String[] stringArray = this.ParseQOP(nArray[1]);
        this.VerifyMicDigest.update(byArray2, n3, n4);
        byte[] byArray3 = this.VerifyMicDigest.digest();
        if (n2 != byArray3.length + 16) {
            Td2Util.prtdbg(string + "Input Mic Length for " + stringArray[4] + " is not " + (this.DigestLength + 16) + " bytes");
            throw new GSSException(6);
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray[n + i]) continue;
            throw new GSSException(6);
        }
        Td2Util.prtdbg(string + "Leaving!");
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public byte[] export() throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new GSSException(11, 0, "Context is established");
        }
        this.lifetime = n;
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
    }

    public boolean getCredDelegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return true;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        if (this.isEstablished()) {
            return this.lifetime;
        }
        return 0;
    }

    public boolean isTransferable() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return false;
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public boolean isProtReady() {
        try {
            if (this.contextInit == 0) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.isEstablished();
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return Td2Mechanism.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        int n = -486538856;
        throw new GSSException(16, n, Td2Exception.ErrStr(n));
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        msgexttxt = new String[]{"client", "server"};
    }
}

