/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jgssp2td2.Td2Mechanism;
import com.teradata.tdgss.jgssp2td2.Td2Name;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Td2Credential
implements GSSCredential {
    private Td2Name name;
    private int initLifetime;
    private int acceptLifetime;
    private int usage;
    private long initEnd;
    private long acceptEnd;
    private boolean indefiniteInit = false;
    private boolean indefiniteAccept = false;
    private boolean acceptOnly = false;
    private boolean initOnly = false;
    private char[] password;

    public Td2Credential(Td2Name td2Name, int n, int n2) throws GSSException {
        this.name = td2Name == null ? new Td2Name(null, null) : td2Name;
        long l = System.currentTimeMillis();
        this.usage = n2;
        if (this.usage != 2) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteInit = true;
            } else {
                this.initLifetime = n;
                this.initEnd = l + (long)this.initLifetime;
            }
        } else {
            this.acceptOnly = true;
        }
        if (n2 != 1) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteAccept = true;
            } else {
                this.acceptLifetime = n;
                this.acceptEnd = l + (long)this.acceptLifetime;
            }
        } else {
            this.initOnly = true;
        }
        if (n2 != 2) {
            this.password = "dummypassword".toCharArray();
        }
    }

    public void dispose() throws GSSException {
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = '\u0000';
        }
        this.password = null;
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid oid) throws GSSException {
        if (oid != Td2Mechanism.mechOid) {
            throw new GSSException(2);
        }
        return this.name;
    }

    public int getRemainingLifetime() throws GSSException {
        int n;
        if (this.initOnly) {
            return this.getRemainingInitLifetime(Td2Mechanism.mechOid);
        }
        if (this.acceptOnly) {
            return this.getRemainingAcceptLifetime(Td2Mechanism.mechOid);
        }
        int n2 = this.getRemainingAcceptLifetime(Td2Mechanism.mechOid);
        return n2 < (n = this.getRemainingInitLifetime(Td2Mechanism.mechOid)) ? n2 : n;
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid != Td2Mechanism.mechOid) {
            throw new GSSException(2);
        }
        if (this.acceptOnly) {
            return 0;
        }
        if (this.indefiniteInit) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.initEnd);
        return n < 0 ? 0 : n;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid != Td2Mechanism.mechOid) {
            throw new GSSException(2);
        }
        if (this.initOnly) {
            return 0;
        }
        if (this.indefiniteAccept) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.acceptEnd);
        return n < 0 ? 0 : n;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        if (oid != Td2Mechanism.mechOid) {
            throw new GSSException(2);
        }
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{Td2Mechanism.mechOid};
        return oidArray;
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        throw new GSSException(2);
    }

    public boolean equals(Object object) {
        try {
            GSSCredential gSSCredential = (GSSCredential)object;
            if (gSSCredential == null) {
                return false;
            }
            if (!gSSCredential.getName().equals(this.name)) {
                return false;
            }
            Oid[] oidArray = gSSCredential.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (gSSCredential.getUsage(oidArray[i]) != this.getUsage(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingAcceptLifetime(oidArray[i]) != this.getRemainingAcceptLifetime(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingInitLifetime(oidArray[i]) == this.getRemainingInitLifetime(oidArray[i])) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    protected char[] getPassword() {
        return this.password;
    }
}

