/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.TDGSSb;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssCredential;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class TdgssContext
implements GSSContext {
    public static TdgssConfigApi capi = new TdgssConfigApi();
    private static final short maxshort = Short.MAX_VALUE;
    private Vector mechanisms;
    private boolean busy = false;
    private boolean initiator;
    private Oid mechOid = null;
    private TdgssName targName = null;
    private TdgssCredential cred = null;
    private int lifetime = 0;
    private ChannelBinding channelBindings = null;
    private short servicesRequested = 0;
    private GSSContext context = null;
    private static final String prog = "TdgssContext";
    private int MsgSequence = 0;

    public TdgssContext(TdgssName tdgssName, Oid oid, TdgssCredential tdgssCredential, int n, TDGSSb[] tDGSSbArray) throws GSSException {
        if (tDGSSbArray == null || tDGSSbArray.length == 0) {
            throw new GSSException(2, 0, "no implementations");
        }
        this.targName = tdgssName;
        this.cred = tdgssCredential;
        this.mechOid = oid;
        this.mechanisms = new Vector(tDGSSbArray.length);
        if (oid != null) {
            for (int i = 0; i < tDGSSbArray.length; ++i) {
                if (!tDGSSbArray[i].getMech().equals(oid)) continue;
                this.mechanisms.addElement(tDGSSbArray[i]);
            }
        } else {
            for (int i = 0; i < tDGSSbArray.length; ++i) {
                this.mechanisms.addElement(tDGSSbArray[i]);
            }
        }
        if (this.mechanisms.size() == 0) {
            throw new GSSException(2, 0, "no mechanisms");
        }
        this.lifetime = n;
        this.initiator = true;
    }

    public TdgssContext(TdgssCredential tdgssCredential, TDGSSb[] tDGSSbArray) throws GSSException {
        this.cred = tdgssCredential;
        this.mechanisms = new Vector(tDGSSbArray.length);
        if (this.mechOid != null) {
            TdgssUtil.prtdbg("TdgssContext Requested mechOid is " + this.mechOid.toString());
            for (int i = 0; i < tDGSSbArray.length; ++i) {
                if (!tDGSSbArray[i].getMech().equals(this.mechOid)) continue;
                this.mechanisms.addElement(tDGSSbArray[i]);
            }
        } else {
            for (int i = 0; i < tDGSSbArray.length; ++i) {
                this.mechanisms.addElement(tDGSSbArray[i]);
            }
        }
        if (this.mechanisms.size() == 0) {
            throw new GSSException(2, 0, "no mechanisms");
        }
        this.initiator = false;
    }

    public TdgssContext(byte[] byArray) throws GSSException {
        throw new GSSException(16, 0, "inter-process token not supported");
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        String string = "TdgssContext-initSecContext:\t";
        if (!this.initiator) {
            throw new GSSException(15);
        }
        if (!this.busy) {
            TdgssUtil.prtdbg(string + "Searching for an appropriate MI");
            if (this.mechanisms.size() == 0) {
                throw new GSSException(11, 0, "No mechnanisms");
            }
            object = this.mechanisms.elements();
            while (object.hasMoreElements()) {
                TDGSSb tDGSSb = (TDGSSb)object.nextElement();
                try {
                    GSSName gSSName = null;
                    if (this.targName != null && (gSSName = this.targName.getNameImplementation(tDGSSb)) == null) continue;
                    GSSCredential gSSCredential = null;
                    if (this.cred != null) {
                        gSSCredential = this.cred.getCredentialImplementation(tDGSSb);
                    }
                    Object[] objectArray = new Object[]{this.channelBindings};
                    TdgssUtil.prtdbg(string + "Checking whether mechanism is initable");
                    if (!tDGSSb.initable(gSSCredential, gSSName, this.lifetime, objectArray, this.servicesRequested)) continue;
                    this.context = tDGSSb.getContextForInit(gSSCredential, gSSName, this.lifetime, objectArray, this.servicesRequested);
                    break;
                }
                catch (GSSException gSSException) {
                    gSSException.printStackTrace();
                }
            }
            if (this.context == null) {
                throw new GSSException(11, 0, "Context is null");
            }
            this.busy = true;
        }
        object = this.context.initSecContext(byArray, n, n2);
        return object;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new GSSException(16, 0, "Stream-based methods not supported yet");
    }

    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        String string = "TdgssContext-acceptSecContext:\t";
        if (byArray == null) {
            throw new GSSException(10);
        }
        if (this.initiator) {
            throw new GSSException(15);
        }
        if (!this.busy) {
            TdgssUtil.prtdbg(string + "Searching for an appropriate MI");
            if (this.mechanisms.size() == 0) {
                throw new GSSException(11, 0, "No mechnanisms");
            }
            Enumeration enumeration = this.mechanisms.elements();
            while (enumeration.hasMoreElements()) {
                TDGSSb tDGSSb = (TDGSSb)enumeration.nextElement();
                try {
                    GSSCredential gSSCredential = null;
                    if (this.cred != null) {
                        gSSCredential = this.cred.getCredentialImplementation(tDGSSb);
                    }
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    Object[] objectArray = new Object[]{this.channelBindings};
                    TdgssUtil.prtdbg(string + "Checking whether mechanism is acceptable");
                    if (!tDGSSb.acceptable(byArray2, gSSCredential, objectArray)) continue;
                    TdgssUtil.prtdbg(string + "Found an acceptable mechanism");
                    this.context = tDGSSb.getContextForAccept(byArray2, gSSCredential, objectArray);
                    TdgssUtil.prtdbg(string + "context is " + this.context);
                    break;
                }
                catch (GSSException gSSException) {
                }
            }
            if (this.context == null) {
                throw new GSSException(11);
            }
            this.busy = true;
        }
        return this.context.acceptSecContext(byArray, n, n2);
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new GSSException(16, 0, "Stream-based methods not supported");
    }

    public boolean isEstablished() {
        if (this.context != null) {
            return this.context.isEstablished();
        }
        return false;
    }

    public void dispose() throws GSSException {
        if (this.context != null) {
            this.context.dispose();
        }
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (this.context != null) {
            return this.context.getWrapSizeLimit(n, bl, n2);
        }
        return 0;
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.wrap(byArray, n, n2, messageProp);
        }
        return null;
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.wrap(inputStream, outputStream, messageProp);
        }
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.unwrap(byArray, n, n2, messageProp);
        }
        return null;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.unwrap(inputStream, outputStream, messageProp);
        }
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.getMIC(byArray, n, n2, messageProp);
        }
        return null;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.getMIC(inputStream, outputStream, messageProp);
        }
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
        }
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.verifyMIC(inputStream, inputStream2, messageProp);
        }
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16, 0, "inter-process tokens not supported");
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestMutualAuth(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 2) : (short)(this.servicesRequested & 0x7FFD);
        }
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestReplayDet(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 4) : (short)(this.servicesRequested & 0x7FFB);
        }
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestSequenceDet(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 8) : (short)(this.servicesRequested & 0x7FF7);
        }
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestCredDeleg(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 1) : (short)(this.servicesRequested & 0x7FFE);
        }
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestAnonymity(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 0x10) : (short)(this.servicesRequested & 0x7FEF);
        }
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestConf(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 0x20) : (short)(this.servicesRequested & 0x7FDF);
        }
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestInteg(bl);
        } else {
            this.servicesRequested = bl ? (short)(this.servicesRequested | 0x40) : (short)(this.servicesRequested & 0x7FBF);
        }
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.context != null) {
            this.context.requestLifetime(n);
        } else {
            this.lifetime = n;
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.busy) {
            throw new GSSException(11);
        }
        this.channelBindings = channelBinding;
    }

    public boolean getCredDelegState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getCredDelegState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getMutualAuthState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getMutualAuthState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getReplayDetState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getReplayDetState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getSequenceDetState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getSequenceDetState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getAnonymityState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getAnonymityState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getConfState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getConfState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean getIntegState() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getIntegState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getLifetime() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.getLifetime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public boolean isTransferable() throws GSSException {
        if (this.context == null) {
            throw new GSSException(11, 0, "No Context");
        }
        return this.context.isTransferable();
    }

    public boolean isProtReady() {
        try {
            if (this.context == null) {
                throw new GSSException(11, 0, "No Context");
            }
            return this.context.isProtReady();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public GSSName getSrcName() throws GSSException {
        if (this.cred != null) {
            return this.cred.getName();
        }
        return null;
    }

    public GSSName getTargName() throws GSSException {
        return this.targName;
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public GSSCredential getDelegCred() throws GSSException {
        if (this.context == null) {
            throw new GSSException(11, 0, "Context is not established");
        }
        return this.context.getDelegCred();
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cred != null) {
            stringBuffer.append("TdgssCredential: ");
            stringBuffer.append(this.cred.toString());
            stringBuffer.append("\n");
        }
        if (this.targName != null) {
            stringBuffer.append("Target: ");
            stringBuffer.append(this.targName.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private byte OidToMechIndex(Oid oid) {
        if (oid.toString().equals("1.3.6.1.4.1.191.1.1012.1.1")) {
            return 0;
        }
        if (oid.toString().equals("1.3.6.1.4.1.191.1.1012.1.3")) {
            return 1;
        }
        if (oid.toString().equals("1.3.6.1.4.1.191.1.1012.1.6")) {
            return 1;
        }
        if (oid.toString().equals("1.3.6.1.4.1.191.1.1012.1.2")) {
            return 3;
        }
        return -1;
    }
}

