/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.TDGSSb;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdgssCredential
implements GSSCredential {
    private Hashtable credImplementations;
    private Vector mechanisms;
    private Oid[] mechOids;
    private TdgssName name;
    private int lifetime;
    private int usage;

    public TdgssCredential(TdgssName tdgssName, int n, Oid[] oidArray, int n2, TDGSSb[] tDGSSbArray) throws GSSException {
        int n3;
        if (tDGSSbArray == null || tDGSSbArray.length == 0) {
            throw new GSSException(11, 0, "No mechanism implementations");
        }
        this.credImplementations = new Hashtable(tDGSSbArray.length);
        this.lifetime = n;
        this.usage = n2;
        this.mechOids = oidArray;
        this.name = tdgssName;
        this.mechanisms = new Vector(tDGSSbArray.length);
        if (oidArray != null) {
            for (n3 = 0; n3 < oidArray.length; ++n3) {
                int n4 = 0;
                for (int i = 0; i < tDGSSbArray.length; ++i) {
                    if (!tDGSSbArray[i].getMech().equals(oidArray[n3])) continue;
                    this.mechanisms.addElement(tDGSSbArray[i]);
                    ++n4;
                }
                if (n4 != 0) continue;
                throw new GSSException(2, 0, "None of the requested mechanisms added");
            }
        } else {
            for (n3 = 0; n3 < tDGSSbArray.length; ++n3) {
                this.mechanisms.addElement(tDGSSbArray[n3]);
            }
        }
        Enumeration enumeration = this.mechanisms.elements();
        while (enumeration.hasMoreElements()) {
            TDGSSb tDGSSb = (TDGSSb)enumeration.nextElement();
            try {
                GSSCredential gSSCredential;
                if (tdgssName != null) {
                    GSSName gSSName = tdgssName.getNameImplementation(tDGSSb);
                    if (gSSName == null) continue;
                    gSSCredential = tDGSSb.createCredential(gSSName, n, n2);
                } else {
                    gSSCredential = tDGSSb.createCredential(null, n, n2);
                }
                this.credImplementations.put(tDGSSb, gSSCredential);
            }
            catch (GSSException gSSException) {
                gSSException.printStackTrace();
            }
        }
        if (this.credImplementations.size() == 0) {
            throw new GSSException(11, 0, "All mechanisms failed");
        }
    }

    public void dispose() throws GSSException {
        Enumeration enumeration = this.credImplementations.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredential gSSCredential = (GSSCredential)enumeration.nextElement();
            gSSCredential.dispose();
        }
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid oid) throws GSSException {
        return this.name.canonicalize(oid);
    }

    public int getRemainingLifetime() throws GSSException {
        throw new GSSException(16);
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        throw new GSSException(16);
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        throw new GSSException(16);
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        return this.mechOids;
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        Object object;
        GSSName gSSName2 = null;
        if (gSSName != null) {
            try {
                object = (TdgssName)gSSName;
                gSSName2 = ((TdgssName)object).canonicalize(oid);
                if (gSSName2 == null) {
                    throw new GSSException(3, 0, "Unable to add name");
                }
            }
            catch (ClassCastException classCastException) {
                throw new GSSException(3, 0, "must be a container name implementation");
            }
        }
        object = null;
        Enumeration enumeration = this.mechanisms.elements();
        while (enumeration.hasMoreElements() && !(object = (TDGSSb)enumeration.nextElement()).getMech().equals(oid)) {
        }
        if (object == null) {
            throw new GSSException(2);
        }
        int n4 = n > n2 ? n : n2;
        GSSCredential gSSCredential = object.createCredential(gSSName2, n4, n3);
        if (gSSCredential == null) {
            throw new GSSException(9);
        }
        this.credImplementations.put(object, gSSCredential);
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.credImplementations.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredential gSSCredential = (GSSCredential)enumeration.nextElement();
            stringBuffer.append(gSSCredential.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    protected GSSCredential getCredentialImplementation(TDGSSb tDGSSb) {
        return (GSSCredential)this.credImplementations.get(tDGSSb);
    }
}

