/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.TDGSSb;
import com.teradata.tdgss.jgssspi.TDGSSe;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssContext;
import com.teradata.tdgss.jtdgss.TdgssCredential;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdgssManager
extends TDGSSe {
    private Vector mechImplementations = new Vector();
    private static final String prog = "TdgssManager";
    static TdgssConfigApi capi;

    public TdgssManager() {
        capi = new TdgssConfigApi();
        String[] stringArray = capi.GetMechanisms();
        int n = 0;
        while (stringArray[n] != null) {
            TDGSSb tDGSSb = (TDGSSb)TdgssManager.createObject(stringArray[n]);
            if (tDGSSb != null) {
                this.mechImplementations.addElement(tDGSSb);
            }
            ++n;
        }
    }

    public static GSSManager getInstance() {
        TdgssManager tdgssManager = new TdgssManager();
        return tdgssManager;
    }

    public Oid[] getMechs() {
        Oid[] oidArray = new Oid[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            oidArray[i] = ((TDGSSb)this.mechImplementations.elementAt(i)).getMech();
        }
        return oidArray;
    }

    public Oid[] getNamesForMech(Oid oid) throws GSSException {
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            if (!((TDGSSb)this.mechImplementations.elementAt(i)).getMech().equals(oid)) continue;
            return ((TDGSSb)this.mechImplementations.elementAt(i)).getNames();
        }
        throw new GSSException(2);
    }

    public Oid[] getMechsForName(Oid oid) {
        return null;
    }

    public GSSName createName(String string, Oid oid) throws GSSException {
        if (string != null) {
            return this.createName(string.getBytes(), oid);
        }
        return this.createName((byte[])null, oid);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        TDGSSb[] tDGSSbArray = new TDGSSb[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            tDGSSbArray[i] = (TDGSSb)this.mechImplementations.elementAt(i);
        }
        TdgssName tdgssName = new TdgssName(byArray, oid, tDGSSbArray);
        return tdgssName;
    }

    public GSSName createName(String string, Oid oid, Oid oid2) throws GSSException {
        if (string != null) {
            try {
                if (oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                    return this.createName(string.getBytes("UTF-16"), oid, oid2);
                }
                if (oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                    return this.createName(string.getBytes("UTF-8"), oid, oid2);
                }
                return this.createName(string.getBytes("US-ASCII"), oid, oid2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
        }
        return this.createName((byte[])null, oid, oid2);
    }

    public GSSName createName(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        TDGSSb[] tDGSSbArray = new TDGSSb[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            tDGSSbArray[i] = (TDGSSb)this.mechImplementations.elementAt(i);
        }
        TdgssName tdgssName = new TdgssName(byArray, oid, tDGSSbArray);
        return tdgssName.canonicalize(oid2);
    }

    public GSSCredential createCredential(int n) throws GSSException {
        return this.createCredential(null, Integer.MAX_VALUE, (Oid[])null, n);
    }

    public GSSCredential createCredential(GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        if (oid != null) {
            Oid[] oidArray = new Oid[]{oid};
            return this.createCredential(gSSName, n, oidArray, n2);
        }
        return this.createCredential(gSSName, n, (Oid[])null, n2);
    }

    public GSSCredential createCredential(GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        TdgssName tdgssName;
        if (gSSName == null) {
            tdgssName = null;
        } else if (gSSName instanceof TdgssName) {
            tdgssName = (TdgssName)gSSName;
        } else {
            throw new GSSException(3, 0, "must be a container name implementation");
        }
        TDGSSb[] tDGSSbArray = new TDGSSb[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            tDGSSbArray[i] = (TDGSSb)this.mechImplementations.elementAt(i);
        }
        return new TdgssCredential(tdgssName, n, oidArray, n2, tDGSSbArray);
    }

    public GSSContext createContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        TdgssCredential tdgssCredential;
        TdgssName tdgssName;
        if (gSSName == null) {
            tdgssName = null;
        } else if (gSSName instanceof TdgssName) {
            tdgssName = (TdgssName)gSSName;
        } else {
            throw new GSSException(3, 0, "must be a container name implementation");
        }
        if (gSSCredential == null) {
            tdgssCredential = null;
        } else if (gSSCredential instanceof TdgssCredential) {
            tdgssCredential = (TdgssCredential)gSSCredential;
        } else {
            throw new GSSException(9, 0, "must be a container credential implementation");
        }
        TDGSSb[] tDGSSbArray = new TDGSSb[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            tDGSSbArray[i] = (TDGSSb)this.mechImplementations.elementAt(i);
        }
        return new TdgssContext(tdgssName, oid, tdgssCredential, n, tDGSSbArray);
    }

    public GSSContext createContext(GSSCredential gSSCredential) throws GSSException {
        TdgssCredential tdgssCredential;
        if (gSSCredential == null) {
            tdgssCredential = null;
        } else if (gSSCredential instanceof TdgssCredential) {
            tdgssCredential = (TdgssCredential)gSSCredential;
        } else {
            throw new GSSException(9, 0, "must be a container credential implementation");
        }
        TDGSSb[] tDGSSbArray = new TDGSSb[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            tDGSSbArray[i] = (TDGSSb)this.mechImplementations.elementAt(i);
        }
        return new TdgssContext(tdgssCredential, tDGSSbArray);
    }

    public GSSContext createContext(byte[] byArray) throws GSSException {
        return new TdgssContext(byArray);
    }

    public TDGSSb[] getMechImplementations() {
        TDGSSb[] tDGSSbArray = new TDGSSb[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            tDGSSbArray[i] = (TDGSSb)this.mechImplementations.elementAt(i);
        }
        return tDGSSbArray;
    }

    public TDGSSb removeMechImplementation(int n) {
        if (n < 0 || n >= this.mechImplementations.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        TDGSSb tDGSSb = (TDGSSb)this.mechImplementations.elementAt(n);
        this.mechImplementations.removeElementAt(n);
        return tDGSSb;
    }

    public void insertMechImplementation(TDGSSb tDGSSb, int n) {
        if (n < 0) {
            this.mechImplementations.insertElementAt(tDGSSb, 0);
        } else if (n >= this.mechImplementations.size()) {
            this.mechImplementations.addElement(tDGSSb);
        } else {
            this.mechImplementations.insertElementAt(tDGSSb, n);
        }
    }

    private void addProviderAt(Provider provider, Oid oid, int n) throws GSSException {
        if (oid == null || provider == null) {
            throw new GSSException(11);
        }
        if (n < 0 || n > this.mechImplementations.size()) {
            throw new GSSException(11);
        }
        String string = provider.getProperty("GSSMechanism-" + oid.toString());
        if (string == null) {
            throw new GSSException(2);
        }
        try {
            TDGSSb tDGSSb;
            Class<?> clazz = Class.forName(string);
            try {
                Constructor<?> constructor = clazz.getConstructor(null);
                Object obj = constructor.newInstance(null);
                tDGSSb = (TDGSSb)obj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Object obj = clazz.newInstance();
                tDGSSb = (TDGSSb)obj;
            }
            this.mechImplementations.add(n, tDGSSb);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            throw new GSSException(16);
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            throw new GSSException(16);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            throw new GSSException(16);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            throw new GSSException(16);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException);
            throw new GSSException(16);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
            throw new GSSException(16);
        }
        catch (ClassCastException classCastException) {
            System.err.println(classCastException);
            throw new GSSException(11);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(arrayIndexOutOfBoundsException);
            throw new GSSException(11);
        }
    }

    public boolean addProvider(Provider provider) {
        String[] stringArray = null;
        try {
            stringArray = (String[])provider.get("GSSMechanism");
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                TDGSSb tDGSSb;
                Object obj;
                Class<?> clazz = Class.forName(stringArray[i]);
                try {
                    Constructor<?> constructor = clazz.getConstructor(null);
                    obj = constructor.newInstance(null);
                    tDGSSb = (TDGSSb)obj;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    obj = clazz.newInstance();
                    tDGSSb = (TDGSSb)obj;
                }
                this.mechImplementations.addElement(tDGSSb);
                bl = true;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return bl;
    }

    public void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        this.addProviderAt(provider, oid, this.mechImplementations.size());
    }

    public void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        this.addProviderAt(provider, oid, 0);
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static void turndebugon(int n) {
    }

    public static Object createObject(String string) {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_1 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.out.println(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return var1_1;
    }

    public String getNameForOid(Oid oid) {
        try {
            String[] stringArray = capi.GetInforForMech(oid);
            return stringArray[0];
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }
}

