/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi;

import java.util.concurrent.atomic.AtomicBoolean;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.LifecycleProcessor;
import org.frameworkset.spi.support.DefaultLifecycleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleProcessorExecutor {
    private static Logger log = LoggerFactory.getLogger(LifeCycleProcessorExecutor.class);
    protected LifecycleProcessor lifecycleProcessor;
    protected BaseApplicationContext context;
    private final AtomicBoolean active = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();

    protected LifecycleProcessor initLifecycleProcessor() {
        if (this.lifecycleProcessor == null) {
            DefaultLifecycleProcessor defaultProcessor = new DefaultLifecycleProcessor();
            defaultProcessor.setApplicationContext(this.context);
            this.lifecycleProcessor = defaultProcessor;
            return defaultProcessor;
        }
        return this.lifecycleProcessor;
    }

    public void setLifecycleProcessor(LifecycleProcessor lifecycleProcessor) {
        this.lifecycleProcessor = lifecycleProcessor;
    }

    public void startProcessor() {
        if (!this.active.compareAndSet(false, true)) {
            return;
        }
        this.initLifecycleProcessor();
        this.getLifecycleProcessor().onRefresh();
    }

    public void stopProcessor() {
        if (this.active.get() && this.closed.compareAndSet(false, true)) {
            if (log.isInfoEnabled()) {
                log.info("Closing " + this);
            }
            try {
                if (this.lifecycleProcessor != null) {
                    this.lifecycleProcessor.onClose();
                    this.lifecycleProcessor = null;
                }
            }
            catch (Throwable ex) {
                log.warn("Exception thrown from LifecycleProcessor on context close", ex);
            }
            this.active.set(false);
        }
    }

    public boolean isProcessorActive() {
        return this.active.get();
    }

    LifecycleProcessor getLifecycleProcessor() throws IllegalStateException {
        if (this.lifecycleProcessor == null) {
            throw new IllegalStateException("LifecycleProcessor not initialized - call 'refresh' before invoking lifecycle methods via the context: " + this);
        }
        return this.lifecycleProcessor;
    }

    public BaseApplicationContext getContext() {
        return this.context;
    }

    public void setContext(BaseApplicationContext context) {
        this.context = context;
    }
}

