package org.frameworkset.spi.runtime;
/**
 * Copyright 2008 biaoping.yin
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.Pro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>Description: </p>
 * <p></p>
 * <p>Copyright (c) 2018</p>
 * @Date 2019/9/28 9:30
 * @author biaoping.yin
 * @version 1.0
 */
public abstract class BaseStarter implements Starter{
	protected Logger logger = LoggerFactory.getLogger(this.getClass());
	public abstract void start(Pro bean, BaseApplicationContext baseApplicationContext);
	public void failed(Pro bean, BaseApplicationContext baseApplicationContext, Throwable throwable){
		logger.info("starter failed:",throwable);
	}

}
