/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.util.DefaultPropertiesPersister;
import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.frameworkset.spi.BeanClassLoaderAware;
import org.frameworkset.spi.support.AbstractMessageSource;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.PropertiesPersister;
import org.frameworkset.util.io.DefaultResourceLoader;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceLoader;

public class ResourceBundleMessageSource
extends AbstractMessageSource
implements BeanClassLoaderAware {
    private String[] basenames = new String[0];
    private ClassLoader bundleClassLoader;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private final Map cachedResourceBundles = new HashMap();
    private final Map cachedBundleMessageFormats = new HashMap();
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                Assert.hasText((String)basename, (String)"Basename must not be empty");
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader != null ? this.bundleClassLoader : this.beanClassLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    @Override
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String result = null;
        for (int i = 0; result == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            result = this.getStringOrNull(bundle, code);
        }
        return result;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            messageFormat = this.getMessageFormat(bundle, code, locale);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        Map map = this.cachedResourceBundles;
        synchronized (map) {
            ResourceBundle bundle;
            HashMap<Locale, ResourceBundle> localeMap = (HashMap<Locale, ResourceBundle>)this.cachedResourceBundles.get(basename);
            if (localeMap != null && (bundle = (ResourceBundle)localeMap.get(locale)) != null) {
                return bundle;
            }
            try {
                bundle = this.doGetBundle(basename, locale);
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException ex) {
                logger.warn("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage());
                ResourceBundle bundle2 = this.doGetDefaultBundle(basename);
                if (localeMap == null) {
                    localeMap = new HashMap();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle2);
                return bundle2;
            }
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
    }

    protected ResourceBundle doGetDefaultBundle(String filename) {
        Resource resource = this.resourceLoader.getResource(filename + PROPERTIES_SUFFIX);
        if (!resource.exists() && !filename.startsWith("classpath:")) {
            resource = this.resourceLoader.getResource("classpath:" + filename + PROPERTIES_SUFFIX);
        }
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(filename + XML_SUFFIX);
        }
        if (!resource.exists() && !filename.startsWith("classpath:")) {
            resource = this.resourceLoader.getResource("classpath:" + filename + XML_SUFFIX);
        }
        ResourceBundle propHolder = null;
        if (resource.exists()) {
            try {
                propHolder = this.loadProperties(resource, filename);
            }
            catch (IOException ex) {
                logger.warn("Could not parse properties file [" + resource.getFilename() + "]", (Throwable)ex);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("No properties file found for [" + filename + "] - neither plain properties nor XML");
        }
        return propHolder;
    }

    protected ResourceBundle loadProperties(Resource resource, String filename) throws IOException {
        InputStream is = resource.getInputStream();
        PropertyResourceBundle ret = new PropertyResourceBundle(is);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle bundle, String code, Locale locale) throws MissingResourceException {
        Map map = this.cachedBundleMessageFormats;
        synchronized (map) {
            MessageFormat result;
            HashMap codeMap = (HashMap)this.cachedBundleMessageFormats.get(bundle);
            HashMap<Locale, MessageFormat> localeMap = null;
            if (codeMap != null && (localeMap = (HashMap<Locale, MessageFormat>)codeMap.get(code)) != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.getStringOrNull(bundle, code);
            if (msg != null) {
                if (codeMap == null) {
                    codeMap = new HashMap();
                    this.cachedBundleMessageFormats.put(bundle, codeMap);
                }
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, MessageFormat>();
                    codeMap.put(code, localeMap);
                }
                MessageFormat result2 = ResourceBundleMessageSource.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }
    }

    private String getStringOrNull(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + SimpleStringUtil.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }
}

