/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.util.VariableHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnvUtil {
    private static Logger log = LoggerFactory.getLogger(EnvUtil.class);

    public static Map evalEnvVariable(Map parent, Map properties) {
        if (!properties.isEmpty()) {
            HashMap<String, String> allProperties = new HashMap<String, String>(properties.size());
            Iterator temp = properties.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            while (temp.hasNext()) {
                Map.Entry entry = temp.next();
                String key = (String)entry.getKey();
                try {
                    EnvUtil.getSystemEnv(parent, builder, null, key, null, properties);
                    allProperties.put(key, builder.toString());
                    builder.setLength(0);
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("", e);
                }
            }
            return allProperties;
        }
        return null;
    }

    public static Map evalEnvVariable(Map properties) {
        if (!properties.isEmpty()) {
            HashMap<String, String> allProperties = new HashMap<String, String>(properties.size());
            Iterator temp = properties.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            while (temp.hasNext()) {
                Map.Entry entry = temp.next();
                String key = (String)entry.getKey();
                try {
                    EnvUtil.getSystemEnv(builder, null, key, null, properties);
                    allProperties.put(key, builder.toString());
                    builder.setLength(0);
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("", e);
                }
            }
            return allProperties;
        }
        return null;
    }

    public static Map evalEnvVariableForObjectContainer(Map properties) {
        if (!properties.isEmpty()) {
            HashMap<String, String> allProperties = new HashMap<String, String>(properties.size());
            Iterator temp = properties.entrySet().iterator();
            StringBuilder builder = new StringBuilder();
            while (temp.hasNext()) {
                Map.Entry entry = temp.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    try {
                        EnvUtil.getSystemEnv(builder, null, key, null, properties);
                        allProperties.put(key, builder.toString());
                        builder.setLength(0);
                    }
                    catch (Throwable e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("", e);
                    }
                    continue;
                }
                allProperties.put(key, (String)value);
            }
            return allProperties;
        }
        return null;
    }

    public static void getSystemEnv(StringBuilder propertiesValue, VariableHandler.Variable variable, String property, String parentName, Map properties) {
        EnvUtil.getSystemEnv(null, propertiesValue, variable, property, parentName, properties);
    }

    public static void getSystemEnv(Map parent, StringBuilder propertiesValue, VariableHandler.Variable variable, String property, String parentName, Map properties) {
        Object value = properties.get(property);
        if (value == null && parent != null) {
            value = parent.get(property);
        }
        if (value != null) {
            String value_ = String.valueOf(value);
            VariableHandler.URLStruction urlStruction = VariableHandler.parserDefaultValueVariableStruction((String)value_);
            if (urlStruction == null) {
                propertiesValue.append(value_);
            } else if (!urlStruction.hasVars()) {
                propertiesValue.append(value_);
            } else {
                EnvUtil.evalStruction(parent, propertiesValue, urlStruction, properties, property);
            }
        } else {
            EnvUtil.evalValue(propertiesValue, variable, parentName, property);
        }
    }

    private static void evalValue(StringBuilder propertiesValue, VariableHandler.Variable variable, String parentName, String property) {
        String value_ = EnvUtil.getSystemEnvDirect(property);
        if (value_ == null && variable != null) {
            value_ = variable.getDefaultValue();
        }
        if (value_ != null) {
            propertiesValue.append(value_);
        } else {
            if (parentName == null) {
                if (variable == null) {
                    throw new IllegalArgumentException("Eval property " + property + " value failed:not set variable value in config file or system environment.");
                }
                throw new IllegalArgumentException("Eval property " + property + " value failed:not set variable value in config file or system environment. variable is " + variable.getOriginVariableName());
            }
            if (log.isWarnEnabled()) {
                if (variable == null) {
                    log.warn("Eval property " + property + " for " + parentName + " value failed:not set variable value in config file or system environment.");
                } else {
                    log.warn("Eval property " + property + " for " + parentName + " value failed:not set variable value in config file or system environment. variable is " + variable.getOriginVariableName());
                }
            }
            propertiesValue.append("#[").append(property).append("]");
        }
    }

    public static String getSystemEnvDirect(String property) {
        String value_ = System.getProperty(property);
        if (value_ == null) {
            value_ = System.getenv(property);
        }
        return value_;
    }

    private static void evalStruction(Map parent, StringBuilder builder, VariableHandler.URLStruction templateStruction, Map properties, String parentName) {
        List tokens = templateStruction.getTokens();
        List variables = templateStruction.getVariables();
        for (int i = 0; i < tokens.size(); ++i) {
            builder.append((String)tokens.get(i));
            if (i >= variables.size()) continue;
            VariableHandler.Variable variable = (VariableHandler.Variable)variables.get(i);
            if (parentName.equals(variable.getVariableName())) {
                EnvUtil.evalValue(builder, variable, parentName, variable.getVariableName());
                continue;
            }
            EnvUtil.getSystemEnv(parent, builder, variable, variable.getVariableName(), parentName, properties);
        }
    }
}

