/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import java.util.HashMap;
import java.util.Map;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.support.HotDeployResourceBundleMessageSource;
import org.frameworkset.spi.support.MessageSource;
import org.frameworkset.util.io.ResourceLoader;

public abstract class MessageSourceUtil {
    protected static Map<String, HotDeployResourceBundleMessageSource> messageSources = new HashMap<String, HotDeployResourceBundleMessageSource>();

    public static MessageSource getMessageSource(String basenames) {
        return MessageSourceUtil.getMessageSource(basenames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MessageSource getMessageSource_(String basenames, ResourceLoader resourceLoader, boolean useCodeAsDefaultMessage, String cachekey) {
        HotDeployResourceBundleMessageSource messageSource = messageSources.get(cachekey);
        if (messageSource != null) {
            return messageSource;
        }
        Map<String, HotDeployResourceBundleMessageSource> map = messageSources;
        synchronized (map) {
            messageSource = messageSources.get(cachekey);
            if (messageSource != null) {
                return messageSource;
            }
            messageSource = new HotDeployResourceBundleMessageSource();
            messageSource.setBasename(basenames);
            if (resourceLoader != null) {
                messageSource.setResourceLoader(resourceLoader);
            }
            messageSource.setUseCodeAsDefaultMessage(useCodeAsDefaultMessage);
            messageSource.setChangemonitor(true);
            messageSources.put(cachekey, messageSource);
            return messageSource;
        }
    }

    public static MessageSource getMessageSource(String basenames, boolean useCodeAsDefaultMessage) {
        return MessageSourceUtil.getMessageSource_(basenames, null, useCodeAsDefaultMessage, basenames);
    }

    public static MessageSource getMessageSource(String[] basenames) {
        return MessageSourceUtil.getMessageSource(basenames, true);
    }

    public static MessageSource getMessageSource(String[] basenames, boolean useCodeAsDefaultMessage) {
        if (basenames == null || basenames.length == 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < basenames.length; ++i) {
            String name = basenames[i];
            if (i > 0) {
                ret.append(",");
            }
            ret.append(name);
        }
        return MessageSourceUtil.getMessageSource(ret.toString(), useCodeAsDefaultMessage);
    }

    static {
        BaseApplicationContext.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                HotDeployResourceBundleMessageSource.stopmonitor();
                if (messageSources != null) {
                    for (Map.Entry<String, HotDeployResourceBundleMessageSource> entry : messageSources.entrySet()) {
                        entry.getValue().destroy();
                    }
                    messageSources.clear();
                    messageSources = null;
                }
            }
        });
    }
}

