/*
 *  Copyright 2008 biaoping.yin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.  
 */
package com.frameworkset.orm.engine.model;

/*
 * Copyright 2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.Serializable;
import java.util.List;



/**
 * Information about unique columns of a table.  This class assumes
 * that in the underlying RDBMS, unique constraints and unique indices
 * are roughly equivalent.  For example, adding a unique constraint to
 * a column also creates an index on that column (this is known to be
 * true for MySQL and Oracle).
 *
 * @author <a href="mailto:jvanzyl@apache.org">Jason van Zyl</a>
 * @author <a href="mailto:dlr@collab.net">Daniel Rall</a>
 * @version $Id: Unique.java,v 1.2 2004/02/22 06:27:19 jmcnally Exp $
 */
public class Unique extends Index implements Serializable 
{
    /**
     * Returns <code>true</code>.
     *
     * @return true
     */
    public final boolean isUnique()
    {
        return true;
    }

    /**
     * String representation of the index. This is an xml representation.
     *
     * @return string representation in xml
     */
    public String toString()
    {
        StringBuilder result = new StringBuilder();
        result.append(" <unique name=\"")
            .append(getName())
            .append("\">\n");

        List columns = getColumns();
        for (int i = 0; i < columns.size(); i++)
        {
            result.append("  <unique-column name=\"")
                .append(columns.get(i))
                .append("\"/>\n");
        }
        result.append(" </unique>\n");
        return result.toString();
    }
}
