/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.daemon;

import com.frameworkset.daemon.WrapperResourceInit;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.UUIDResource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBean {
    private Logger log = LoggerFactory.getLogger(FileBean.class);
    private boolean removeflag = false;
    private File file;
    private long oldModifiedTime;
    private List<WrapperResourceInit> inits;

    public FileBean(File file, WrapperResourceInit init) {
        this.file = file;
        this.inits = new ArrayList<WrapperResourceInit>();
        this.inits.add(init);
        this.oldModifiedTime = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public long getOldModifiedTime() {
        return this.oldModifiedTime;
    }

    public void setOldModifiedTime(long oldModifiedTime) {
        this.oldModifiedTime = oldModifiedTime;
    }

    public boolean checkChanged() {
        if (this.file == null) {
            return false;
        }
        boolean exist = this.file.exists();
        if (!exist) {
            return false;
        }
        long lastModifiedTime = this.file.lastModified();
        return this.oldModifiedTime != lastModifiedTime;
    }

    public synchronized void reinit() {
        long lastModifiedTime;
        if (this.log.isInfoEnabled()) {
            this.log.info("Reload resources in changed file\uff1a" + this.file.getAbsolutePath());
        }
        if ((lastModifiedTime = this.file.lastModified()) == this.oldModifiedTime) {
            return;
        }
        long last = lastModifiedTime;
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            lastModifiedTime = this.file.lastModified();
            if (last == lastModifiedTime) break;
            last = lastModifiedTime;
        }
        this.oldModifiedTime = lastModifiedTime;
        for (int i = 0; this.inits != null && i < this.inits.size(); ++i) {
            WrapperResourceInit init = this.inits.get(i);
            try {
                init.reinit();
                if (!this.log.isInfoEnabled()) continue;
                this.log.info("Reload changed resource file " + init.getUUID() + "@" + this.file.getAbsolutePath() + " sucessed.");
                continue;
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("Reload changed resource  file " + init.getUUID() + "@" + this.file.getAbsolutePath() + " failed:", (Throwable)e);
            }
        }
    }

    public boolean isRemoveflag() {
        return this.removeflag;
    }

    public void setRemoveflag(boolean removeflag) {
        this.removeflag = removeflag;
    }

    public void addResourceInit(WrapperResourceInit init) {
        if (!this.contain(init)) {
            this.inits.add(init);
        }
    }

    private boolean contain(ResourceInitial init) {
        if (init instanceof UUIDResource) {
            String uuid = ((UUIDResource)((Object)init)).getUUID();
            for (int i = 0; i < this.inits.size(); ++i) {
                ResourceInitial initOld = this.inits.get(i);
                if (!(initOld instanceof UUIDResource) || !((UUIDResource)((Object)initOld)).getUUID().equals(uuid)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

