/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.frameworkset.util.StringUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.frameworkset.util.AntPathMatcher;
import org.frameworkset.util.AttackContext;
import org.frameworkset.util.AttackFielterPolicy;
import org.frameworkset.util.PathMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferHelper {
    private static Logger logger = LoggerFactory.getLogger(ReferHelper.class);
    private String[] refererwallwhilelist;
    private String[] encodeParameterWhileList;
    public static final String REQUEST_HEADER_REFER_CHECKED = "REQUEST_HEADER_REFER_CHECKED";
    public static final String REQUEST_HEADER_ORIGIN = "Origin";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private boolean refererDefender = false;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private AttackFielterPolicy attackFielterPolicy;
    public static final String[] wallfilterrules_default = new String[]{"<script", "%3Cscript", "script", "<img", "%3Cimg", "alert(", "alert%28", "eval(", "eval%28", "style=", "style%3D", "javascript", "update ", "drop ", "delete ", "insert ", "create ", "select ", "truncate "};

    public void initAttackFielterPolicy() {
        if (this.attackFielterPolicy != null) {
            this.attackFielterPolicy.init();
        }
    }

    private boolean iswhilerefer(String referer) {
        if (this.refererwallwhilelist == null || this.refererwallwhilelist.length == 0) {
            return false;
        }
        for (String whilereferername : this.refererwallwhilelist) {
            if (!this.pathMatcher.urlContain(whilereferername, referer)) continue;
            return true;
        }
        return false;
    }

    public void setAttackFielterPolicy(AttackFielterPolicy attackFielterPolicy) {
        this.attackFielterPolicy = attackFielterPolicy;
    }

    public AttackFielterPolicy getAttackFielterPolicy() {
        return this.attackFielterPolicy;
    }

    public void recordNoCros(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(REQUEST_HEADER_REFER_CHECKED, (Object)false);
    }

    public boolean dorefer(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean checked = (Boolean)request.getAttribute(REQUEST_HEADER_REFER_CHECKED);
        if (checked != null) {
            return checked;
        }
        checked = false;
        if (this.refererDefender) {
            String referer = request.getHeader("Referer");
            if (referer != null) {
                String basePath = null;
                String basePath80 = null;
                if (!request.getContextPath().equals("/")) {
                    if (request.getServerPort() != 80) {
                        basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
                    } else {
                        basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
                        basePath80 = request.getScheme() + "://" + request.getServerName() + request.getContextPath() + "/";
                    }
                } else if (request.getServerPort() != 80) {
                    basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                } else {
                    basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                    basePath80 = request.getScheme() + "://" + request.getServerName() + request.getContextPath();
                }
                if (basePath80 == null) {
                    if (referer.indexOf(basePath) < 0) {
                        if (this.iswhilerefer(referer)) {
                            checked = false;
                        } else {
                            this.sendInvalidCORS(request, response);
                            checked = true;
                        }
                    }
                } else if (referer.indexOf(basePath) < 0 && referer.indexOf(basePath80) < 0) {
                    if (this.iswhilerefer(referer)) {
                        checked = false;
                    } else {
                        this.sendInvalidCORS(request, response);
                        checked = true;
                    }
                }
            }
        } else {
            checked = false;
        }
        request.setAttribute(REQUEST_HEADER_REFER_CHECKED, (Object)checked);
        return checked;
    }

    public boolean ignoreEncodeParameters(String uri) {
        if (this.encodeParameterWhileList == null || this.encodeParameterWhileList.length == 0) {
            return false;
        }
        for (String p : this.encodeParameterWhileList) {
            if (!this.pathMatcher.urlMatch(p, uri)) continue;
            return true;
        }
        return false;
    }

    public void sendInvalidCORS(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        String accessControlRequestHeaders = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        response.setContentType("text/plain");
        response.setStatus(403);
        response.resetBuffer();
        if (logger.isDebugEnabled()) {
            StringBuilder message = new StringBuilder("Invalid CORS request; Origin=");
            message.append(origin);
            message.append(";Method=");
            message.append(method);
            if (accessControlRequestHeaders != null) {
                message.append(";Access-Control-Request-Headers=");
                message.append(accessControlRequestHeaders);
            }
            logger.debug(message.toString());
        }
    }

    public void sendRedirect403(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!response.isCommitted()) {
            response.sendError(403);
        }
    }

    public String[] getRefererwallwhilelist() {
        return this.refererwallwhilelist;
    }

    public void setRefererwallwhilelist(String[] refererwallwhilelist) {
        this.refererwallwhilelist = refererwallwhilelist;
        if (StringUtil.isNotEmpty((Object)this.refererwallwhilelist)) {
            for (int i = 0; i < this.refererwallwhilelist.length; ++i) {
                this.refererwallwhilelist[i] = this.refererwallwhilelist[i].trim();
            }
        }
    }

    public boolean isRefererDefender() {
        return this.refererDefender;
    }

    public void setRefererDefender(boolean refererDefender) {
        this.refererDefender = refererDefender;
    }

    public String[] getWallfilterrules() {
        if (this.attackFielterPolicy != null) {
            return this.attackFielterPolicy.getXSSWallfilterrules();
        }
        return null;
    }

    public String[] getSensitiveFilterrules() {
        if (this.attackFielterPolicy != null) {
            return this.attackFielterPolicy.getSensitiveWallfilterrules();
        }
        return null;
    }

    public String[] getWallwhilelist() {
        if (this.attackFielterPolicy != null) {
            return this.attackFielterPolicy.getXSSWallwhilelist();
        }
        return null;
    }

    public String[] getSensitiveWallwhilelist() {
        if (this.attackFielterPolicy != null) {
            return this.attackFielterPolicy.getSensitiveWallwhilelist();
        }
        return null;
    }

    public boolean isSensitiveWhilename(String name) {
        String[] wallwhilelist = this.getSensitiveWallwhilelist();
        if (wallwhilelist == null || wallwhilelist.length == 0) {
            return false;
        }
        for (String whilename : wallwhilelist) {
            if (!whilename.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean iswhilename(String name) {
        String[] wallwhilelist = this.getWallwhilelist();
        if (wallwhilelist == null || wallwhilelist.length == 0) {
            return false;
        }
        for (String whilename : wallwhilelist) {
            if (!whilename.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isWhiteUrl(String uri) {
        String[] whiteUrls = this.getWhiteUrls();
        if (whiteUrls == null || whiteUrls.length == 0) {
            return false;
        }
        for (String whiteUrl : whiteUrls) {
            if (!this.pathMatcher.urlMatch(whiteUrl, uri)) continue;
            return true;
        }
        return false;
    }

    public void wallfilter(String name, String[] values, AttackContext attackContext) {
        if (this.attackFielterPolicy.isDisable()) {
            return;
        }
        String[] wallfilterrules = this.getWallfilterrules();
        if (wallfilterrules == null || wallfilterrules.length == 0 || values == null || values.length == 0 || this.iswhilename(name)) {
            return;
        }
        int j = 0;
        for (String value : values) {
            if (value == null || value.equals("")) {
                ++j;
                continue;
            }
            for (int i = 0; i < wallfilterrules.length; ++i) {
                if (!this.attackFielterPolicy.xssCheck(value, wallfilterrules[i])) continue;
                attackContext.setParamName(name);
                attackContext.setValues(values);
                attackContext.setPosition(j);
                attackContext.setAttackRule(wallfilterrules[i]);
                attackContext.setAttackType(0);
                this.attackFielterPolicy.attackHandle(attackContext);
                break;
            }
            ++j;
        }
    }

    public String[] getWhiteUrls() {
        return this.attackFielterPolicy != null ? this.attackFielterPolicy.getWhiteUrls() : null;
    }

    public boolean isDisableAttackDefender() {
        if (this.attackFielterPolicy == null) {
            return true;
        }
        boolean disable = this.attackFielterPolicy.isDisable();
        return disable;
    }

    public void sensitiveWallfilter(String name, String[] values, AttackContext attackContext) {
        if (this.attackFielterPolicy.isDisable()) {
            return;
        }
        String[] wallfilterrules = this.getSensitiveFilterrules();
        if (wallfilterrules == null || wallfilterrules.length == 0 || values == null || values.length == 0 || this.isSensitiveWhilename(name)) {
            return;
        }
        int j = 0;
        for (String value : values) {
            if (value == null || value.equals("")) {
                ++j;
                continue;
            }
            for (int i = 0; i < wallfilterrules.length; ++i) {
                if (!this.attackFielterPolicy.sensitiveCheck(value, wallfilterrules[i])) continue;
                attackContext.setParamName(name);
                attackContext.setValues(values);
                attackContext.setPosition(j);
                attackContext.setAttackRule(wallfilterrules[i]);
                attackContext.setAttackType(1);
                this.attackFielterPolicy.attackHandle(attackContext);
                break;
            }
            ++j;
        }
    }

    public String[] getEncodeParameterWhileList() {
        return this.encodeParameterWhileList;
    }

    public void setEncodeParameterWhileList(String[] encodeParameterWhileList) {
        this.encodeParameterWhileList = encodeParameterWhileList;
    }
}

