/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.cgd.base.mq.MqProducer;
import com.cgd.base.util.DelFormatHelper;
import com.cgd.base.util.JsonUtils;
import com.cgd.commodity.atom.GenerateBrandSeqService;
import com.cgd.commodity.atom.GenerateCommodityPicSeqService;
import com.cgd.commodity.atom.GenerateCommoditySeqService;
import com.cgd.commodity.atom.GeneratePropValueListSeqService;
import com.cgd.commodity.atom.GenerateSkuPicSeqService;
import com.cgd.commodity.atom.GenerateSkuSeqService;
import com.cgd.commodity.atom.GenerateSkuSpecSeqService;
import com.cgd.commodity.atom.GenerateSupplierShopSeqService;
import com.cgd.commodity.atom.QryPropAtomService;
import com.cgd.commodity.atom.bo.GenerateBrandSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateCommodityPicSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateCommoditySeqRspBO;
import com.cgd.commodity.atom.bo.GeneratePropValueListSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateSkuPicSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateSkuSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateSkuSpecSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateSupplierShopSeqRspBO;
import com.cgd.commodity.atom.bo.InfoQryProp;
import com.cgd.commodity.atom.bo.QryProRspBO;
import com.cgd.commodity.atom.bo.QryPropReqBO;
import com.cgd.commodity.busi.BusiAttributeChangeService;
import com.cgd.commodity.busi.CreateSKUService;
import com.cgd.commodity.busi.SkuPriceUpdateService;
import com.cgd.commodity.busi.SkuStateUpdateService;
import com.cgd.commodity.busi.bo.BusiAttributeChangeReqBO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeRspBO;
import com.cgd.commodity.busi.bo.BusiInfoSKUReqBO;
import com.cgd.commodity.busi.bo.BusiInfoSKURspBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateRspBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateRspBO;
import com.cgd.commodity.busi.vo.ElectricityParam;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.dao.CommodityMapper;
import com.cgd.commodity.dao.CommodityPicMapper;
import com.cgd.commodity.dao.EcommerceCatalogMapper;
import com.cgd.commodity.dao.PropValueListMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPicMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.dao.SupplierShopMapper;
import com.cgd.commodity.intfce.bo.BrandConsumerBO;
import com.cgd.commodity.intfce.bo.PropValueListConsumerBO;
import com.cgd.commodity.intfce.bo.SkuSyncExceptionLogBO;
import com.cgd.commodity.po.Brand;
import com.cgd.commodity.po.Commodity;
import com.cgd.commodity.po.CommodityPic;
import com.cgd.commodity.po.EcommerceCatalog;
import com.cgd.commodity.po.PropValueList;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPic;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SkuSpec;
import com.cgd.commodity.po.SkuSyncExceptionLog;
import com.cgd.commodity.po.SupplierShop;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.electricitysupplier.busi.QrySKUFromInterService;
import com.cgd.electricitysupplier.busi.QrySKUImageFromInterService;
import com.cgd.electricitysupplier.busi.QrySkuPriceService;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUImageReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUImageRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKURspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySKUImageRspVO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySkuPriceRspVO;
import com.cgd.electricitysupplier.busi.vo.SKUPicVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSKUServiceImpl
implements CreateSKUService {
    private static final Logger logger = LoggerFactory.getLogger(CreateSKUServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SupplierShopMapper supplierShopMapper;
    private CommodityMapper commodityMapper;
    private CommodityPicMapper commodityPicMapper;
    private SkuPicMapper skuPicMapper;
    private SkuSpecMapper skuSpecMapper;
    private QrySKUFromInterService qrySKUFromInterService;
    private QrySKUImageFromInterService qrySKUImageFromInterService;
    private QryPropAtomService qryPropAtomService;
    private GenerateCommoditySeqService generateCommoditySeqService;
    private GenerateCommodityPicSeqService generateCommodityPicSeqService;
    private GenerateSupplierShopSeqService generateSupplierShopSeqService;
    private GenerateSkuSeqService generateSkuSeqService;
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    private GenerateBrandSeqService generateBrandSeqService;
    private GenerateSkuSpecSeqService generateSkuSpecSeqService;
    private BrandMapper brandMapper;
    private GeneratePropValueListSeqService generatePropValueListSeqService;
    private PropValueListMapper propValueListMapper;
    private QrySkuPriceService qrySkuPriceService;
    private SkuPriceMapper skuPriceMapper;
    private SkuStateUpdateService skuStateUpdateService;
    private SkuPriceUpdateService skuPriceUpdateService;
    private BusiAttributeChangeService busiAttributeChangeService;
    private EcommerceCatalogMapper ecommerceCatalogMapper;

    public void setEcommerceCatalogMapper(EcommerceCatalogMapper ecommerceCatalogMapper) {
        this.ecommerceCatalogMapper = ecommerceCatalogMapper;
    }

    public void setBusiAttributeChangeService(BusiAttributeChangeService busiAttributeChangeService) {
        this.busiAttributeChangeService = busiAttributeChangeService;
    }

    public void setSkuPriceUpdateService(SkuPriceUpdateService skuPriceUpdateService) {
        this.skuPriceUpdateService = skuPriceUpdateService;
    }

    public void setSkuStateUpdateService(SkuStateUpdateService skuStateUpdateService) {
        this.skuStateUpdateService = skuStateUpdateService;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public void setQrySkuPriceService(QrySkuPriceService qrySkuPriceService) {
        this.qrySkuPriceService = qrySkuPriceService;
    }

    public void setGeneratePropValueListSeqService(GeneratePropValueListSeqService generatePropValueListSeqService) {
        this.generatePropValueListSeqService = generatePropValueListSeqService;
    }

    public void setPropValueListMapper(PropValueListMapper propValueListMapper) {
        this.propValueListMapper = propValueListMapper;
    }

    public void setBrandMapper(BrandMapper brandMapper) {
        this.brandMapper = brandMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSupplierShopMapper(SupplierShopMapper supplierShopMapper) {
        this.supplierShopMapper = supplierShopMapper;
    }

    public void setCommodityMapper(CommodityMapper commodityMapper) {
        this.commodityMapper = commodityMapper;
    }

    public void setCommodityPicMapper(CommodityPicMapper commodityPicMapper) {
        this.commodityPicMapper = commodityPicMapper;
    }

    public void setSkuPicMapper(SkuPicMapper skuPicMapper) {
        this.skuPicMapper = skuPicMapper;
    }

    public void setSkuSpecMapper(SkuSpecMapper skuSpecMapper) {
        this.skuSpecMapper = skuSpecMapper;
    }

    public void setQrySKUFromInterService(QrySKUFromInterService qrySKUFromInterService) {
        this.qrySKUFromInterService = qrySKUFromInterService;
    }

    public void setQrySKUImageFromInterService(QrySKUImageFromInterService qrySKUImageFromInterService) {
        this.qrySKUImageFromInterService = qrySKUImageFromInterService;
    }

    public void setQryPropAtomService(QryPropAtomService qryPropAtomService) {
        this.qryPropAtomService = qryPropAtomService;
    }

    public void setGenerateCommoditySeqService(GenerateCommoditySeqService generateCommoditySeqService) {
        this.generateCommoditySeqService = generateCommoditySeqService;
    }

    public void setGenerateCommodityPicSeqService(GenerateCommodityPicSeqService generateCommodityPicSeqService) {
        this.generateCommodityPicSeqService = generateCommodityPicSeqService;
    }

    public void setGenerateSupplierShopSeqService(GenerateSupplierShopSeqService generateSupplierShopSeqService) {
        this.generateSupplierShopSeqService = generateSupplierShopSeqService;
    }

    public void setGenerateSkuSeqService(GenerateSkuSeqService generateSkuSeqService) {
        this.generateSkuSeqService = generateSkuSeqService;
    }

    public void setGenerateSkuPicSeqService(GenerateSkuPicSeqService generateSkuPicSeqService) {
        this.generateSkuPicSeqService = generateSkuPicSeqService;
    }

    public void setGenerateBrandSeqService(GenerateBrandSeqService generateBrandSeqService) {
        this.generateBrandSeqService = generateBrandSeqService;
    }

    public void setGenerateSkuSpecSeqService(GenerateSkuSpecSeqService generateSkuSpecService) {
        this.generateSkuSpecSeqService = generateSkuSpecService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BusiInfoSKURspBO createSKU(BusiInfoSKUReqBO busiInfoSKUReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiInfoSKUReqBO.toString());
        }
        if (null == busiInfoSKUReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiInfoSKUReqBO.getSkuLocation()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5355\u54c1\u4f4d\u7f6e[skuLocation]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiInfoSKUReqBO.getExtSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5916\u90e8SKUID[extSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Sku skuBySupplierIdAndExtSkuId = this.skuMapper.selectBySupplierIdAndExtSkuId(busiInfoSKUReqBO.getSupplierId(), busiInfoSKUReqBO.getExtSkuId());
            if (skuBySupplierIdAndExtSkuId != null) {
                throw new BusinessException("CREATE_SKU_SERVICE_RSP_SKU_EXIST", "\u5546\u54c1\u5df2\u7ecf\u5b58\u5728");
            }
            BusiQrySKURspBO busiQrySKURspBO = this.getBusiQrySKURsp(busiInfoSKUReqBO);
            Sku oldSku = this.skuMapper.selectBySupplierIdAndExtSkuIdAndState(busiInfoSKUReqBO.getSupplierId(), busiInfoSKUReqBO.getExtSkuId());
            if (oldSku != null) {
                if (!"0000".equals(busiQrySKURspBO.getRespCode())) throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u8c03\u7528\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
                if (StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getSku())) throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u8c03\u7528\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
                this.skuInvalidToShelf(oldSku, busiInfoSKUReqBO, busiQrySKURspBO);
                BusiInfoSKURspBO busiInfoSKURspBO = new BusiInfoSKURspBO();
                busiInfoSKURspBO.setIsSuccess(Boolean.valueOf(true));
                busiInfoSKURspBO.setResultDesc("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6267\u884c\u6210\u529f");
                return busiInfoSKURspBO;
            }
            if ("0000".equals(busiQrySKURspBO.getRespCode()) && !StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getSku())) {
                List categories = busiQrySKURspBO.getCategories();
                String catalogCode = null;
                if (null == categories) {
                    String errorMsg = "\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a";
                    this.sendMsgForSkuSyncExceptionLog(busiInfoSKUReqBO, busiQrySKURspBO, errorMsg);
                    throw new BusinessException("CREATE_SKU_SERVICE_RSP_SKU_TYPE_NOT_EXIST", "\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a");
                }
                if (categories.isEmpty()) {
                    String errorMsg = "\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a";
                    this.sendMsgForSkuSyncExceptionLog(busiInfoSKUReqBO, busiQrySKURspBO, errorMsg);
                    throw new BusinessException("CREATE_SKU_SERVICE_RSP_SKU_TYPE_NOT_EXIST", "\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a");
                }
                catalogCode = 1 == busiInfoSKUReqBO.getSupplierId().intValue() ? (String)categories.get(2) : (2 == busiInfoSKUReqBO.getSupplierId().intValue() ? (String)categories.get(0) : (String)categories.get(3));
                EcommerceCatalog ecommerceCatalog = this.ecommerceCatalogMapper.selectByCodeAndSupplierId(catalogCode, busiInfoSKUReqBO.getSupplierId());
                if (null != ecommerceCatalog) {
                    if (null == ecommerceCatalog.getCommodityTypeId()) {
                        String errorMsg = "\u7b2c\u4e09\u65b9\u5546\u54c1\u7c7b\u76ee\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u7c7b\u578b";
                        this.sendMsgForSkuSyncExceptionLog(busiInfoSKUReqBO, busiQrySKURspBO, errorMsg);
                        throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u7b2c\u4e09\u65b9\u5546\u54c1\u7c7b\u76ee\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u7c7b\u578b");
                    }
                    GenerateSkuSeqRspBO generateSkuSeqRspBO = this.generateSkuSeqService.generateSkuSeq();
                    GenerateCommoditySeqRspBO generateCommoditySeqRspBO = this.generateCommoditySeqService.generateCommoditySeq();
                    GenerateBrandSeqRspBO generateBrandSeqRspBO = this.generateBrandSeqService.generateBrandSeq();
                    Brand brand = this.initBrand(generateBrandSeqRspBO, busiInfoSKUReqBO, busiQrySKURspBO, generateSkuSeqRspBO);
                    SupplierShop supplierShop = this.initSupplierShop(busiInfoSKUReqBO);
                    Sku sku = this.initSku(busiInfoSKUReqBO, busiQrySKURspBO, ecommerceCatalog.getCommodityTypeId(), generateCommoditySeqRspBO, generateSkuSeqRspBO, brand);
                    Commodity commodity = this.initCommodity(busiInfoSKUReqBO, ecommerceCatalog.getCommodityTypeId(), generateCommoditySeqRspBO, supplierShop, sku);
                    this.initCommodityPic(commodity, busiQrySKURspBO, busiInfoSKUReqBO);
                    this.initSkuPrice(sku, busiInfoSKUReqBO, busiQrySKURspBO);
                    QryProRspBO qryProRspBO = this.getQryProRsp(busiInfoSKUReqBO, ecommerceCatalog.getCommodityTypeId());
                    if (null != qryProRspBO.getInfoQryProps() && !qryProRspBO.getInfoQryProps().isEmpty()) {
                        this.initSkuSpec(busiInfoSKUReqBO, qryProRspBO, busiQrySKURspBO, commodity, sku);
                    }
                    BusiInfoSKURspBO busiInfoSKURspBO = new BusiInfoSKURspBO();
                    busiInfoSKURspBO.setIsSuccess(Boolean.valueOf(true));
                    busiInfoSKURspBO.setResultDesc("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6267\u884c\u6210\u529f");
                    try {
                        MqProducer.sendMsg((String)"SKU_START_WORKFLOW_TOPIC", (String)CommodityTopicConstant.SKU_START_WORKFLOW_TAG, (Object)sku.getSkuId());
                        return busiInfoSKURspBO;
                    }
                    catch (Exception e) {
                        logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u542f\u52a8\u5de5\u4f5c\u6d41\u6d88\u606f\u5931\u8d25" + e);
                        throw new BusinessException(null, "\u53d1\u9001\u542f\u52a8\u5de5\u4f5c\u6d41\u6d88\u606f\u5931\u8d25");
                    }
                }
                if (this.isDebugEnabled) {
                    logger.debug("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u7b2c\u4e09\u65b9\u5546\u54c1\u7c7b\u76ee\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u7c7b\u578b");
                }
                String errorMsg = "\u7b2c\u4e09\u65b9\u5546\u54c1\u7c7b\u76ee\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u7c7b\u578b";
                this.sendMsgForSkuSyncExceptionLog(busiInfoSKUReqBO, busiQrySKURspBO, errorMsg);
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u7b2c\u4e09\u65b9\u5546\u54c1\u7c7b\u76ee\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u7c7b\u578b");
            }
            if (!this.isDebugEnabled) throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u8c03\u7528\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            logger.debug("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u8c03\u7528\u67e5\u8be2SKU\u8be6\u7ec6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            String resultCode = "";
            if (!(e instanceof BusinessException)) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            if (org.springframework.util.StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode())) {
                resultCode = "CREATE_SKU_SERVICE_RSP_FAIL";
                throw new BusinessException(resultCode, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            }
            resultCode = ((BusinessException)e).getMsgCode();
            throw new BusinessException(resultCode, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }

    private BusiQrySKURspBO getBusiQrySKURsp(BusiInfoSKUReqBO busiInfoSKUReqBO) {
        try {
            BusiQrySKUReqBO busiQrySKUReqBO = new BusiQrySKUReqBO();
            busiQrySKUReqBO.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            busiQrySKUReqBO.setExtSkuId(busiInfoSKUReqBO.getExtSkuId());
            busiQrySKUReqBO.setIsExtSkuId(Boolean.valueOf(true));
            return this.qrySKUFromInterService.qrySKUInfo(busiQrySKUReqBO);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528sku\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException(null, "\u8c03\u7528sku\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void sendMsgForSkuSyncExceptionLog(BusiInfoSKUReqBO busiInfoSKUReqBO, BusiQrySKURspBO busiQrySKURspBO, String errorMsg) {
        SkuSyncExceptionLogBO skuSyncExceptionLogBO = new SkuSyncExceptionLogBO();
        try {
            SkuSyncExceptionLog skuSyncExceptionLog = new SkuSyncExceptionLog();
            skuSyncExceptionLog.setExtSkuId(busiQrySKURspBO.getSku());
            skuSyncExceptionLog.setSkuName(busiQrySKURspBO.getName());
            skuSyncExceptionLog.setSkuLocation(busiInfoSKUReqBO.getSkuLocation());
            skuSyncExceptionLog.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            skuSyncExceptionLog.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
            skuSyncExceptionLog.setCreateTime(new Date());
            skuSyncExceptionLog.setIsDelete(Constant.IS_DELETE);
            skuSyncExceptionLog.setErrorMsg(errorMsg);
            BeanUtils.copyProperties((Object)skuSyncExceptionLogBO, (Object)skuSyncExceptionLog);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25");
        }
        try {
            MqProducer.sendMsg((String)"SKU_SYNC_INSERT_TOPIC", (String)CommodityTopicConstant.SKU_SYNC_INSERT_TAG, (Object)skuSyncExceptionLogBO);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25" + e);
            throw new BusinessException(null, "\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25");
        }
    }

    private QryProRspBO getQryProRsp(BusiInfoSKUReqBO busiInfoSKUReqBO, Long commdotiyTypeId) {
        try {
            QryPropReqBO qryPropReqBO = new QryPropReqBO();
            qryPropReqBO.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            qryPropReqBO.setCommodityTypeId(commdotiyTypeId);
            return this.qryPropAtomService.QryPropByCommodityTypeId(qryPropReqBO);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5546\u54c1\u7c7b\u578b\u5c5e\u6027\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException(null, "\u8c03\u7528\u5546\u54c1\u7c7b\u578b\u5c5e\u6027\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5931\u8d25");
        }
    }

    private Sku initSku(BusiInfoSKUReqBO busiInfoSKUReqBO, BusiQrySKURspBO busiQrySKURspBO, Long commdotiyTypeId, GenerateCommoditySeqRspBO generateCommoditySeqRspBO, GenerateSkuSeqRspBO generateSkuSeqRspBO, Brand brand) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(generateSkuSeqRspBO.getSkuId());
            sku.setCommodityId(generateCommoditySeqRspBO.getCommodityId());
            sku.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            sku.setSupplierName(busiInfoSKUReqBO.getSupplierName());
            sku.setExtSkuId(busiInfoSKUReqBO.getExtSkuId());
            sku.setUpcCode(busiQrySKURspBO.getUpc());
            sku.setCommodityTypeId(commdotiyTypeId);
            sku.setSkuLocation(busiInfoSKUReqBO.getSkuLocation());
            sku.setSkuName(busiQrySKURspBO.getName());
            sku.setSkuMainPicUrl(busiQrySKURspBO.getImagePath());
            sku.setSkuDetail(busiQrySKURspBO.getIntroduction());
            sku.setPackParam(busiQrySKURspBO.getWareQD());
            sku.setSkuStatus(Constant.SKU_STATUS_SHELVEING);
            sku.setBrandId(brand.getBrandId());
            sku.setBrandName(busiQrySKURspBO.getBrandName());
            sku.setIsSupplierAgreement(Constant.IS_NOT_SUPPLIER_AGREEMENT);
            sku.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
            sku.setCreateTime(new Date());
            sku.setIsDelete(Constant.IS_DELETE);
            sku.setMfgSku(busiQrySKURspBO.getMfgSku());
            sku.setMoq(busiQrySKURspBO.getMoq());
            this.skuMapper.insertSelective(sku);
            return sku;
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1sku\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1SKU\u5931\u8d25");
        }
    }

    private Commodity initCommodity(BusiInfoSKUReqBO busiInfoSKUReqBO, Long commdotiyTypeId, GenerateCommoditySeqRspBO generateCommoditySeqRspBO, SupplierShop supplierShop, Sku sku) {
        try {
            Commodity commodity = new Commodity();
            commodity.setCommodityCode(String.valueOf(sku.getSkuId()));
            commodity.setCommodityLocation(new Long(busiInfoSKUReqBO.getSkuLocation().intValue()));
            commodity.setCommodityTypeId(commdotiyTypeId);
            commodity.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            commodity.setSupplierName(busiInfoSKUReqBO.getSupplierName());
            commodity.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
            commodity.setCreateTime(new Date());
            commodity.setIsDelete(Constant.IS_DELETE);
            commodity.setCommodityId(generateCommoditySeqRspBO.getCommodityId());
            commodity.setSupplierShopId(supplierShop.getSupplierId());
            this.commodityMapper.insertSelective(commodity);
            return commodity;
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1SPU\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\uff08SPU\uff09\u5931\u8d25");
        }
    }

    private SupplierShop initSupplierShop(BusiInfoSKUReqBO busiInfoSKUReqBO) {
        try {
            SupplierShop oldSupplierShop = this.supplierShopMapper.selectBySupplierId(busiInfoSKUReqBO.getSupplierId());
            if (null == oldSupplierShop) {
                GenerateSupplierShopSeqRspBO generateSupplierShopSeqRspBO = this.generateSupplierShopSeqService.generateSupplierShopSeq();
                SupplierShop supplierShop = new SupplierShop();
                supplierShop.setSupplierShopId(generateSupplierShopSeqRspBO.getSupplierShopId());
                supplierShop.setSupplierId(busiInfoSKUReqBO.getSupplierId());
                supplierShop.setShopName(busiInfoSKUReqBO.getSupplierName());
                supplierShop.setShopStatus(Constant.SHOP_STATUS_OPEN);
                supplierShop.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
                supplierShop.setCreateTime(new Date());
                supplierShop.setIsDelete(Constant.IS_DELETE);
                return supplierShop;
            }
            return oldSupplierShop;
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u8d27\u94fa\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u4f9b\u5e94\u5546\u8d27\u94fa\u5931\u8d25");
        }
    }

    private void initCommodityPic(Commodity commodity, BusiQrySKURspBO busiQrySKURspBO, BusiInfoSKUReqBO busiInfoSKUReqBO) {
        try {
            GenerateCommodityPicSeqRspBO generateCommodityPicSeqRspBO = this.generateCommodityPicSeqService.generateCommodityPicSeq();
            CommodityPic commodityPic = new CommodityPic();
            commodityPic.setCommodityPicId(generateCommodityPicSeqRspBO.getCommodityPicId());
            commodityPic.setCommodityId(commodity.getCommodityId());
            if (null != busiQrySKURspBO) {
                commodityPic.setCommodityPicUrl(busiQrySKURspBO.getImagePath());
            }
            commodityPic.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            commodityPic.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
            commodityPic.setCreateTime(new Date());
            commodityPic.setIsDelete(Constant.IS_DELETE);
            this.commodityPicMapper.insertSelective(commodityPic);
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1SPU\u56fe\u7247\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1SPU\u56fe\u7247\u5931\u8d25");
        }
    }

    private void initSkuPrice(Sku sku, BusiInfoSKUReqBO busiInfoSKUReqBO, BusiQrySKURspBO busiQrySKURspBO) {
        try {
            if (null != busiQrySKURspBO) {
                SkuPrice skuPrice = new SkuPrice();
                skuPrice.setSkuId(sku.getSkuId());
                if (null != busiQrySKURspBO.getNegoPrice()) {
                    if (1L == busiInfoSKUReqBO.getSupplierId()) {
                        skuPrice.setAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySKURspBO.getNegoPrice()));
                        Double price = (double)MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySKURspBO.getNegoPrice()).longValue() * 1.0;
                        skuPrice.setMemberPrice(price.longValue());
                        skuPrice.setSalePrice(price.longValue());
                    } else {
                        skuPrice.setAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySKURspBO.getNegoPrice()));
                        Double price = (double)MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySKURspBO.getNegoPrice()).longValue() * 1.04;
                        skuPrice.setMemberPrice(price.longValue());
                        skuPrice.setSalePrice(price.longValue());
                    }
                }
                if (null != busiQrySKURspBO.getMarketPrice()) {
                    skuPrice.setMarketPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySKURspBO.getMarketPrice()));
                }
                skuPrice.setSupplierId(busiInfoSKUReqBO.getSupplierId());
                skuPrice.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
                skuPrice.setCreateTime(new Date());
                skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
                skuPrice.setIsDelete(Constant.IS_DELETE);
                if (null != busiQrySKURspBO.getNegoPrice()) {
                    this.skuPriceMapper.insert(skuPrice);
                }
            }
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25");
        }
    }

    private void initSkuPic(Commodity commodity, GenerateSkuSeqRspBO generateSkuSeqRspBO, BusiInfoSKUReqBO busiInfoSKUReqBO) {
        try {
            BusiQrySKUImageReqBO busiQrySKUImageReqBO = new BusiQrySKUImageReqBO();
            busiQrySKUImageReqBO.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            ArrayList<String> extSkuIds = new ArrayList<String>();
            extSkuIds.add(busiInfoSKUReqBO.getExtSkuId());
            BusiQrySKUImageRspBO busiQrySKUImageRspBO = this.qrySKUImageFromInterService.qrySKUImage(busiQrySKUImageReqBO);
            if (!busiQrySKUImageRspBO.getSkuImages().isEmpty()) {
                ArrayList<SkuPic> skuPics = new ArrayList<SkuPic>();
                List busiQrySKUImageRsps = busiQrySKUImageRspBO.getSkuImages();
                if (!busiQrySKUImageRsps.isEmpty()) {
                    for (BusiQrySKUImageRspVO busiQrySKUImageRspVO : busiQrySKUImageRsps) {
                        List sKUPicVOs = busiQrySKUImageRspVO.getSkuPic();
                        if (sKUPicVOs.isEmpty()) continue;
                        for (SKUPicVO imageInfo : sKUPicVOs) {
                            GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                            SkuPic skuPic = new SkuPic();
                            skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                            skuPic.setCommodityId(commodity.getCommodityId());
                            skuPic.setSkuId(generateSkuSeqRspBO.getSkuId());
                            skuPic.setSkuPicUrl(imageInfo.getPath());
                            skuPic.setSupplierId(busiInfoSKUReqBO.getSupplierId());
                            skuPic.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
                            skuPic.setCreateTime(new Date());
                            skuPic.setIsDelete(Constant.IS_DELETE);
                            skuPic.setPicOrder(imageInfo.getOrderSort());
                            skuPic.setIsPrimary(imageInfo.getIsPrimary());
                            skuPics.add(skuPic);
                        }
                    }
                }
                if (skuPics != null) {
                    this.skuPicMapper.insertSkuPicBatch(skuPics);
                }
            }
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316SKU\u56fe\u7247\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1SKU\u56fe\u7247\u5931\u8d25");
        }
    }

    private Brand initBrand(GenerateBrandSeqRspBO generateBrandSeqRspBO, BusiInfoSKUReqBO busiInfoSKUReqBO, BusiQrySKURspBO busiQrySKURspBO, GenerateSkuSeqRspBO generateSkuSeqRspBO) {
        try {
            Brand oldBrand = this.brandMapper.selectByName(busiQrySKURspBO.getBrandName());
            if (null == oldBrand) {
                Brand brand = new Brand();
                brand.setBrandId(generateBrandSeqRspBO.getBrandId());
                brand.setBrandName(busiQrySKURspBO.getBrandName());
                brand.setEffTime(DelFormatHelper.getNowYearAndMonthDay());
                brand.setExpTime(DelFormatHelper.getNowYearAndMonthDay((String)"2050-12-31"));
                brand.setBrandStatus(Constant.BRAND_STATUS_OPEN);
                brand.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
                brand.setCreateTime(new Date());
                brand.setIsDelete(Constant.IS_DELETE);
                BrandConsumerBO brandConsumerBO = new BrandConsumerBO();
                BeanUtils.copyProperties((Object)brandConsumerBO, (Object)brand);
                MqProducer.sendMsg((String)"BRAND_INSERT_TOPIC", (String)CommodityTopicConstant.BRAND_INSERT_TAG, (Object)brandConsumerBO);
                return brand;
            }
            return oldBrand;
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u6d88\u606f\u751f\u6210\u54c1\u724c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u54c1\u724c\u5931\u8d25");
        }
    }

    private void initSkuSpec(BusiInfoSKUReqBO busiInfoSKUReqBO, QryProRspBO qryProRspBO, BusiQrySKURspBO busiQrySKURspBO, Commodity commodity, Sku sku) {
        try {
            ArrayList<String> propNames;
            ArrayList<SkuSpec> skuSpecs = new ArrayList<SkuSpec>();
            ArrayList<String> errorMsgs = new ArrayList<String>();
            if (Constant.JDSupplierId.intValue() == busiInfoSKUReqBO.getSupplierId().intValue()) {
                if (null != busiQrySKURspBO.getAttribute()) {
                    for (Map.Entry attributeEntry : busiQrySKURspBO.getAttribute().entrySet()) {
                        if (!(attributeEntry.getValue() instanceof Map)) continue;
                        Map propMap = (Map)attributeEntry.getValue();
                        propNames = new ArrayList();
                        for (InfoQryProp infoQryProp : qryProRspBO.getInfoQryProps()) {
                            propNames.add(infoQryProp.getExtPropName());
                        }
                        for (Map.Entry entry : propMap.entrySet()) {
                            String propName = (String)entry.getKey();
                            for (InfoQryProp infoQryProp : qryProRspBO.getInfoQryProps()) {
                                if (!infoQryProp.getExtPropName().equals(propName)) continue;
                                PropValueList propValueList = this.initPropValueList(infoQryProp, propName, (String)entry.getValue());
                                SkuSpec skuSpec = this.initSkuSpec(commodity, sku, busiInfoSKUReqBO, infoQryProp, propName, (String)entry.getValue(), propValueList);
                                if (skuSpec == null) continue;
                                skuSpecs.add(skuSpec);
                            }
                            if (propNames.contains(propName)) continue;
                            logger.info("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\uff1a\u5916\u90e8\u5546\u54c1skuId=[" + sku.getExtSkuId() + "]\u5c5e\u6027\u4e3a[" + (String)propName + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                            String errorMsg = "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\uff1a\u5916\u90e8\u5546\u54c1skuId=[" + sku.getExtSkuId() + "]\u5c5e\u6027\u4e3a[" + (String)propName + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728";
                            if (errorMsgs.contains(errorMsg)) continue;
                            errorMsgs.add(errorMsg);
                        }
                    }
                }
            } else {
                String params = JSONArray.toJSONString(busiQrySKURspBO.getAttribute().get("param"));
                if (!"null".equals(params)) {
                    ElectricityParam[] electricityParamArr = (ElectricityParam[])JsonUtils.jsonStringToJavaBean((String)params, ElectricityParam[].class);
                    List<ElectricityParam> electricityParams = Arrays.asList(electricityParamArr);
                    propNames = new ArrayList<String>();
                    for (InfoQryProp infoQryProp : qryProRspBO.getInfoQryProps()) {
                        propNames.add(infoQryProp.getExtPropName());
                    }
                    for (ElectricityParam electricityParam : electricityParams) {
                        for (InfoQryProp infoQryProp : qryProRspBO.getInfoQryProps()) {
                            if (!infoQryProp.getExtPropName().equals(electricityParam.getAttrName())) continue;
                            PropValueList propValueList = this.initPropValueList(infoQryProp, electricityParam.getAttrName(), electricityParam.getAttrValue());
                            SkuSpec skuSpec = this.initSkuSpec(commodity, sku, busiInfoSKUReqBO, infoQryProp, electricityParam.getAttrName(), electricityParam.getAttrValue(), propValueList);
                            if (skuSpec == null) continue;
                            skuSpecs.add(skuSpec);
                        }
                        if (propNames.contains(electricityParam.getAttrName())) continue;
                        logger.info("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\uff1a\u5916\u90e8\u5546\u54c1skuId=[" + sku.getExtSkuId() + "]\u5c5e\u6027\u4e3a[" + electricityParam.getAttrName() + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                        String errorMsg = "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\uff1a\u5916\u90e8\u5546\u54c1skuId=[" + sku.getExtSkuId() + "]\u5c5e\u6027\u4e3a[" + electricityParam.getAttrName() + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728";
                        if (errorMsgs.contains(errorMsg)) continue;
                        errorMsgs.add(errorMsg);
                    }
                }
            }
            if (!errorMsgs.isEmpty()) {
                for (String string : errorMsgs) {
                    this.sendMsgForSkuSyncExceptionLog(busiInfoSKUReqBO, busiQrySKURspBO, string);
                }
            }
            if (skuSpecs != null && skuSpecs.size() > 0) {
                this.skuSpecMapper.insertSkuSpecBatch(skuSpecs);
            }
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u5931\u8d25");
        }
    }

    private SkuSpec initSkuSpec(Commodity commodity, Sku sku, BusiInfoSKUReqBO busiInfoSKUReqBO, InfoQryProp infoQryProp, String propName, String propValue, PropValueList propValueList) {
        try {
            GenerateSkuSpecSeqRspBO generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
            SkuSpec skuSpec = new SkuSpec();
            skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
            skuSpec.setCommodityId(commodity.getCommodityId());
            skuSpec.setSkuId(sku.getSkuId());
            skuSpec.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            skuSpec.setCommodityPropGrpId(infoQryProp.getCommodityPropGrpId());
            skuSpec.setCommoditySpecId(infoQryProp.getCommodityPropDefId());
            skuSpec.setPropName(propName);
            skuSpec.setPropValue(propValue);
            skuSpec.setPropShowName(infoQryProp.getPropName());
            skuSpec.setCreateLoginId(busiInfoSKUReqBO.getCreateLoginId());
            skuSpec.setCreateTime(new Date());
            skuSpec.setIsDelete(Constant.IS_DELETE);
            if (null != propValueList) {
                skuSpec.setPropValueListId(propValueList.getPropValueListId());
            }
            return skuSpec;
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u5b9e\u4f53\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u5b9e\u4f53\u5931\u8d25");
        }
    }

    private PropValueList initPropValueList(InfoQryProp infoQryProp, String propName, String propValue) {
        try {
            PropValueList propValueList = new PropValueList();
            propValueList.setCommodityPropDefId(infoQryProp.getCommodityPropDefId());
            propValueList.setPropCode(infoQryProp.getPropName());
            propValueList.setPropValue(propValue);
            PropValueList oldPropValueList = this.propValueListMapper.selectByValue(propValueList);
            if (null == oldPropValueList) {
                GeneratePropValueListSeqRspBO generatePropValueListSeqRspBO = this.generatePropValueListSeqService.generatePropValueListSeq();
                oldPropValueList = new PropValueList();
                oldPropValueList.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                PropValueListConsumerBO propValueListConsumerBO = new PropValueListConsumerBO();
                propValueListConsumerBO.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                propValueListConsumerBO.setCommodityPropDefId(infoQryProp.getCommodityPropDefId());
                propValueListConsumerBO.setPropCode(propName);
                propValueListConsumerBO.setPropValue(propValue);
                propValueListConsumerBO.setCreateTime(new Date());
                propValueListConsumerBO.setIsDelete(Byte.valueOf(Constant.IS_DELETE.byteValue()));
                MqProducer.sendMsg((String)"PROPVALUELIST_INSERT_TOPIC", (String)CommodityTopicConstant.PROPVALUELIST_INSERT_TAG, (Object)propValueListConsumerBO);
            }
            return oldPropValueList;
        }
        catch (Exception e) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skuInvalidToShelf(Sku oldSku, BusiInfoSKUReqBO busiInfoSKUReqBO, BusiQrySKURspBO busiQrySKURspBO) throws Exception {
        SkuStateUpdateReqBO skuStateUpdateReqBO = new SkuStateUpdateReqBO();
        skuStateUpdateReqBO.setExtSkuId(oldSku.getExtSkuId());
        skuStateUpdateReqBO.setSkuState(Constant.SKU_STATUS_SHELVEING);
        skuStateUpdateReqBO.setSupplierId(oldSku.getSupplierId());
        SkuStateUpdateRspBO skuStateUpdateRspBO = this.skuStateUpdateService.updateSkuState(skuStateUpdateReqBO);
        if (!"0000".equals(skuStateUpdateRspBO.getRespCode())) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuStateUpdateRspBO.getRespDesc());
            throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuStateUpdateRspBO.getRespDesc());
        }
        if (!skuStateUpdateRspBO.getIsSuccess().booleanValue()) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuStateUpdateRspBO.getResultMsg());
            throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuStateUpdateRspBO.getResultMsg());
        }
        BusiQrySkuPriceReqBO busiQrySkuPriceReqBO = new BusiQrySkuPriceReqBO();
        busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(true));
        busiQrySkuPriceReqBO.setSupplierId(busiInfoSKUReqBO.getSupplierId());
        ArrayList<String> extSkuIds = new ArrayList<String>();
        extSkuIds.add(busiInfoSKUReqBO.getExtSkuId());
        busiQrySkuPriceReqBO.setExtSkuIds(extSkuIds);
        BusiQrySkuPriceRspBO busiQrySkuPriceRspBO = this.qrySkuPriceService.qrySkuPrice(busiQrySkuPriceReqBO);
        if ("0000".equals(busiQrySkuPriceRspBO.getRespCode()) && !busiQrySkuPriceRspBO.getSkuPrices().isEmpty()) {
            SkuPriceUpdateReqBO skuPriceUpdateReqBO = new SkuPriceUpdateReqBO();
            BusiQrySkuPriceRspVO busiQrySkuPriceRspVO = (BusiQrySkuPriceRspVO)busiQrySkuPriceRspBO.getSkuPrices().get(0);
            skuPriceUpdateReqBO.setAgreementPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySkuPriceRspVO.getPrice()));
            skuPriceUpdateReqBO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
            skuPriceUpdateReqBO.setMarketPrice(MoneyUtil.BigDecimal2Long((BigDecimal)busiQrySkuPriceRspVO.getEcPrice()));
            skuPriceUpdateReqBO.setSupplierId(busiInfoSKUReqBO.getSupplierId());
            SkuPriceUpdateRspBO skuPriceUpdateRspBO = this.skuPriceUpdateService.skuPriceUpdate(skuPriceUpdateReqBO);
            if (!"0000".equals(skuPriceUpdateRspBO.getRespCode())) {
                logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuPriceUpdateRspBO.getRespDesc());
                throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuPriceUpdateRspBO.getRespDesc());
            }
            if (!skuPriceUpdateRspBO.getIsSuccess().booleanValue()) {
                logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuPriceUpdateRspBO.getResultMsg());
                throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u5931\u8d25" + skuStateUpdateRspBO.getResultMsg());
            }
        } else {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u67e5\u8be2\u7b2c\u4e09\u65b9\u4ef7\u683c\u5931\u8d25");
            throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u67e5\u8be2\u7b2c\u4e09\u65b9\u4ef7\u683c\u5931\u8d25");
        }
        BusiAttributeChangeReqBO busiAttributeChangeReqBO = new BusiAttributeChangeReqBO();
        busiAttributeChangeReqBO.setSupplierId(busiInfoSKUReqBO.getSupplierId());
        busiAttributeChangeReqBO.setExtSkuId(busiInfoSKUReqBO.getExtSkuId());
        busiAttributeChangeReqBO.setSkuName(busiQrySKURspBO.getName());
        busiAttributeChangeReqBO.setBrandName(busiQrySKURspBO.getBrandName());
        busiAttributeChangeReqBO.setSkuMainPicUrl(busiQrySKURspBO.getImagePath());
        busiAttributeChangeReqBO.setSkuDetail(busiQrySKURspBO.getIntroduction());
        busiAttributeChangeReqBO.setPackParam(busiQrySKURspBO.getWareQD());
        busiAttributeChangeReqBO.setMoq(busiQrySKURspBO.getMoq());
        BusiAttributeChangeRspBO busiAttributeChangeRspBO = this.busiAttributeChangeService.updateAttributeChange(busiAttributeChangeReqBO);
        if (!"0000".equals(busiAttributeChangeRspBO.getRespCode())) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u53d8\u66f4\u8be6\u60c5\u5931\u8d25" + busiAttributeChangeRspBO.getRespDesc());
            throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u53d8\u66f4\u8be6\u60c5\u5931\u8d25" + busiAttributeChangeRspBO.getRespDesc());
        }
        if (!busiAttributeChangeRspBO.getIsSuccess().booleanValue()) {
            logger.error("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u53d8\u66f4\u8be6\u60c5\u5931\u8d25" + busiAttributeChangeRspBO.getResultMsg());
            throw new BusinessException(null, "SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u5931\u6548\u7f6e\u4e3a\u5f85\u4e0a\u67b6\u53d8\u66f4\u8be6\u60c5\u5931\u8d25" + busiAttributeChangeRspBO.getResultMsg());
        }
    }
}

