/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCommodityCatalogService;
import com.cgd.commodity.busi.bo.catalog.QryCommodityCatalogReqBO;
import com.cgd.commodity.busi.bo.catalog.QryCommodityCatalogRspBO;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryCommodityCatalogServiceImpl
implements QryCommodityCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public RspPageBO<QryCommodityCatalogRspBO> qryCommodityCatalog(QryCommodityCatalogReqBO qryCommodityCatalogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7c7b\u76ee\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryCommodityCatalogReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Page page = new Page(qryCommodityCatalogReqBO.getPageNo(), qryCommodityCatalogReqBO.getPageSize());
            List<QryCommodityCatalogRspBO> commodityCatalogList = this.commodityGuideCatalogMapper.getListbyCommodityCatalogReqBO(qryCommodityCatalogReqBO, (Page<Map<String, Object>>)page);
            rsp.setRows(commodityCatalogList);
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            logger.error("\u7c7b\u76ee\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7c7b\u76ee\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

