/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryInfoChangeSkuLogService;
import com.cgd.commodity.busi.bo.supply.BusiQryInfoChangeSkuLogReqBO;
import com.cgd.commodity.busi.bo.supply.BusiQryInfoChangeSkuLogRspBO;
import com.cgd.commodity.busi.impl.QryOffShelfSkuLogServiceImpl;
import com.cgd.commodity.busi.vo.supply.BusiQryInfoChangeSkuLogRspVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuInfoChangeLogMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryInfoChangeSkuLogServiceImpl
implements QryInfoChangeSkuLogService {
    private static final Logger logger = LoggerFactory.getLogger(QryOffShelfSkuLogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuInfoChangeLogMapper skuInfoChangeLogMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private SupplierAgreementMapper supplierAgreementMapper;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSkuInfoChangeLogMapper(SkuInfoChangeLogMapper skuInfoChangeLogMapper) {
        this.skuInfoChangeLogMapper = skuInfoChangeLogMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public RspPageBO<BusiQryInfoChangeSkuLogRspBO> qryInfoChangeSkuLog(BusiQryInfoChangeSkuLogReqBO busiQryInfoChangeSkuLogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQryInfoChangeSkuLogReqBO.toString());
        }
        if (null == busiQryInfoChangeSkuLogReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            int indexOf;
            String skuName = busiQryInfoChangeSkuLogReqBO.getSkuName();
            if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                busiQryInfoChangeSkuLogReqBO.setSkuName(name);
            }
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != busiQryInfoChangeSkuLogReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(busiQryInfoChangeSkuLogReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            Page page = new Page(busiQryInfoChangeSkuLogReqBO.getPageNo(), busiQryInfoChangeSkuLogReqBO.getPageSize());
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(busiQryInfoChangeSkuLogReqBO.getAgreementId(), busiQryInfoChangeSkuLogReqBO.getSupplierId());
            List<BusiQryInfoChangeSkuLogRspVO> busiQryInfoChangeSkuLogRspVOs = this.skuInfoChangeLogMapper.qryEditSkuLogByConditions((Page<BusiQryInfoChangeSkuLogReqBO>)page, busiQryInfoChangeSkuLogReqBO, commodityTypeIds, supplierAgreement.getAgreementStatus());
            List<BusiQryInfoChangeSkuLogRspBO> busiQryInfoChangeSkuLogRspBOs = this.resolveRsp(busiQryInfoChangeSkuLogRspVOs, supplierAgreement);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(busiQryInfoChangeSkuLogReqBO.getPageNo());
            rspPageBO.setRows(busiQryInfoChangeSkuLogRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<BusiQryInfoChangeSkuLogRspBO> resolveRsp(List<BusiQryInfoChangeSkuLogRspVO> busiQryInfoChangeSkuLogRspVOs, SupplierAgreement supplierAgreement) {
        try {
            ArrayList<BusiQryInfoChangeSkuLogRspBO> busiQryInfoChangeSkuLogRspBOs = new ArrayList<BusiQryInfoChangeSkuLogRspBO>();
            if (!busiQryInfoChangeSkuLogRspVOs.isEmpty()) {
                LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
                LinkedList<Long> skuIds = new LinkedList<Long>();
                for (BusiQryInfoChangeSkuLogRspVO busiQryInfoChangeSkuLogRspVO : busiQryInfoChangeSkuLogRspVOs) {
                    commodityTypeIds.add(busiQryInfoChangeSkuLogRspVO.getCommodityTypeId());
                    skuIds.add(busiQryInfoChangeSkuLogRspVO.getSkuId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
                for (BusiQryInfoChangeSkuLogRspVO busiQryInfoChangeSkuLogRspVO : busiQryInfoChangeSkuLogRspVOs) {
                    BusiQryInfoChangeSkuLogRspBO busiQryInfoChangeSkuLogRspBO = new BusiQryInfoChangeSkuLogRspBO();
                    busiQryInfoChangeSkuLogRspBO = this.getBusiQryInfoChangeSkuLogRspBO(busiQryInfoChangeSkuLogRspBO, busiQryInfoChangeSkuLogRspVO, supplierAgreement);
                    if (!catalogMaps.isEmpty()) {
                        for (Map<String, Object> map : catalogMaps) {
                            if (!map.get("commodityTypeId").equals(busiQryInfoChangeSkuLogRspVO.getCommodityTypeId())) continue;
                            busiQryInfoChangeSkuLogRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                            busiQryInfoChangeSkuLogRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                            busiQryInfoChangeSkuLogRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                        }
                    }
                    busiQryInfoChangeSkuLogRspBOs.add(busiQryInfoChangeSkuLogRspBO);
                }
            }
            return busiQryInfoChangeSkuLogRspBOs;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u540d\u79f0\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u540d\u79f0\u5931\u8d25");
        }
    }

    private BusiQryInfoChangeSkuLogRspBO getBusiQryInfoChangeSkuLogRspBO(BusiQryInfoChangeSkuLogRspBO busiQryInfoChangeSkuLogRspBO, BusiQryInfoChangeSkuLogRspVO busiQryInfoChangeSkuLogRspVO, SupplierAgreement supplierAgreement) throws Exception {
        busiQryInfoChangeSkuLogRspBO.setAgreementId(busiQryInfoChangeSkuLogRspVO.getAgreementId());
        busiQryInfoChangeSkuLogRspBO.setAgreementSkuId(busiQryInfoChangeSkuLogRspVO.getAgreementSkuId());
        busiQryInfoChangeSkuLogRspBO.setBrandName(busiQryInfoChangeSkuLogRspVO.getBrandName());
        busiQryInfoChangeSkuLogRspBO.setEditTime(busiQryInfoChangeSkuLogRspVO.getCreateTime());
        if (null != busiQryInfoChangeSkuLogRspVO.getMarketPrice()) {
            busiQryInfoChangeSkuLogRspBO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)busiQryInfoChangeSkuLogRspVO.getMarketPrice()));
        }
        busiQryInfoChangeSkuLogRspBO.setProcInstlId(busiQryInfoChangeSkuLogRspVO.getProcInstlId());
        busiQryInfoChangeSkuLogRspBO.setSkuId(busiQryInfoChangeSkuLogRspVO.getSkuId());
        busiQryInfoChangeSkuLogRspBO.setSkuName(busiQryInfoChangeSkuLogRspVO.getSkuName());
        busiQryInfoChangeSkuLogRspBO.setSupplierId(busiQryInfoChangeSkuLogRspVO.getSupplierId());
        busiQryInfoChangeSkuLogRspBO.setSupplierName(busiQryInfoChangeSkuLogRspVO.getSupplierName());
        busiQryInfoChangeSkuLogRspBO.setVendorId(busiQryInfoChangeSkuLogRspVO.getVendorId());
        busiQryInfoChangeSkuLogRspBO.setVendorName(busiQryInfoChangeSkuLogRspVO.getVendorName());
        if (4 == supplierAgreement.getAgreementStatus()) {
            busiQryInfoChangeSkuLogRspBO.setSkuStatus(busiQryInfoChangeSkuLogRspVO.getSkuStatus());
        }
        Integer status = 9;
        if (3 == supplierAgreement.getAgreementStatus()) {
            busiQryInfoChangeSkuLogRspBO.setSkuStatus(status);
        }
        if (5 == supplierAgreement.getAgreementStatus()) {
            busiQryInfoChangeSkuLogRspBO.setSkuStatus(status);
        }
        if (6 == supplierAgreement.getAgreementStatus()) {
            busiQryInfoChangeSkuLogRspBO.setSkuStatus(status);
        }
        if (7 == supplierAgreement.getAgreementStatus()) {
            busiQryInfoChangeSkuLogRspBO.setSkuStatus(status);
        }
        busiQryInfoChangeSkuLogRspBO.setEditTime(busiQryInfoChangeSkuLogRspVO.getCreateTime());
        return busiQryInfoChangeSkuLogRspBO;
    }
}

