/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySKUService;
import com.cgd.commodity.busi.bo.BusiSKUDetailReqBO;
import com.cgd.commodity.busi.bo.BusiSKUDetailRspBO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QrySKUServiceImpl
implements QrySKUService {
    private static final Logger logger = LoggerFactory.getLogger(QrySKUServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    private Properties prop;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public BusiSKUDetailRspBO qrySKU(BusiSKUDetailReqBO busiSKUDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + busiSKUDetailReqBO.toString());
        }
        if (null == busiSKUDetailReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u5546\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiSKUDetailReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiSKUDetailReqBO.getSkuLocation()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u5355\u54c1\u4f4d\u7f6e[skuLocation]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Long vendorId = Long.parseLong(this.prop.getProperty("VENDOR_ID"));
            Sku sku = this.skuMapper.selDetByIdASupIdALoc(busiSKUDetailReqBO.getSkuId(), busiSKUDetailReqBO.getSupplierId(), busiSKUDetailReqBO.getSkuLocation());
            HashMap<String, Object> skuIdsParam = new HashMap<String, Object>();
            Long skuId = busiSKUDetailReqBO.getSkuId();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            skuIds.add(skuId);
            skuIdsParam.put("skuIds", skuIds);
            skuIdsParam.put("supplierId", busiSKUDetailReqBO.getSupplierId());
            List<SkuPrice> skuPriceList = this.skuPriceMapper.qryPriceBySkuIdsAndSupplierId(skuIdsParam);
            BusiSKUDetailRspBO busiSKUDetailRspBO = new BusiSKUDetailRspBO();
            if (sku != null) {
                busiSKUDetailRspBO.setExtSkuId(sku.getExtSkuId());
                busiSKUDetailRspBO.setSkuId(sku.getSkuId());
                busiSKUDetailRspBO.setSkuLocation(sku.getSkuLocation());
                busiSKUDetailRspBO.setSkuName(sku.getSkuName());
                busiSKUDetailRspBO.setSupplierId(sku.getSupplierId());
                busiSKUDetailRspBO.setSupplierName(sku.getSupplierName());
                busiSKUDetailRspBO.setMeasuerId(sku.getMeasureId());
                busiSKUDetailRspBO.setMeasureName(sku.getMeasureName());
                busiSKUDetailRspBO.setCommodityTypeId(sku.getCommodityId());
                busiSKUDetailRspBO.setUpcCode(sku.getUpcCode());
                busiSKUDetailRspBO.setSkuStatus(sku.getSkuStatus());
                busiSKUDetailRspBO.setVendorId(vendorId);
                busiSKUDetailRspBO.setVendorName(sku.getVendorName());
                busiSKUDetailRspBO.setMoq(sku.getMoq());
                if (busiSKUDetailReqBO.getUserId() != null) {
                    busiSKUDetailRspBO.setIsLogin(Boolean.valueOf(true));
                } else {
                    busiSKUDetailRspBO.setIsLogin(Boolean.valueOf(false));
                }
                if (skuPriceList != null && skuPriceList.size() > 0) {
                    for (SkuPrice skuPrice : skuPriceList) {
                        logger.debug("\u5546\u54c1\u4e2d\u5fc3SKUPrice \uff1a" + skuPrice.toString());
                        if (!sku.getSkuId().equals(skuPrice.getSkuId())) continue;
                        if (skuPrice.getMarketPrice() != null) {
                            busiSKUDetailRspBO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)skuPrice.getMarketPrice()));
                        }
                        if (busiSKUDetailReqBO.getUserId() != null) {
                            logger.debug("\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u7528\u6237\u5df2\u767b\u5f55");
                            if (skuPrice.getSalePrice() != null) {
                                busiSKUDetailRspBO.setSalePrice(MoneyUtil.Long2BigDecimal((Long)skuPrice.getSalePrice()));
                            }
                            if (skuPrice.getMemberPrice() != null) {
                                busiSKUDetailRspBO.setMemberPrice(MoneyUtil.Long2BigDecimal((Long)skuPrice.getMemberPrice()));
                            }
                            if (skuPrice.getAgreementPrice() != null) {
                                busiSKUDetailRspBO.setAgreementPrice(MoneyUtil.Long2BigDecimal((Long)skuPrice.getAgreementPrice()));
                            }
                        }
                        busiSKUDetailRspBO.setAgreementId(skuPrice.getAgreementId());
                        break;
                    }
                }
                busiSKUDetailRspBO.setPreDeliverDay(sku.getPreDeliverDay());
                busiSKUDetailRspBO.setCommodityTypeId(sku.getCommodityTypeId());
            }
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u51fa\u53c2\uff1a" + busiSKUDetailRspBO.toString());
            }
            return busiSKUDetailRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u4e2d\u5fc3SKU\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }
}

