/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuInfoChangeAgrListService;
import com.cgd.commodity.busi.bo.supply.QrySkuInfoChangeAgrListReqBO;
import com.cgd.commodity.busi.bo.supply.QrySkuInfoChangeAgrListRspBO;
import com.cgd.commodity.dao.SkuInfoChangeMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QrySkuInfoChangeAgrListServiceImpl
implements QrySkuInfoChangeAgrListService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuInfoChangeAgrListServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SkuInfoChangeMapper skuInfoChangeMapper;

    public RspPageBO<QrySkuInfoChangeAgrListRspBO> qrySkuInfoChangeAgrList(QrySkuInfoChangeAgrListReqBO qrySkuInfoChangeAgrListReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6709\u7f16\u8f91\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuInfoChangeAgrListReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            ArrayList<QrySkuInfoChangeAgrListRspBO> list = new ArrayList<QrySkuInfoChangeAgrListRspBO>();
            SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoByUserIdReqBO.setUserId(qrySkuInfoChangeAgrListReqBO.getUserId());
            SelectUserInfoByUserIdRspBO selectUserInfoByUserIdRspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO);
            Long supplierId = selectUserInfoByUserIdRspBO.getCompId();
            SupplierAgreement supplierAgreement = new SupplierAgreement();
            supplierAgreement = this.getSupplierAgreement(qrySkuInfoChangeAgrListReqBO, supplierAgreement);
            supplierAgreement.setSupplierId(supplierId);
            List<Object> supplierAgreementList = new ArrayList();
            Page page = new Page(qrySkuInfoChangeAgrListReqBO.getPageNo().intValue(), qrySkuInfoChangeAgrListReqBO.getPageSize().intValue());
            supplierAgreementList = this.supplierAgreementMapper.selectAgreementsBySupplierAgreementAndTime((Page<Map<String, Object>>)page, supplierAgreement, qrySkuInfoChangeAgrListReqBO.getSignStartTime(), qrySkuInfoChangeAgrListReqBO.getSignEndTime());
            if (supplierAgreementList != null && supplierAgreementList.size() > 0) {
                for (SupplierAgreement supplierAgreement2 : supplierAgreementList) {
                    Integer changeNum = 0;
                    Long agreementId = supplierAgreement2.getAgreementId();
                    changeNum = this.skuInfoChangeMapper.selectByAgreementId(agreementId, supplierId);
                    if (changeNum <= 0) continue;
                    QrySkuInfoChangeAgrListRspBO qrySkuInfoChangeAgrListRspBO = new QrySkuInfoChangeAgrListRspBO();
                    BeanUtils.copyProperties((Object)supplierAgreement2, (Object)qrySkuInfoChangeAgrListRspBO);
                    qrySkuInfoChangeAgrListRspBO.setChangeNum(changeNum);
                    list.add(qrySkuInfoChangeAgrListRspBO);
                }
            }
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setRows(list);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6709\u7f16\u8f91\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u6709\u7f16\u8f91\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private SupplierAgreement getSupplierAgreement(QrySkuInfoChangeAgrListReqBO qrySkuInfoChangeAgrListReqBO, SupplierAgreement supplierAgreement) {
        supplierAgreement.setAgreementName(qrySkuInfoChangeAgrListReqBO.getAgreementName());
        supplierAgreement.setPlaAgreementCode(qrySkuInfoChangeAgrListReqBO.getPlaAgreementCode());
        supplierAgreement.setEntAgreementCode(qrySkuInfoChangeAgrListReqBO.getEntAgreementCode());
        supplierAgreement.setVendorName(qrySkuInfoChangeAgrListReqBO.getVendorName());
        if (qrySkuInfoChangeAgrListReqBO.getAgreementType() != null) {
            supplierAgreement.setAgreementType((byte)qrySkuInfoChangeAgrListReqBO.getAgreementType().intValue());
        }
        if (qrySkuInfoChangeAgrListReqBO.getIsDispatch() != null) {
            supplierAgreement.setIsDispatch((byte)qrySkuInfoChangeAgrListReqBO.getIsDispatch().intValue());
        }
        supplierAgreement.setProducerName(qrySkuInfoChangeAgrListReqBO.getProducerName());
        supplierAgreement.setProducerId(qrySkuInfoChangeAgrListReqBO.getUserId());
        return supplierAgreement;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSkuInfoChangeMapper(SkuInfoChangeMapper skuInfoChangeMapper) {
        this.skuInfoChangeMapper = skuInfoChangeMapper;
    }
}

