/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.consumer;

import com.cgd.base.mq.MqCunsumer;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.dao.AgreementApproveLogMapper;
import com.cgd.commodity.dao.AgreementChangeMapper;
import com.cgd.commodity.intfce.bo.AgrStsChgConsumerReqBO;
import com.cgd.commodity.po.AgreementApproveLogPO;
import com.cgd.commodity.po.AgreementChange;
import com.cgd.common.bo.MqSubScribeSingleBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AgrStsChgConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(AgrStsChgConsumer.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementApproveLogMapper agreementApproveLogMapper;
    private AgreementChangeMapper agreementChangeMapper;

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("AGREEMENT_STS_CHG_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.AGREEMENT_STS_CHG_TAG);
        mqSubScribeSingleBO.setTopic("AGREEMENT_STS_CHG_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        try {
            AgrStsChgConsumerReqBO agrStsChgConsumerReqBO = (AgrStsChgConsumerReqBO)msg;
            if (this.isDebugEnabled) {
                logger.debug("\u751f\u6210\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + agrStsChgConsumerReqBO.toString());
            }
            Integer approveResult = agrStsChgConsumerReqBO.getApproveResult();
            AgreementApproveLogPO agreementApproveLogPO = new AgreementApproveLogPO();
            BeanUtils.copyProperties((Object)agrStsChgConsumerReqBO, (Object)agreementApproveLogPO);
            agreementApproveLogPO.setCreateLoginId(agrStsChgConsumerReqBO.getOperId());
            agreementApproveLogPO.setCreateTime(new Date());
            agreementApproveLogPO.setIsDelete(0);
            if (approveResult == 1) {
                agreementApproveLogPO.setApproveResult(1);
            }
            if (approveResult == 0) {
                agreementApproveLogPO.setApproveResult(0);
            }
            this.agreementApproveLogMapper.insert(agreementApproveLogPO);
            if (agrStsChgConsumerReqBO.getApproveType() != 0) {
                AgreementChange agreementChange = new AgreementChange();
                BeanUtils.copyProperties((Object)agrStsChgConsumerReqBO, (Object)agreementChange);
                if (approveResult == 1) {
                    agreementChange.setState(2);
                }
                if (approveResult == 0) {
                    agreementChange.setState(3);
                }
                agreementChange.setUpdateLoginId(agrStsChgConsumerReqBO.getOperId());
                agreementChange.setUpdateTime(new Date());
                this.agreementChangeMapper.updateAgrChgResultById(agreementChange);
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
        }
    }

    public void setAgreementApproveLogMapper(AgreementApproveLogMapper agreementApproveLogMapper) {
        this.agreementApproveLogMapper = agreementApproveLogMapper;
    }

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }
}

