/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.consumer;

import com.cgd.base.mq.MqCunsumer;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuSaleNumMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.po.CommodityGuideCatalog;
import com.cgd.commodity.po.CommodityType;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SkuSaleNum;
import com.cgd.commodity.po.SkuSpec;
import com.cgd.common.bo.MqSubScribeSingleBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.search.builder.insert.InsertBuilder;
import com.cgd.search.builder.insert.InsertRequestBuilder;
import com.cgd.search.builder.insert.InsertRequestBuilderAdapter;
import com.cgd.search.builder.schema.Nested;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BusiInsertOsSkuConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(BusiInsertOsSkuConsumer.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private InsertRequestBuilderAdapter insertAdapter;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private CommodityTypeMapper comTypeMapper;
    @Autowired
    private CommodityGuideCatalogMapper comGuideCatMapper;
    @Autowired
    private SkuSaleNumMapper skuSaleNumMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("INSERT_OS_SKU_ONS_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.INSERT_OS_SKU_ONS_TAG);
        mqSubScribeSingleBO.setTopic("INSERT_OS_SKU_ONS_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        List skuIDs = (List)msg;
        try {
            for (int i = 0; i < skuIDs.size(); ++i) {
                Long singleSkuId = (Long)skuIDs.get(i);
                Sku singleSku = this.skuMapper.selectByPrimaryKey(singleSkuId);
                SkuPrice singleSkuPrice = this.skuPriceMapper.selectByPrimaryKey(singleSkuId);
                CommodityType singleComType = this.comTypeMapper.selectByPrimaryKey(singleSku.getCommodityTypeId());
                Long catelogId = singleComType.getCatalogId();
                CommodityGuideCatalog singleComGuideCatl3 = this.comGuideCatMapper.selectByPrimaryKey(catelogId);
                String l3CatCode = singleComGuideCatl3.getCatalogCode();
                CommodityGuideCatalog singleComGuideCatl2 = this.comGuideCatMapper.selectByPrimaryKey(Long.valueOf(l3CatCode));
                String l2CatCode = singleComGuideCatl2.getCatalogCode();
                SkuSaleNum saleNum = this.skuSaleNumMapper.selectSoldNumber(singleSkuId, singleSku.getSupplierId());
                List<SkuSpec> skuSpecs = this.skuSpecMapper.selectBySkuIdAndSupplierIdAndCommodityId(singleSkuId, singleSku.getCommodityId(), singleSku.getSupplierId());
                Nested nst = Nested.newNested();
                String nstStr = "";
                for (int j = 0; j < skuSpecs.size(); ++j) {
                    SkuSpec singleSpec = skuSpecs.get(j);
                    String id = String.valueOf(singleSpec.getCommoditySpecId());
                    String name = singleSpec.getPropName().split("-")[1];
                    String value = singleSpec.getPropValue();
                    nst.addRow(id + "-" + name + "-" + value);
                    nstStr = nstStr + id + "-" + name + "-" + value;
                }
                InsertBuilder insertBuilder = InsertBuilder.newBuilder((InsertRequestBuilder)this.insertAdapter.requestBuilder(), (String)"d_sku", (String)String.valueOf(i + 1));
                insertBuilder.columnValueBuilder().addField("sku_id", singleSku.getSkuId()).addField("sku_name", singleSku.getSkuName()).addField("brand_id", singleSku.getBrandId()).addField("brand_name", singleSku.getBrandName()).addField("supplier_id", singleSku.getSupplierId()).addField("supplier_name", singleSku.getSupplierName()).addField("commodity_id", singleSku.getCommodityId()).addField("picture_url", singleSku.getSkuMainPicUrl()).addField("ext_sku_id", singleSku.getExtSkuId()).addField("sku_location", singleSku.getSkuLocation()).addField("sale_area", "0").addField("type_id", singleSku.getCommodityTypeId()).addField("type_name", singleComType.getCommodityTypeName()).addField("upc", singleSku.getUpcCode()).addField("sku_status", singleSku.getSkuStatus()).addField("sold_number", String.valueOf(saleNum)).addField("l2_category_id", l3CatCode).addField("l3_category_id", l2CatCode).addField("discount_rate", Long.valueOf(singleSkuPrice.getSalePrice() / singleSkuPrice.getMarketPrice())).addField("sale_price", singleSkuPrice.getSalePrice()).addField("market_price", singleSkuPrice.getMarketPrice()).addField("agreement_price", singleSkuPrice.getAgreementPrice()).addField("member_price", singleSkuPrice.getMemberPrice()).addField("properties", nst).addField("description", nstStr);
                String result = insertBuilder.build().get();
                System.out.println(result);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "OpenSearch\u63d2\u5165\u5546\u54c1\u6570\u636e-\u641c\u7d22\u5f15\u64ce\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        }
    }
}

