/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.consumer;

import com.cgd.base.mq.MqCunsumer;
import com.cgd.commodity.busi.SkuStateChangeLogService;
import com.cgd.commodity.busi.bo.SkuStateChangeLogReqBO;
import com.cgd.commodity.busi.vo.SkuStateChangeLogReqVO;
import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.bo.SkuStatuChangeLogConsumerReqBO;
import com.cgd.commodity.po.Sku;
import com.cgd.common.bo.MqSubScribeSingleBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuStateChangeLogConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(SkuStateChangeLogConsumer.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuStateChangeLogService skuStateChangeLogService;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuStateChangeLogService(SkuStateChangeLogService skuStateChangeLogService) {
        this.skuStateChangeLogService = skuStateChangeLogService;
    }

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("SKU_STATE_UPDATE_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.SKU_STATE_UPDATE_TAG);
        mqSubScribeSingleBO.setTopic("SKU_STATE_UPDATE_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        SkuStatuChangeLogConsumerReqBO skuStatusUpdateConsumerReqBO = (SkuStatuChangeLogConsumerReqBO)msg;
        if (isDebugEnabled) {
            logger.debug("\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + skuStatusUpdateConsumerReqBO.toString());
        }
        if (skuStatusUpdateConsumerReqBO.getSku() != null) {
            try {
                List<Sku> skus = this.skuMapper.selectBySupplierAndSkuId(skuStatusUpdateConsumerReqBO.getSku().getSupplierId(), skuStatusUpdateConsumerReqBO.getSku().getSkuIds());
                ArrayList<SkuStateChangeLogReqVO> skuStateChangeLogReqVOs = new ArrayList<SkuStateChangeLogReqVO>();
                if (!skus.isEmpty()) {
                    for (Sku sku : skus) {
                        SkuStateChangeLogReqVO skuStateChangeLogReqVO = new SkuStateChangeLogReqVO();
                        skuStateChangeLogReqVO.setSkuId(sku.getSkuId());
                        skuStateChangeLogReqVO.setSkuName(sku.getSkuName());
                        skuStateChangeLogReqVO.setSupplierId(sku.getSupplierId());
                        skuStateChangeLogReqVO.setPreState(skuStatusUpdateConsumerReqBO.getPreState());
                        skuStateChangeLogReqVO.setPostState(skuStatusUpdateConsumerReqBO.getPostState());
                        skuStateChangeLogReqVO.setApproveComments(skuStatusUpdateConsumerReqBO.getApproveComments());
                        skuStateChangeLogReqVO.setCreateLoginId(skuStatusUpdateConsumerReqBO.getOperatorId());
                        skuStateChangeLogReqVO.setUpdateLoginId(skuStatusUpdateConsumerReqBO.getOperatorId());
                        skuStateChangeLogReqVO.setCreateTime(skuStatusUpdateConsumerReqBO.getCreateTime());
                        skuStateChangeLogReqVOs.add(skuStateChangeLogReqVO);
                    }
                    SkuStateChangeLogReqBO skuStateChangeLogReqBO = new SkuStateChangeLogReqBO();
                    skuStateChangeLogReqBO.setSkuStateChangeLogs(skuStateChangeLogReqVOs);
                    this.skuStateChangeLogService.insertSkuStateChangeLog(skuStateChangeLogReqBO);
                }
            }
            catch (Exception e) {
                logger.error("\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff1a" + e);
            }
        }
    }
}

