/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.intfce.impl;

import com.cgd.commodity.busi.BatQrySkuService;
import com.cgd.commodity.busi.bo.BatQrySkuIntfceReqBO;
import com.cgd.commodity.busi.bo.BatQrySkuIntfceRspBO;
import com.cgd.commodity.busi.bo.BatQrySkuReqBO;
import com.cgd.commodity.busi.bo.BatQrySkuRspBO;
import com.cgd.commodity.busi.bo.SkuInfoInfceRsp;
import com.cgd.commodity.busi.bo.SkuInfoRsp;
import com.cgd.commodity.busi.vo.SkuSupplierVO;
import com.cgd.commodity.intfce.BatQrySkuIntfceService;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BatQrySkuIntfceServiceImpl
implements BatQrySkuIntfceService {
    private static final Logger logger = LoggerFactory.getLogger(BatQrySkuIntfceServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private BatQrySkuService batQrySkuService;

    public void setBatQrySkuService(BatQrySkuService batQrySkuService) {
        this.batQrySkuService = batQrySkuService;
    }

    public BatQrySkuIntfceRspBO qrgBatQrySku(BatQrySkuIntfceReqBO batQrySkuIntfceReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u83b7\u53d6Sku\u7ec4\u5408\u63a5\u53e3\u670d\u52a1\u5165\u53c2\uff1a" + batQrySkuIntfceReqBO.toString());
        }
        if (null == batQrySkuIntfceReqBO.getSkuSupplier() || batQrySkuIntfceReqBO.getSkuSupplier().size() == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6279\u91cf\u83b7\u53d6Sku\u7ec4\u5408\u63a5\u53e3\u670d\u52a1\u5546\u54c1\u5217\u8868[SkuInfoInfceRsp]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BatQrySkuIntfceRspBO batQrySkuIntfceRspBO = new BatQrySkuIntfceRspBO();
        try {
            if (null != batQrySkuIntfceReqBO.getUserId()) {
                batQrySkuIntfceRspBO.setIsLogin(Boolean.valueOf(true));
            } else {
                batQrySkuIntfceRspBO.setIsLogin(Boolean.valueOf(false));
            }
            Map<Long, List<SkuSupplierVO>> map = this.groupSupplierId(batQrySkuIntfceReqBO.getSkuSupplier());
            ArrayList<SkuInfoInfceRsp> skuInfoInfceRspList = new ArrayList<SkuInfoInfceRsp>();
            if (map != null && map.size() > 0) {
                for (Long key : map.keySet()) {
                    BatQrySkuReqBO busiBatQrySkuReqBO = new BatQrySkuReqBO();
                    busiBatQrySkuReqBO.setSupplierId(key);
                    List<SkuSupplierVO> list = map.get(key);
                    ArrayList<Long> skuIdList = new ArrayList<Long>();
                    for (SkuSupplierVO skuSupplierVO : list) {
                        Long skuIds = skuSupplierVO.getSkuId();
                        skuIdList.add(skuIds);
                    }
                    busiBatQrySkuReqBO.setSkuIds(skuIdList);
                    busiBatQrySkuReqBO.setUserId(batQrySkuIntfceReqBO.getUserId());
                    BatQrySkuRspBO batQrySku = this.batQrySkuService.batQrySku(busiBatQrySkuReqBO);
                    if (batQrySku.getResults() == null || batQrySku.getResults().size() <= 0) continue;
                    List skuInfoRspList = batQrySku.getResults();
                    for (SkuInfoRsp skuInfoRsp : skuInfoRspList) {
                        SkuInfoInfceRsp skuInfoInfceRsp = new SkuInfoInfceRsp();
                        skuInfoInfceRsp.setAgreementPrice(skuInfoRsp.getAgreementPrice());
                        skuInfoInfceRsp.setBrandName(skuInfoRsp.getBrandName());
                        skuInfoInfceRsp.setCommodityTypeId(skuInfoRsp.getCommodityTypeId());
                        skuInfoInfceRsp.setCurrencyType(skuInfoRsp.getCurrencyType());
                        skuInfoInfceRsp.setExtSkuId(skuInfoRsp.getExtSkuId());
                        skuInfoInfceRsp.setIsSupplierAgreement(skuInfoRsp.getIsSupplierAgreement());
                        skuInfoInfceRsp.setMarketPrice(skuInfoRsp.getMarketPrice());
                        skuInfoInfceRsp.setMaterialId(skuInfoRsp.getMaterialId());
                        skuInfoInfceRsp.setMeasureName(skuInfoRsp.getMeasureName());
                        skuInfoInfceRsp.setMemberPrice(skuInfoRsp.getMemberPrice());
                        skuInfoInfceRsp.setMoq(skuInfoRsp.getMoq());
                        skuInfoInfceRsp.setSalePrice(skuInfoRsp.getSalePrice());
                        skuInfoInfceRsp.setSkuDetail(skuInfoRsp.getSkuDetail());
                        skuInfoInfceRsp.setSkuId(skuInfoRsp.getSkuId());
                        skuInfoInfceRsp.setSkuLocation(skuInfoRsp.getSkuLocation());
                        skuInfoInfceRsp.setSkuMainPicUrl(skuInfoRsp.getSkuMainPicUrl());
                        skuInfoInfceRsp.setSkuName(skuInfoRsp.getSkuName());
                        skuInfoInfceRsp.setSkuStatus(skuInfoRsp.getSkuStatus());
                        skuInfoInfceRsp.setSupplierId(skuInfoRsp.getSupplierId());
                        skuInfoInfceRsp.setSupplierName(skuInfoRsp.getSupplierName());
                        skuInfoInfceRsp.setUpcCode(skuInfoRsp.getUpcCode());
                        skuInfoInfceRsp.setVendorId(skuInfoRsp.getVendorId());
                        skuInfoInfceRsp.setVendorName(skuInfoRsp.getVendorName());
                        skuInfoInfceRspList.add(skuInfoInfceRsp);
                    }
                }
            }
            batQrySkuIntfceRspBO.setResults(skuInfoInfceRspList);
            return batQrySkuIntfceRspBO;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u83b7\u53d6Sku\u7ec4\u5408\u63a5\u53e3\u670d\u52a1\u5931\u8d25\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6279\u91cf\u83b7\u53d6Sku\u7ec4\u5408\u63a5\u53e3\u670d\u52a1\u5931\u8d25");
        }
    }

    private Map<Long, List<SkuSupplierVO>> groupSupplierId(List<SkuSupplierVO> skuSupplierList) {
        HashMap<Long, List<SkuSupplierVO>> map = new HashMap<Long, List<SkuSupplierVO>>();
        List<SkuSupplierVO> skuSupplier = skuSupplierList;
        for (SkuSupplierVO val : skuSupplier) {
            Long supplierId = val.getSupplierId();
            ArrayList<SkuSupplierVO> supplierList = (ArrayList<SkuSupplierVO>)map.get(supplierId);
            if (null == supplierList) {
                supplierList = new ArrayList<SkuSupplierVO>();
                map.put(supplierId, supplierList);
            }
            supplierList.add(val);
        }
        return map;
    }
}

