/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.base.mq.MqProducer;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.gd.commodity.atom.GenerateAgrChangeSeqService;
import com.gd.commodity.busi.AddPriceChangeApplyService;
import com.gd.commodity.busi.bo.agreement.AddPriceChangeApplyReqBO;
import com.gd.commodity.busi.bo.agreement.AddPriceChangeApplyRspBO;
import com.gd.commodity.busi.bo.agreement.AddPriceChangeBO;
import com.gd.commodity.busi.impl.AddStatusChangeApplyServiceImpl;
import com.gd.commodity.busi.vo.agreement.AgrAttachChgVo;
import com.gd.commodity.constant.CommodityTopicConstant;
import com.gd.commodity.dao.AgreementApproveLogMapper;
import com.gd.commodity.dao.AgreementChangeAttachMapper;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.dao.PriceChangeMapper;
import com.gd.commodity.intfce.bo.agreement.UpdateAgrStatusConsumerBO;
import com.gd.commodity.po.AgreementApproveLogPO;
import com.gd.commodity.po.AgreementChange;
import com.gd.commodity.po.AgreementChangeAttach;
import com.gd.commodity.po.PriceChange;
import com.gd.commodity.po.SupplierAgreement;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class AddPriceChangeApplyServiceImpl
implements AddPriceChangeApplyService {
    private static final Logger logger = LoggerFactory.getLogger(AddStatusChangeApplyServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementChangeMapper agreementChangeMapper;
    private PriceChangeMapper priceChangeMapper;
    private AgreementApproveLogMapper agreementApproveLogMapper;
    private GenerateAgrChangeSeqService generateAgrChangeSeqService;
    private AgreementChangeAttachMapper agreementChangeAttachMapper;

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public void setPriceChangeMapper(PriceChangeMapper priceChangeMapper) {
        this.priceChangeMapper = priceChangeMapper;
    }

    public void setAgreementApproveLogMapper(AgreementApproveLogMapper agreementApproveLogMapper) {
        this.agreementApproveLogMapper = agreementApproveLogMapper;
    }

    public void setGenerateAgrChangeSeqService(GenerateAgrChangeSeqService generateAgrChangeSeqService) {
        this.generateAgrChangeSeqService = generateAgrChangeSeqService;
    }

    public void setAgreementChangeAttachMapper(AgreementChangeAttachMapper agreementChangeAttachMapper) {
        this.agreementChangeAttachMapper = agreementChangeAttachMapper;
    }

    public AddPriceChangeApplyRspBO addPriceChangeApply(AddPriceChangeApplyReqBO addPriceChangeApplyReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u4ef7\u683c\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addPriceChangeApplyReqBO.toString());
        }
        AddPriceChangeApplyRspBO rsp = new AddPriceChangeApplyRspBO();
        try {
            List<AgreementChange> agreementChangeList = this.agreementChangeMapper.selectByAgreementIdAndState(addPriceChangeApplyReqBO.getAgreementId());
            if (agreementChangeList != null && agreementChangeList.size() > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u534f\u8bae\u6709\u672a\u5b8c\u6210\u7684\u5ba1\u6279\u7533\u8bf7");
            }
            AgreementChange record = new AgreementChange();
            BeanUtils.copyProperties((Object)addPriceChangeApplyReqBO, (Object)record);
            if (addPriceChangeApplyReqBO.getOperateType().equals(0)) {
                record.setState(0);
            } else {
                record.setState(1);
            }
            record.setIsDelete(0);
            Long changeId = this.generateAgrChangeSeqService.generateAgrChangeSeq().getChangeId();
            record.setChangeId(changeId);
            record.setCreateTime(new Date());
            record.setCreateLoginId(addPriceChangeApplyReqBO.getUserId());
            this.agreementChangeMapper.insert(record);
            if (addPriceChangeApplyReqBO.getAgrAttach() != null && addPriceChangeApplyReqBO.getAgrAttach().size() > 0) {
                AgreementChangeAttach att = null;
                LinkedList supplierAgreementAttaches = new LinkedList();
                for (AgrAttachChgVo vo : addPriceChangeApplyReqBO.getAgrAttach()) {
                    att = new AgreementChangeAttach();
                    att.setCreateLoginId(addPriceChangeApplyReqBO.getUserId());
                    att.setCreateTime(new Date());
                    att.setAgreementId(addPriceChangeApplyReqBO.getAgreementId());
                    att.setChangeCode(addPriceChangeApplyReqBO.getChangeCode());
                    att.setSupplierId(addPriceChangeApplyReqBO.getSupplierId());
                    att.setChangeId(changeId);
                    att.setAttachmentAddr(vo.getAttachmentAddr());
                    att.setAttachmentName(vo.getAttachmentName());
                    att.setIsDelete(0);
                    supplierAgreementAttaches.add(att);
                }
                this.agreementChangeAttachMapper.batchAddAgrChgAttachs(supplierAgreementAttaches);
            }
            ArrayList<PriceChange> priceChangeList = new ArrayList<PriceChange>();
            if (addPriceChangeApplyReqBO.getAddPriceChgInfos() != null && addPriceChangeApplyReqBO.getAddPriceChgInfos().size() > 0) {
                for (AddPriceChangeBO addPriceChangeBO : addPriceChangeApplyReqBO.getAddPriceChgInfos()) {
                    PriceChange record1 = new PriceChange();
                    BeanUtils.copyProperties((Object)addPriceChangeBO, (Object)record1);
                    record1.setChangeId(changeId);
                    record1.setChangeCode(addPriceChangeApplyReqBO.getChangeCode());
                    record1.setAgreementId(addPriceChangeApplyReqBO.getAgreementId());
                    record1.setSupplierId(addPriceChangeApplyReqBO.getSupplierId());
                    record1.setCreateTime(new Date());
                    record1.setCreateLoginId(addPriceChangeApplyReqBO.getUserId());
                    record1.setIsDelete(0);
                    record1.setPreBuyPrice(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPreBuyPrice()));
                    record1.setPreBuyPriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPreBuyPriceSum()));
                    record1.setPreSalePrice(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPreSalePrice()));
                    record1.setPreSalePriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPreSalePriceSum()));
                    record1.setPostBuyPrice(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPostBuyPrice()));
                    record1.setPostBuyPriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPostBuyPriceSum()));
                    record1.setPostSalePrice(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPostSalePrice()));
                    record1.setPostSalePriceSum(MoneyUtil.BigDecimal2Long((BigDecimal)addPriceChangeBO.getPostSalePriceSum()));
                    priceChangeList.add(record1);
                }
            }
            if (priceChangeList.size() > 0) {
                this.priceChangeMapper.insertByList(priceChangeList);
            }
            if (addPriceChangeApplyReqBO.getOperateType().equals(1)) {
                AgreementApproveLogPO agreementApproveLogPO = new AgreementApproveLogPO();
                agreementApproveLogPO.setAgreementId(addPriceChangeApplyReqBO.getAgreementId());
                agreementApproveLogPO.setChangeId(changeId);
                agreementApproveLogPO.setSupplierId(addPriceChangeApplyReqBO.getSupplierId());
                agreementApproveLogPO.setChangeCode(addPriceChangeApplyReqBO.getChangeCode());
                agreementApproveLogPO.setApproveType(addPriceChangeApplyReqBO.getChangeType());
                agreementApproveLogPO.setApproveResult(2);
                agreementApproveLogPO.setCreateLoginId(addPriceChangeApplyReqBO.getUserId());
                agreementApproveLogPO.setCreateTime(new Date());
                agreementApproveLogPO.setIsDelete(0);
                this.agreementApproveLogMapper.insert(agreementApproveLogPO);
                SupplierAgreement supplierAgreement = new SupplierAgreement();
                supplierAgreement.setAgreementId(addPriceChangeApplyReqBO.getAgreementId());
                supplierAgreement.setSupplierId(addPriceChangeApplyReqBO.getSupplierId());
                supplierAgreement.setUpdateLoginId(addPriceChangeApplyReqBO.getUserId());
                this.sendMsg(supplierAgreement);
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4ef7\u683c\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setSuccess(false);
            rsp.setResultMsg("\u65b0\u589e\u4ef7\u683c\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u4ef7\u683c\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private void sendMsg(SupplierAgreement supplierAgreement) {
        try {
            UpdateAgrStatusConsumerBO updateAgrStatusConsumerBO = new UpdateAgrStatusConsumerBO();
            updateAgrStatusConsumerBO.setAgreementId(supplierAgreement.getAgreementId());
            updateAgrStatusConsumerBO.setSupplierId(supplierAgreement.getSupplierId());
            updateAgrStatusConsumerBO.setOperId(supplierAgreement.getUpdateLoginId());
            updateAgrStatusConsumerBO.setAgreementStatus(Integer.valueOf(5));
            MqProducer.sendMsg((String)"AGREEMENT_STATUS_CHG_TOPIC", (String)CommodityTopicConstant.AGREEMENT_STATUS_CHG_TAG, (Object)updateAgrStatusConsumerBO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4ef7\u683c\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u6d88\u606f\u53d8\u66f4\u534f\u8bae\u72b6\u6001\u5931\u8d25" + e);
        }
    }
}

