/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.base.mq.MqProducer;
import com.cgd.common.exception.BusinessException;
import com.gd.commodity.atom.GenerateAgrChangeSeqService;
import com.gd.commodity.busi.AddStatusChangeApplyService;
import com.gd.commodity.busi.bo.agreement.AddStatusChangeApplyReqBO;
import com.gd.commodity.busi.bo.agreement.AddStatusChangeApplyRspBO;
import com.gd.commodity.busi.vo.agreement.AgrAttachChgVo;
import com.gd.commodity.constant.CommodityTopicConstant;
import com.gd.commodity.dao.AgreementApproveLogMapper;
import com.gd.commodity.dao.AgreementChangeAttachMapper;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.intfce.bo.agreement.UpdateAgrStatusConsumerBO;
import com.gd.commodity.po.AgreementApproveLogPO;
import com.gd.commodity.po.AgreementChange;
import com.gd.commodity.po.AgreementChangeAttach;
import com.gd.commodity.po.SupplierAgreement;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class AddStatusChangeApplyServiceImpl
implements AddStatusChangeApplyService {
    private static final Logger logger = LoggerFactory.getLogger(AddStatusChangeApplyServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementChangeMapper agreementChangeMapper;
    private AgreementApproveLogMapper agreementApproveLogMapper;
    private GenerateAgrChangeSeqService generateAgrChangeSeqService;
    private AgreementChangeAttachMapper agreementChangeAttachMapper;

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public void setAgreementApproveLogMapper(AgreementApproveLogMapper agreementApproveLogMapper) {
        this.agreementApproveLogMapper = agreementApproveLogMapper;
    }

    public void setGenerateAgrChangeSeqService(GenerateAgrChangeSeqService generateAgrChangeSeqService) {
        this.generateAgrChangeSeqService = generateAgrChangeSeqService;
    }

    public void setAgreementChangeAttachMapper(AgreementChangeAttachMapper agreementChangeAttachMapper) {
        this.agreementChangeAttachMapper = agreementChangeAttachMapper;
    }

    public AddStatusChangeApplyRspBO addStatusChangeApply(AddStatusChangeApplyReqBO addStatusChangeApplyReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u65b0\u589e\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + addStatusChangeApplyReqBO.toString());
        }
        if (addStatusChangeApplyReqBO.getChangeType().equals(5)) {
            if (null == addStatusChangeApplyReqBO.getPostInvalidDate()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d8\u66f4\u540e\u534f\u8bae\u5931\u6548\u65e5\u671f[postInvalidDate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == addStatusChangeApplyReqBO.getPreInvalidDate()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u534f\u8bae\u5931\u6548\u65e5\u671f[preInvalidDate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        AddStatusChangeApplyRspBO rsp = new AddStatusChangeApplyRspBO();
        try {
            List<AgreementChange> agreementChangeList = this.agreementChangeMapper.selectByAgreementIdAndState(addStatusChangeApplyReqBO.getAgreementId());
            if (agreementChangeList != null && agreementChangeList.size() > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u534f\u8bae\u6709\u672a\u5b8c\u6210\u7684\u5ba1\u6279\u7533\u8bf7");
            }
            AgreementChange record = new AgreementChange();
            BeanUtils.copyProperties((Object)addStatusChangeApplyReqBO, (Object)record);
            if (addStatusChangeApplyReqBO.getOperateType().equals(0)) {
                record.setState(0);
            } else {
                record.setState(1);
            }
            record.setIsDelete(0);
            Long changeId = this.generateAgrChangeSeqService.generateAgrChangeSeq().getChangeId();
            record.setChangeId(changeId);
            record.setCreateTime(new Date());
            record.setCreateLoginId(addStatusChangeApplyReqBO.getUserId());
            this.agreementChangeMapper.insert(record);
            if (addStatusChangeApplyReqBO.getAgrAttach() != null && addStatusChangeApplyReqBO.getAgrAttach().size() > 0) {
                AgreementChangeAttach att = null;
                LinkedList<AgreementChangeAttach> supplierAgreementAttaches = new LinkedList<AgreementChangeAttach>();
                for (AgrAttachChgVo vo : addStatusChangeApplyReqBO.getAgrAttach()) {
                    att = new AgreementChangeAttach();
                    att.setCreateLoginId(addStatusChangeApplyReqBO.getUserId());
                    att.setCreateTime(new Date());
                    att.setAgreementId(addStatusChangeApplyReqBO.getAgreementId());
                    att.setChangeCode(addStatusChangeApplyReqBO.getChangeCode());
                    att.setSupplierId(addStatusChangeApplyReqBO.getSupplierId());
                    att.setChangeId(changeId);
                    att.setAttachmentAddr(vo.getAttachmentAddr());
                    att.setAttachmentName(vo.getAttachmentName());
                    att.setIsDelete(0);
                    supplierAgreementAttaches.add(att);
                }
                this.agreementChangeAttachMapper.batchAddAgrChgAttachs(supplierAgreementAttaches);
            }
            if (addStatusChangeApplyReqBO.getOperateType().equals(1)) {
                AgreementApproveLogPO agreementApproveLogPO = new AgreementApproveLogPO();
                agreementApproveLogPO.setAgreementId(addStatusChangeApplyReqBO.getAgreementId());
                agreementApproveLogPO.setChangeId(changeId);
                agreementApproveLogPO.setSupplierId(addStatusChangeApplyReqBO.getSupplierId());
                agreementApproveLogPO.setChangeCode(addStatusChangeApplyReqBO.getChangeCode());
                agreementApproveLogPO.setApproveType(addStatusChangeApplyReqBO.getChangeType());
                agreementApproveLogPO.setApproveResult(2);
                agreementApproveLogPO.setCreateLoginId(addStatusChangeApplyReqBO.getUserId());
                agreementApproveLogPO.setCreateTime(new Date());
                agreementApproveLogPO.setIsDelete(0);
                this.agreementApproveLogMapper.insert(agreementApproveLogPO);
                if (addStatusChangeApplyReqBO.getChangeType().equals(1)) {
                    SupplierAgreement supplierAgreement = new SupplierAgreement();
                    supplierAgreement.setAgreementId(addStatusChangeApplyReqBO.getAgreementId());
                    supplierAgreement.setSupplierId(addStatusChangeApplyReqBO.getSupplierId());
                    supplierAgreement.setUpdateLoginId(addStatusChangeApplyReqBO.getUserId());
                    this.sendMsg(supplierAgreement);
                }
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setSuccess(false);
            rsp.setResultMsg("\u65b0\u589e\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private void sendMsg(SupplierAgreement supplierAgreement) {
        try {
            UpdateAgrStatusConsumerBO updateAgrStatusConsumerBO = new UpdateAgrStatusConsumerBO();
            updateAgrStatusConsumerBO.setAgreementId(supplierAgreement.getAgreementId());
            updateAgrStatusConsumerBO.setSupplierId(supplierAgreement.getSupplierId());
            updateAgrStatusConsumerBO.setOperId(supplierAgreement.getUpdateLoginId());
            updateAgrStatusConsumerBO.setAgreementStatus(Integer.valueOf(5));
            MqProducer.sendMsg((String)"AGREEMENT_STATUS_CHG_TOPIC", (String)CommodityTopicConstant.AGREEMENT_STATUS_CHG_TAG, (Object)updateAgrStatusConsumerBO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u72b6\u6001\u53d8\u66f4\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u6d88\u606f\u53d8\u66f4\u534f\u8bae\u72b6\u6001\u5931\u8d25" + e);
        }
    }
}

