/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.gd.commodity.busi.ModityAgrInfoService;
import com.gd.commodity.busi.bo.agreement.ModityAgrInfoReqBO;
import com.gd.commodity.busi.bo.agreement.ModityAgrInfoRspBO;
import com.gd.commodity.busi.vo.agreement.AgrAddPricePropReqVO;
import com.gd.commodity.busi.vo.agreement.AgrAddPricePropValueReqVO;
import com.gd.commodity.busi.vo.agreement.ModityAgrAttachReqVO;
import com.gd.commodity.busi.vo.agreement.ModityAgrOtherAttachReqVO;
import com.gd.commodity.busi.vo.agreement.ModityAgrScopesReqVO;
import com.gd.commodity.constant.Constant;
import com.gd.commodity.dao.AgrAdjustPriceFormulaMapper;
import com.gd.commodity.dao.AgreementAddPricePropMapper;
import com.gd.commodity.dao.AgreementAddPriceValueMapper;
import com.gd.commodity.dao.AgreementScopeMapper;
import com.gd.commodity.dao.SupplierAgreementAttachMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.po.AgreementAddPriceProp;
import com.gd.commodity.po.AgreementAddPriceValue;
import com.gd.commodity.po.AgreementScope;
import com.gd.commodity.po.SupplierAgreement;
import com.gd.commodity.po.SupplierAgreementAttach;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ModityAgrInfoServiceImpl
implements ModityAgrInfoService {
    private static final Logger logger = LoggerFactory.getLogger(ModityAgrInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    private AgreementScopeMapper agreementScopeMapper;
    private AgreementAddPricePropMapper agreementAddPricePropMapper;
    private AgreementAddPriceValueMapper agreementAddPriceValueMapper;
    private AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper;

    public void setAgrAdjustPriceFormulaMapper(AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper) {
        this.agrAdjustPriceFormulaMapper = agrAdjustPriceFormulaMapper;
    }

    public void setAgreementAddPriceValueMapper(AgreementAddPriceValueMapper agreementAddPriceValueMapper) {
        this.agreementAddPriceValueMapper = agreementAddPriceValueMapper;
    }

    public void setAgreementAddPricePropMapper(AgreementAddPricePropMapper agreementAddPricePropMapper) {
        this.agreementAddPricePropMapper = agreementAddPricePropMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementAttachMapper(SupplierAgreementAttachMapper supplierAgreementAttachMapper) {
        this.supplierAgreementAttachMapper = supplierAgreementAttachMapper;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public ModityAgrInfoRspBO updateAgrInfo(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        SupplierAgreement supplierAgreement;
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + modityAgrInfoReqBO.toString());
        }
        if (null == modityAgrInfoReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (modityAgrInfoReqBO.getAdjustPrice() == 2) {
            if (modityAgrInfoReqBO.getAgreementSrc() == 1 && null == modityAgrInfoReqBO.getIsAdjustPriceFormula()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u662f\u5426\u8c03\u4ef7\u516c\u5f0f[isAdjustPriceFormula]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != modityAgrInfoReqBO.getIsAdjustPriceFormula() && modityAgrInfoReqBO.getIsAdjustPriceFormula() == 1) {
                if (null == modityAgrInfoReqBO.getIsModifyBuyPrice()) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u662f\u5426\u624b\u52a8\u4fee\u6539\u91c7\u8d2d\u5355\u4ef7[isAdjustPriceFormula]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == modityAgrInfoReqBO.getAgrAdjustPriceFormulaId()) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae\u516c\u5f0fID[agrAdjustPriceFormulaId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == modityAgrInfoReqBO.getAgrAdjustPriceFormulaName() || "".equals(modityAgrInfoReqBO.getAgrAdjustPriceFormulaName())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae\u516c\u5f0f\u540d\u79f0[agrAdjustPriceFormulaName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == modityAgrInfoReqBO.getAgrAdjustPriceFormulaValue() || "".equals(modityAgrInfoReqBO.getAgrAdjustPriceFormulaValue())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8bae\u516c\u5f0f\u540d\u79f0[agrAdjustPriceFormulaValue]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        if (null == (supplierAgreement = this.supplierAgreementMapper.selectByIds(modityAgrInfoReqBO.getAgreementId(), modityAgrInfoReqBO.getSupplierId()))) {
            ModityAgrInfoRspBO modityAgrInfoRspBO = new ModityAgrInfoRspBO();
            modityAgrInfoRspBO.setIsSuccess(Boolean.valueOf(false));
            modityAgrInfoRspBO.setResultMsg("\u534f\u8bae\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            return modityAgrInfoRspBO;
        }
        try {
            this.updateSupplierAgreement(modityAgrInfoReqBO);
            this.updateSupplierAgreementAttach(modityAgrInfoReqBO);
            this.updateAgreementScope(modityAgrInfoReqBO);
            if (0 != supplierAgreement.getAgreementSrc()) {
                if (modityAgrInfoReqBO.getIsAddPrice() != null && modityAgrInfoReqBO.getIsAddPrice() == 0) {
                    this.updateAddPriceProp(modityAgrInfoReqBO);
                } else if (modityAgrInfoReqBO.getIsAddPrice() != null && modityAgrInfoReqBO.getIsAddPrice() == 1) {
                    this.delAndInertNewAddPriceProp(modityAgrInfoReqBO);
                }
                if (2 != modityAgrInfoReqBO.getAdjustPrice()) {
                    this.deleteAdjustPriceFormula(modityAgrInfoReqBO.getAgreementId(), modityAgrInfoReqBO.getSupplierId());
                } else if (null != modityAgrInfoReqBO.getIsAdjustPriceFormula() && 0 == modityAgrInfoReqBO.getIsAdjustPriceFormula()) {
                    this.deleteAdjustPriceFormula(modityAgrInfoReqBO.getAgreementId(), modityAgrInfoReqBO.getSupplierId());
                } else if (null != supplierAgreement.getAdjustPriceFormulaId() && supplierAgreement.getAdjustPriceFormulaId().longValue() != modityAgrInfoReqBO.getAgrAdjustPriceFormulaId().longValue()) {
                    this.deleteAdjustPriceFormula(modityAgrInfoReqBO.getAgreementId(), modityAgrInfoReqBO.getSupplierId());
                }
            }
            ModityAgrInfoRspBO modityAgrInfoRspBO = new ModityAgrInfoRspBO();
            modityAgrInfoRspBO.setAgreementId(modityAgrInfoReqBO.getAgreementId());
            modityAgrInfoRspBO.setSupplierId(modityAgrInfoReqBO.getSupplierId());
            modityAgrInfoRspBO.setIsSuccess(Boolean.valueOf(true));
            modityAgrInfoRspBO.setResultMsg("\u4fee\u6539\u6210\u529f");
            return modityAgrInfoRspBO;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void updateSupplierAgreement(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            SupplierAgreement supplierAgreement = new SupplierAgreement();
            supplierAgreement.setAgreementId(modityAgrInfoReqBO.getAgreementId());
            supplierAgreement.setEntAgreementCode(modityAgrInfoReqBO.getEntAgreementCode());
            supplierAgreement.setAgreementName(modityAgrInfoReqBO.getAgreementName());
            supplierAgreement.setSupplierId(modityAgrInfoReqBO.getSupplierId());
            supplierAgreement.setVendorId(modityAgrInfoReqBO.getVendorId());
            supplierAgreement.setVendorName(modityAgrInfoReqBO.getVendorName());
            supplierAgreement.setVendorContact(modityAgrInfoReqBO.getVendorContact());
            supplierAgreement.setVendorPhone(modityAgrInfoReqBO.getVendorPhone());
            supplierAgreement.setAgreementType(modityAgrInfoReqBO.getAgreementType());
            supplierAgreement.setAgreementStatus(Constant.AGR_STATUS_DRAFT.byteValue());
            supplierAgreement.setEffDate(modityAgrInfoReqBO.getEffDate());
            supplierAgreement.setExpDate(modityAgrInfoReqBO.getExpDate());
            supplierAgreement.setTaxRate(modityAgrInfoReqBO.getTaxRate());
            supplierAgreement.setPrePayEnt(modityAgrInfoReqBO.getPrePayEnt());
            supplierAgreement.setMatPayEnt(modityAgrInfoReqBO.getMatPayEnt());
            supplierAgreement.setProPayEnt(modityAgrInfoReqBO.getProPayEnt());
            supplierAgreement.setVerPayEnt(modityAgrInfoReqBO.getVerPayEnt());
            supplierAgreement.setPilPayEnt(modityAgrInfoReqBO.getPilPayEnt());
            supplierAgreement.setQuaPayEnt(modityAgrInfoReqBO.getQuaPayEnt());
            supplierAgreement.setMatPaySup(modityAgrInfoReqBO.getMatPaySup());
            supplierAgreement.setProPaySup(modityAgrInfoReqBO.getProPaySup());
            supplierAgreement.setVerPaySup(modityAgrInfoReqBO.getVerPaySup());
            supplierAgreement.setPilPaySup(modityAgrInfoReqBO.getPilPaySup());
            supplierAgreement.setQuaPaySup(modityAgrInfoReqBO.getQuaPaySup());
            supplierAgreement.setPrePaySup(modityAgrInfoReqBO.getPrePaySup());
            supplierAgreement.setSupplyCycle(modityAgrInfoReqBO.getSupplyCycle());
            supplierAgreement.setWarantty(modityAgrInfoReqBO.getWarantty());
            supplierAgreement.setIsDispatch(modityAgrInfoReqBO.getIsDispatch());
            supplierAgreement.setProducerId(modityAgrInfoReqBO.getUserId());
            supplierAgreement.setSignTime(modityAgrInfoReqBO.getSignTime());
            supplierAgreement.setScopeType(modityAgrInfoReqBO.getScopeType());
            supplierAgreement.setAdjustPrice(modityAgrInfoReqBO.getAdjustPrice());
            supplierAgreement.setAdjustPriceFormula(modityAgrInfoReqBO.getAdjustPriceFormula());
            supplierAgreement.setMaterialNameSum("");
            supplierAgreement.setPayClause(modityAgrInfoReqBO.getPayClause());
            supplierAgreement.setServiceRate(modityAgrInfoReqBO.getServiceRate());
            supplierAgreement.setRemark(modityAgrInfoReqBO.getRemark());
            supplierAgreement.setMatterName(modityAgrInfoReqBO.getMatterName());
            supplierAgreement.setUpdateLoginId(modityAgrInfoReqBO.getUserId());
            supplierAgreement.setUpdateTime(new Date());
            supplierAgreement.setAgreementVariety(modityAgrInfoReqBO.getAgreementVariety());
            supplierAgreement.setAgreementSrc(modityAgrInfoReqBO.getAgreementSrc());
            if (2 != modityAgrInfoReqBO.getAdjustPrice()) {
                Byte isNotAdjustPriceFormula = 0;
                supplierAgreement.setIsAdjustPriceFormula(isNotAdjustPriceFormula);
                supplierAgreement.setIsModifyBuyPrice(null);
                supplierAgreement.setAdjustPriceFormulaId(null);
                supplierAgreement.setAdjustPriceFormulaName(null);
                supplierAgreement.setAdjustPriceFormulaValue(null);
            } else if (null != modityAgrInfoReqBO.getIsAdjustPriceFormula() && modityAgrInfoReqBO.getIsAdjustPriceFormula() == 0) {
                Byte isNotAdjustPriceFormula = 0;
                supplierAgreement.setIsAdjustPriceFormula(isNotAdjustPriceFormula);
                supplierAgreement.setIsModifyBuyPrice(null);
                supplierAgreement.setAdjustPriceFormulaId(null);
                supplierAgreement.setAdjustPriceFormulaName(null);
                supplierAgreement.setAdjustPriceFormulaValue(null);
            } else {
                Byte isAdjustPriceFormula = 1;
                supplierAgreement.setIsAdjustPriceFormula(isAdjustPriceFormula);
                supplierAgreement.setIsModifyBuyPrice(modityAgrInfoReqBO.getIsModifyBuyPrice());
                supplierAgreement.setAdjustPriceFormulaId(modityAgrInfoReqBO.getAgrAdjustPriceFormulaId());
                supplierAgreement.setAdjustPriceFormulaName(modityAgrInfoReqBO.getAgrAdjustPriceFormulaName());
                supplierAgreement.setAdjustPriceFormulaValue(modityAgrInfoReqBO.getAgrAdjustPriceFormulaValue());
            }
            this.supplierAgreementMapper.updateByPrimaryKeySelective(supplierAgreement);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u4fee\u6539\u6846\u67b6\u534f\u8bae\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u6846\u67b6\u534f\u8bae\u5931\u8d25");
        }
    }

    private void updateSupplierAgreementAttach(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            SupplierAgreementAttach supplierAgreementAttach;
            this.deleteOldSupplierAgreementAttach(modityAgrInfoReqBO);
            ArrayList<SupplierAgreementAttach> supplierAgreementAttachs = new ArrayList<SupplierAgreementAttach>();
            if (null != modityAgrInfoReqBO.getAgrAttachs() && !modityAgrInfoReqBO.getAgrAttachs().isEmpty()) {
                for (ModityAgrAttachReqVO modityAgrAttachReqVO : modityAgrInfoReqBO.getAgrAttachs()) {
                    if (StringUtils.isEmpty((Object)modityAgrAttachReqVO.getAttachmentAddr()) || StringUtils.isEmpty((Object)modityAgrAttachReqVO.getAttachmentName()) || null == modityAgrAttachReqVO.getAttachmentType()) continue;
                    supplierAgreementAttach = new SupplierAgreementAttach();
                    supplierAgreementAttach.setAgreementId(modityAgrInfoReqBO.getAgreementId());
                    supplierAgreementAttach.setSupplierId(modityAgrInfoReqBO.getSupplierId());
                    supplierAgreementAttach.setAttachmentAddr(modityAgrAttachReqVO.getAttachmentAddr());
                    supplierAgreementAttach.setAttachmentName(modityAgrAttachReqVO.getAttachmentName());
                    supplierAgreementAttach.setAttachmentType(modityAgrAttachReqVO.getAttachmentType());
                    supplierAgreementAttach.setCreateLoginId(modityAgrInfoReqBO.getUserId());
                    supplierAgreementAttach.setCreateTime(new Date());
                    supplierAgreementAttach.setIsDelete(Constant.IS_DELETE.byteValue());
                    supplierAgreementAttachs.add(supplierAgreementAttach);
                }
            }
            if (null != modityAgrInfoReqBO.getAgrOtherAttachs() && !modityAgrInfoReqBO.getAgrOtherAttachs().isEmpty()) {
                for (ModityAgrOtherAttachReqVO modityAgrOtherAttachReqVO : modityAgrInfoReqBO.getAgrOtherAttachs()) {
                    if (StringUtils.isEmpty((Object)modityAgrOtherAttachReqVO.getAttachmentAddr()) || StringUtils.isEmpty((Object)modityAgrOtherAttachReqVO.getAttachmentName()) || null == modityAgrOtherAttachReqVO.getAttachmentType()) continue;
                    supplierAgreementAttach = new SupplierAgreementAttach();
                    supplierAgreementAttach.setAgreementId(modityAgrInfoReqBO.getAgreementId());
                    supplierAgreementAttach.setSupplierId(modityAgrInfoReqBO.getSupplierId());
                    supplierAgreementAttach.setAttachmentAddr(modityAgrOtherAttachReqVO.getAttachmentAddr());
                    supplierAgreementAttach.setAttachmentName(modityAgrOtherAttachReqVO.getAttachmentName());
                    supplierAgreementAttach.setAttachmentType(modityAgrOtherAttachReqVO.getAttachmentType());
                    supplierAgreementAttach.setCreateLoginId(modityAgrInfoReqBO.getUserId());
                    supplierAgreementAttach.setCreateTime(new Date());
                    supplierAgreementAttach.setIsDelete(Constant.IS_DELETE.byteValue());
                    supplierAgreementAttachs.add(supplierAgreementAttach);
                }
            }
            if (!supplierAgreementAttachs.isEmpty()) {
                this.supplierAgreementAttachMapper.insertAgrAttachBatch(supplierAgreementAttachs);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u4fee\u6539\u6846\u67b6\u534f\u8bae\u9644\u4ef6\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u6846\u67b6\u534f\u8bae\u9644\u4ef6\u5931\u8d25");
        }
    }

    private void deleteOldSupplierAgreementAttach(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            ArrayList<Long> attachmentIds = new ArrayList<Long>();
            if (null != modityAgrInfoReqBO.getAgrAttachs() && !modityAgrInfoReqBO.getAgrAttachs().isEmpty()) {
                for (ModityAgrAttachReqVO modityAgrAttachReqVO : modityAgrInfoReqBO.getAgrAttachs()) {
                    if (null == modityAgrAttachReqVO.getAttachmentId()) continue;
                    attachmentIds.add(modityAgrAttachReqVO.getAttachmentId());
                }
            }
            if (null != modityAgrInfoReqBO.getAgrOtherAttachs() && !modityAgrInfoReqBO.getAgrOtherAttachs().isEmpty()) {
                for (ModityAgrOtherAttachReqVO modityAgrOtherAttachReqVO : modityAgrInfoReqBO.getAgrOtherAttachs()) {
                    if (null == modityAgrOtherAttachReqVO.getAttachmentId()) continue;
                    attachmentIds.add(modityAgrOtherAttachReqVO.getAttachmentId());
                }
            }
            if (!attachmentIds.isEmpty()) {
                this.supplierAgreementAttachMapper.deleteAgrAttachBatch(attachmentIds, modityAgrInfoReqBO.getSupplierId());
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5220\u9664\u539f\u9644\u4ef6\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664\u539f\u9644\u4ef6\u5931\u8d25");
        }
    }

    private void updateAgreementScope(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            this.deleteOldAgreementScope(modityAgrInfoReqBO);
            ArrayList<AgreementScope> agreementScopes = new ArrayList<AgreementScope>();
            if ("0".equals(modityAgrInfoReqBO.getScopeType())) {
                AgreementScope agreementScope = new AgreementScope();
                agreementScope.setAgreementId(modityAgrInfoReqBO.getAgreementId());
                agreementScope.setCreateLoginId(modityAgrInfoReqBO.getUserId());
                agreementScope.setCreateTime(new Date());
                agreementScope.setIsDelete(Constant.IS_DELETE.byteValue());
                agreementScope.setScopeCode(0L);
                agreementScope.setScopeName("\u5168\u56fd");
                agreementScope.setScopeType(modityAgrInfoReqBO.getScopeType());
                agreementScope.setSupplierId(modityAgrInfoReqBO.getSupplierId());
                agreementScopes.add(agreementScope);
            } else if (null != modityAgrInfoReqBO.getModityScopes() && !modityAgrInfoReqBO.getModityScopes().isEmpty()) {
                for (ModityAgrScopesReqVO modityAgrScopesReqVO : modityAgrInfoReqBO.getModityScopes()) {
                    if (StringUtils.isEmpty((Object)modityAgrScopesReqVO.getScopeName()) || null == modityAgrScopesReqVO.getScopeCode()) continue;
                    AgreementScope agreementScope = new AgreementScope();
                    agreementScope.setAgreementId(modityAgrInfoReqBO.getAgreementId());
                    agreementScope.setCreateLoginId(modityAgrInfoReqBO.getUserId());
                    agreementScope.setCreateTime(new Date());
                    agreementScope.setIsDelete(Constant.IS_DELETE.byteValue());
                    agreementScope.setScopeCode(modityAgrScopesReqVO.getScopeCode());
                    agreementScope.setScopeName(modityAgrScopesReqVO.getScopeName());
                    agreementScope.setScopeType(modityAgrInfoReqBO.getScopeType());
                    agreementScope.setSupplierId(modityAgrInfoReqBO.getSupplierId());
                    agreementScopes.add(agreementScope);
                }
            }
            if (!agreementScopes.isEmpty()) {
                this.agreementScopeMapper.insertAgrScopeBatch(agreementScopes);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u4fee\u6539\u6846\u67b6\u5e94\u7528\u8303\u56f4\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u6846\u67b6\u534f\u8bae\u5e94\u7528\u8303\u56f4\u5931\u8d25");
        }
    }

    private void deleteOldAgreementScope(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            ArrayList<Long> scopeIds = new ArrayList<Long>();
            if (null != modityAgrInfoReqBO.getModityScopes() && !modityAgrInfoReqBO.getModityScopes().isEmpty()) {
                for (ModityAgrScopesReqVO modityAgrScopesReqVO : modityAgrInfoReqBO.getModityScopes()) {
                    if (null == modityAgrScopesReqVO.getScopeId()) continue;
                    scopeIds.add(modityAgrScopesReqVO.getScopeId());
                }
            }
            if (!scopeIds.isEmpty()) {
                this.agreementScopeMapper.deleteAgrScopeBatch(scopeIds, modityAgrInfoReqBO.getSupplierId());
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5220\u9664\u539f\u6709\u5e94\u7528\u8303\u56f4\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664\u539f\u6709\u5e94\u7528\u8303\u56f4\u5931\u8d25");
        }
    }

    private void updateAddPriceProp(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            List addPriceDefIds = modityAgrInfoReqBO.getAddPriceDefIds();
            if (addPriceDefIds != null && addPriceDefIds.size() > 0) {
                for (Long addPriceDefId : addPriceDefIds) {
                    this.agreementAddPricePropMapper.updateIsDeleteByPrimaryKey(addPriceDefId, modityAgrInfoReqBO.getSupplierId());
                    List<Long> addPriceValueIds = this.agreementAddPriceValueMapper.selectByAddPriceDefId(addPriceDefId, modityAgrInfoReqBO.getSupplierId());
                    if (addPriceValueIds == null || addPriceValueIds.size() <= 0) continue;
                    this.agreementAddPriceValueMapper.updateByAddPriceValueIdBatch(addPriceValueIds, modityAgrInfoReqBO.getSupplierId());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u5220\u9664\u534f\u8bae\u52a0\u4ef7\u9879\u548c\u534f\u8bae\u52a0\u4ef7\u9879\u503c\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u903b\u8f91\u5220\u9664\u534f\u8bae\u52a0\u4ef7\u9879\u548c\u534f\u8bae\u52a0\u4ef7\u9879\u503c\u5931\u8d25");
        }
    }

    private void delAndInertNewAddPriceProp(ModityAgrInfoReqBO modityAgrInfoReqBO) {
        try {
            List addPriceDefIds = modityAgrInfoReqBO.getAddPriceDefIds();
            if (addPriceDefIds != null && addPriceDefIds.size() > 0) {
                for (Long addPriceDefId : addPriceDefIds) {
                    List<Long> addPriceValueIds = this.agreementAddPriceValueMapper.selectByAddPriceDefId(addPriceDefId, modityAgrInfoReqBO.getSupplierId());
                    if (addPriceValueIds != null && addPriceValueIds.size() > 0) {
                        this.agreementAddPriceValueMapper.deleteByPrimaryKeyBatch(addPriceValueIds, modityAgrInfoReqBO.getSupplierId());
                    }
                    this.agreementAddPricePropMapper.deleteByPrimaryKeyAndSupplierId(addPriceDefId, modityAgrInfoReqBO.getSupplierId());
                }
            }
            if (modityAgrInfoReqBO.getAgrAddPriceProps() != null && modityAgrInfoReqBO.getAgrAddPriceProps().size() > 0) {
                for (AgrAddPricePropReqVO agrAddPricePropReqVO : modityAgrInfoReqBO.getAgrAddPriceProps()) {
                    ArrayList<AgreementAddPriceValue> agrAddPricePropValues = new ArrayList<AgreementAddPriceValue>();
                    AgreementAddPriceProp agreementAddPriceProp = new AgreementAddPriceProp();
                    Long agrAddPricePropSeq = this.agreementAddPricePropMapper.generateAgrAddPricePropSeq();
                    agreementAddPriceProp.setAddPriceDefId(agrAddPricePropSeq);
                    agreementAddPriceProp.setAddPriceDefCode(agrAddPricePropReqVO.getAddPriceDefCode());
                    agreementAddPriceProp.setAgreementId(modityAgrInfoReqBO.getAgreementId());
                    agreementAddPriceProp.setSupplierId(modityAgrInfoReqBO.getSupplierId());
                    agreementAddPriceProp.setAddPriceDefName(agrAddPricePropReqVO.getAddPriceDefName());
                    agreementAddPriceProp.setAddPriceDefShowName(agrAddPricePropReqVO.getAddPriceDefShowName());
                    agreementAddPriceProp.setCreateLoginId(modityAgrInfoReqBO.getUserId());
                    agreementAddPriceProp.setCreateTime(new Date());
                    agreementAddPriceProp.setIsDelete(Constant.IS_DELETE.byteValue());
                    this.agreementAddPricePropMapper.insertSelective(agreementAddPriceProp);
                    if (agrAddPricePropReqVO.getAgrAddPricePropValues() == null || agrAddPricePropReqVO.getAgrAddPricePropValues().size() <= 0) continue;
                    for (AgrAddPricePropValueReqVO agrAddPricePropValueReqVO : agrAddPricePropReqVO.getAgrAddPricePropValues()) {
                        AgreementAddPriceValue agreementAddPriceValue = new AgreementAddPriceValue();
                        agreementAddPriceValue.setAddPriceDefId(agrAddPricePropSeq);
                        agreementAddPriceValue.setAddPriceFluctuateType(agrAddPricePropValueReqVO.getAddPriceFluctuateType());
                        agreementAddPriceValue.setAddPriceFluctuateValue(agrAddPricePropValueReqVO.getAddPriceFluctuateValue());
                        agreementAddPriceValue.setSupplierId(modityAgrInfoReqBO.getSupplierId());
                        agreementAddPriceValue.setAddPriceValueName(agrAddPricePropValueReqVO.getAddPriceValueName());
                        agreementAddPriceValue.setAddPriceValue(agrAddPricePropValueReqVO.getAddPriceValue());
                        agreementAddPriceValue.setCreateLoginId(modityAgrInfoReqBO.getUserId());
                        agreementAddPriceValue.setCreateTime(new Date());
                        agreementAddPriceValue.setIsDelete(Constant.IS_DELETE.byteValue());
                        agrAddPricePropValues.add(agreementAddPriceValue);
                    }
                    if (agrAddPricePropValues.isEmpty()) continue;
                    this.agreementAddPriceValueMapper.insertBatch(agrAddPricePropValues);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5220\u9664\u539f\u6709\u5e94\u7528\u8303\u56f4\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664\u539f\u6709\u5e94\u7528\u8303\u56f4\u5931\u8d25");
        }
    }

    private void deleteAdjustPriceFormula(Long agreemengId, Long supplierId) throws Exception {
        try {
            this.agrAdjustPriceFormulaMapper.updateByAgrId(agreemengId, supplierId);
        }
        catch (Exception e) {
            logger.error(" \u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u66f4\u65b0-\u5220\u9664\u5931\u8d25" + e);
            throw new Exception("\u534f\u8bae\u8c03\u4ef7\u516c\u5f0f\u66f4\u65b0\u5931\u8d25" + e);
        }
    }
}

