/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.consumer;

import com.cgd.base.mq.MqCunsumer;
import com.cgd.common.bo.MqSubScribeSingleBO;
import com.gd.commodity.constant.CommodityTopicConstant;
import com.gd.commodity.dao.AgreementApproveLogMapper;
import com.gd.commodity.dao.AgreementChangeMapper;
import com.gd.commodity.intfce.bo.agreement.AgrChangeConsumerReqBO;
import com.gd.commodity.po.AgreementApproveLogPO;
import com.gd.commodity.po.AgreementChange;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class AgrChangeConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(AgrChangeConsumer.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementApproveLogMapper agreementApproveLogMapper;
    private AgreementChangeMapper agreementChangeMapper;

    public void setAgreementApproveLogMapper(AgreementApproveLogMapper agreementApproveLogMapper) {
        this.agreementApproveLogMapper = agreementApproveLogMapper;
    }

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("AGREEMENT_CHG_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.AGREEMENT_CHG_TAG);
        mqSubScribeSingleBO.setTopic("AGREEMENT_CHG_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        try {
            AgrChangeConsumerReqBO agrChangeConsumerReqBO = (AgrChangeConsumerReqBO)msg;
            if (this.isDebugEnabled) {
                logger.debug("\u751f\u6210\u534f\u8bae\u53d8\u66f4\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + agrChangeConsumerReqBO.toString());
            }
            Integer approveResult = agrChangeConsumerReqBO.getApproveResult();
            AgreementApproveLogPO agreementApproveLogPO = new AgreementApproveLogPO();
            BeanUtils.copyProperties((Object)agrChangeConsumerReqBO, (Object)agreementApproveLogPO);
            agreementApproveLogPO.setCreateLoginId(agrChangeConsumerReqBO.getUpdateLoginId());
            agreementApproveLogPO.setCreateTime(new Date());
            if (approveResult == 1) {
                agreementApproveLogPO.setApproveResult(1);
            }
            if (approveResult == 0) {
                agreementApproveLogPO.setApproveResult(0);
            }
            this.agreementApproveLogMapper.insert(agreementApproveLogPO);
            AgreementChange agreementChange = new AgreementChange();
            BeanUtils.copyProperties((Object)agrChangeConsumerReqBO, (Object)agreementChange);
            agreementChange.setUpdateLoginId(agrChangeConsumerReqBO.getUpdateLoginId());
            if (approveResult == 1) {
                agreementChange.setState(2);
            }
            if (approveResult == 0) {
                agreementChange.setState(3);
            }
            agreementChange.setUpdateLoginId(agrChangeConsumerReqBO.getUpdateLoginId());
            this.agreementChangeMapper.updateAgrChgResultById(agreementChange);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u534f\u8bae\u53d8\u66f4\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
        }
    }
}

