/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.workflow.task.busin.service.QryTodoTaskProcInstMapBusiService;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapReqBO;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapRspBO;
import com.cgd.workflow.task.busin.service.bo.TaskRspBO;
import com.ohaotian.commodity.busi.QryWaitOnShelfAuditSkuService;
import com.ohaotian.commodity.busi.bo.QryWaitOnShelfAuditSkuReqBO;
import com.ohaotian.commodity.busi.bo.QryWaitOnShelfAuditSkuRspBO;
import com.ohaotian.commodity.busi.vo.QryWaitOnShelfAuditSkuRspVO;
import com.ohaotian.commodity.dao.CatalogCommodityTypeMapper;
import com.ohaotian.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.commodity.dao.SkuApproveDetailLogMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuOnShelveLogMapper;
import com.ohaotian.commodity.dao.po.CatalogCommodityType;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuOnShelveLog;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryWaitOnShelfAuditSkuServiceImpl
implements QryWaitOnShelfAuditSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QryWaitOnShelfAuditSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;
    private QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public void setQryTodoTaskProcInstMapBusiService(QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService) {
        this.qryTodoTaskProcInstMapBusiService = qryTodoTaskProcInstMapBusiService;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public RspPageBO<QryWaitOnShelfAuditSkuRspBO> qryWaitOnShelfAuditSku(QryWaitOnShelfAuditSkuReqBO qryWaitOnShelfSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryWaitOnShelfSkuReqBO.toString());
        }
        if (null == qryWaitOnShelfSkuReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)qryWaitOnShelfSkuReqBO.getBrandName())) {
            qryWaitOnShelfSkuReqBO.setBrandName(qryWaitOnShelfSkuReqBO.getBrandName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qryWaitOnShelfSkuReqBO.getSkuName())) {
            qryWaitOnShelfSkuReqBO.setSkuName(qryWaitOnShelfSkuReqBO.getSkuName().replaceAll(" ", ""));
        }
        try {
            if (!"-1".equals(qryWaitOnShelfSkuReqBO.getSupplierId()) && !"-1".equals(qryWaitOnShelfSkuReqBO.getGuideCatalogId())) {
                List<QryWaitOnShelfAuditSkuRspVO> list;
                QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO = new QueryTodoTaskProcInstMapReqBO();
                queryTodoTaskProcInstMapReqBO.setUserId(qryWaitOnShelfSkuReqBO.getUserId());
                queryTodoTaskProcInstMapReqBO.setBusinessType("14");
                QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst = this.queryTodoTaskProcInst(queryTodoTaskProcInstMapReqBO);
                LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
                if (null != qryWaitOnShelfSkuReqBO.getGuideCatalogId()) {
                    List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryWaitOnShelfSkuReqBO.getGuideCatalogId());
                    for (CatalogCommodityType catalogCommodityType : catalogs) {
                        commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                    }
                }
                Page page = new Page(qryWaitOnShelfSkuReqBO.getPageNo(), qryWaitOnShelfSkuReqBO.getPageSize());
                ArrayList<Sku> skuList = new ArrayList<Sku>();
                if (queryTodoTaskProcInst != null && queryTodoTaskProcInst.getProcinstTaskMap() != null && queryTodoTaskProcInst.getProcinstTaskMap().size() > 0) {
                    for (Object key : queryTodoTaskProcInst.getProcinstTaskMap().keySet()) {
                        Sku sku;
                        SkuOnShelveLog skuOnShelveLog;
                        TaskRspBO taskRspBO = (TaskRspBO)queryTodoTaskProcInst.getProcinstTaskMap().get(key);
                        String procInstId = taskRspBO.getProcInstId();
                        if (procInstId == null || "".equals(procInstId) || (skuOnShelveLog = this.skuOnShelveLogMapper.selectByProcInstId(procInstId, qryWaitOnShelfSkuReqBO.getSupplierId(), qryWaitOnShelfSkuReqBO.getAgreementId())) == null || (sku = this.skuMapper.selectBySkuIdAndSupplier(skuOnShelveLog.getSkuId(), skuOnShelveLog.getSupplierId())) == null) continue;
                        sku.setTaskId(taskRspBO.getTaskId());
                        skuList.add(sku);
                    }
                }
                if ((list = this.skuMapper.qryWaitOnShelfSku((Page<QryWaitOnShelfAuditSkuRspVO>)page, qryWaitOnShelfSkuReqBO, commodityTypeIds)) != null && list.size() > 0) {
                    for (QryWaitOnShelfAuditSkuRspVO qryWaitOnShelfSkuRspVO : list) {
                        for (Sku sku : skuList) {
                            if (!qryWaitOnShelfSkuRspVO.getSkuId().equals(sku.getSkuId()) || !qryWaitOnShelfSkuRspVO.getSupplierId().equals(sku.getSupplierId())) continue;
                            qryWaitOnShelfSkuRspVO.setTaskId(sku.getTaskId());
                        }
                    }
                }
                List<QryWaitOnShelfAuditSkuRspBO> qryWaitOnShelfSkuRspBOs = this.resolveRsp(list);
                RspPageBO rspPageBO = new RspPageBO();
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qryWaitOnShelfSkuReqBO.getPageNo());
                rspPageBO.setRows(qryWaitOnShelfSkuRspBOs);
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + qryWaitOnShelfSkuReqBO.toString());
                }
                return rspPageBO;
            }
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(0);
            rspPageBO.setTotal(0);
            rspPageBO.setPageNo(0);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5f85\u4e0a\u67b6\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryWaitOnShelfAuditSkuRspBO> resolveRsp(List<QryWaitOnShelfAuditSkuRspVO> qryWaitOnShelfSkuRspVOs) throws Exception {
        ArrayList<QryWaitOnShelfAuditSkuRspBO> qryWaitOnShelfSkuRspBOs = new ArrayList<QryWaitOnShelfAuditSkuRspBO>();
        if (!qryWaitOnShelfSkuRspVOs.isEmpty()) {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            LinkedList<Long> skuIds = new LinkedList<Long>();
            for (QryWaitOnShelfAuditSkuRspVO qryWaitOnShelfSkuRsp : qryWaitOnShelfSkuRspVOs) {
                commodityTypeIds.add(qryWaitOnShelfSkuRsp.getCommodityTypeId());
                skuIds.add(qryWaitOnShelfSkuRsp.getSkuId());
            }
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeId(commodityTypeIds);
            List<Long> approveDetailSkuIds = this.skuApproveDetailLogMapper.selectSkuApproveDetailLogBatBySkuId(skuIds);
            for (QryWaitOnShelfAuditSkuRspVO qryWaitOnShelfSkuRspVO : qryWaitOnShelfSkuRspVOs) {
                QryWaitOnShelfAuditSkuRspBO qryWaitOnShelfSkuRspBO = new QryWaitOnShelfAuditSkuRspBO();
                qryWaitOnShelfSkuRspBO = this.getQryWaitOnShelfSkuRspBO(qryWaitOnShelfSkuRspBO, qryWaitOnShelfSkuRspVO);
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryWaitOnShelfSkuRspVO.getCommodityTypeId())) continue;
                        qryWaitOnShelfSkuRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryWaitOnShelfSkuRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryWaitOnShelfSkuRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                if (!approveDetailSkuIds.isEmpty()) {
                    if (approveDetailSkuIds.contains(qryWaitOnShelfSkuRspVO.getSkuId())) {
                        qryWaitOnShelfSkuRspBO.setIsReject(Integer.valueOf(0));
                    } else {
                        qryWaitOnShelfSkuRspBO.setIsReject(Integer.valueOf(1));
                    }
                } else {
                    qryWaitOnShelfSkuRspBO.setIsReject(Integer.valueOf(1));
                }
                qryWaitOnShelfSkuRspBOs.add(qryWaitOnShelfSkuRspBO);
            }
        }
        return qryWaitOnShelfSkuRspBOs;
    }

    private QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst(QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO) {
        try {
            QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInstMap = this.qryTodoTaskProcInstMapBusiService.queryTodoTaskProcInstMap(queryTodoTaskProcInstMapReqBO);
            return queryTodoTaskProcInstMap;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25");
        }
    }

    private QryWaitOnShelfAuditSkuRspBO getQryWaitOnShelfSkuRspBO(QryWaitOnShelfAuditSkuRspBO qryWaitOnShelfSkuRspBO, QryWaitOnShelfAuditSkuRspVO qryWaitOnShelfSkuRspVO) throws Exception {
        qryWaitOnShelfSkuRspBO.setSkuId(qryWaitOnShelfSkuRspVO.getSkuId());
        qryWaitOnShelfSkuRspBO.setSkuName(qryWaitOnShelfSkuRspVO.getSkuName());
        qryWaitOnShelfSkuRspBO.setExtSkuId(qryWaitOnShelfSkuRspVO.getExtSkuId());
        qryWaitOnShelfSkuRspBO.setSkuLocation(qryWaitOnShelfSkuRspVO.getSkuLocation());
        qryWaitOnShelfSkuRspBO.setBrandName(qryWaitOnShelfSkuRspVO.getBrandName());
        qryWaitOnShelfSkuRspBO.setSupplierId(qryWaitOnShelfSkuRspVO.getSupplierId());
        qryWaitOnShelfSkuRspBO.setSupplierName(qryWaitOnShelfSkuRspVO.getSupplierName());
        qryWaitOnShelfSkuRspBO.setPublishTime(qryWaitOnShelfSkuRspVO.getPublishTime());
        qryWaitOnShelfSkuRspBO.setTaskId(qryWaitOnShelfSkuRspVO.getTaskId());
        qryWaitOnShelfSkuRspBO.setAgreementPrice(MoneyUtil.Long2BigDecimal((Long)qryWaitOnShelfSkuRspVO.getAgreementPrice()));
        qryWaitOnShelfSkuRspBO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)qryWaitOnShelfSkuRspVO.getMarketPrice()));
        Double rate = (double)qryWaitOnShelfSkuRspVO.getAgreementPrice().longValue() / (double)qryWaitOnShelfSkuRspVO.getMarketPrice().longValue();
        NumberFormat nFromat = NumberFormat.getPercentInstance();
        String rates = nFromat.format(rate);
        qryWaitOnShelfSkuRspBO.setDiscountRate(rates);
        return qryWaitOnShelfSkuRspBO;
    }
}

