/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.cgd.base.cache.CacheManager;
import com.cgd.base.util.SerializeUtils;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.search.builder.search.SearchBuilder;
import com.cgd.search.builder.search.SearchRequestBuilder;
import com.cgd.search.builder.search.SearchRequestBuilderAdapter;
import com.cgd.search.builder.search.filter.BooleanFilterCondition;
import com.cgd.search.builder.search.filter.FilterCondition;
import com.cgd.search.builder.search.filter.MatchFilterCondition;
import com.cgd.search.builder.search.query.BooleanQueryCondition;
import com.cgd.search.builder.search.query.MatchQueryCondition;
import com.cgd.search.builder.search.query.QueryCondition;
import com.cgd.search.builder.search.rank.RankCondition;
import com.cgd.search.builder.search.result.Result;
import com.cgd.search.builder.search.sort.SearchSortMode;
import com.cgd.user.org.busi.QryLittleActOrgByUserBusiService;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserReqBO;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserRspBO;
import com.cgd.user.org.busi.bo.UserOrganisationBO;
import com.ohaotian.commodity.busi.SearchService;
import com.ohaotian.commodity.busi.bo.SearchReqBO;
import com.ohaotian.commodity.busi.bo.SearchRspBO;
import com.ohaotian.commodity.busi.bo.SearchRspInfo;
import com.ohaotian.commodity.busi.vo.QueryParam;
import com.ohaotian.commodity.dao.AgreementScopeMapper;
import com.ohaotian.commodity.dao.BrandMapper;
import com.ohaotian.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.commodity.dao.CommodityPropDefMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Brand;
import com.ohaotian.commodity.dao.po.CommodityGuideCatalog;
import com.ohaotian.commodity.dao.po.CommodityPropDef;
import com.ohaotian.commodity.util.SpecialSymbolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchServiceImpl
implements SearchService {
    private static final Log log = LogFactory.getLog(SearchServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    @Autowired
    private CommodityPropDefMapper commodityPropDefMapper;
    @Autowired
    private QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private SkuMapper skuMapper;

    public SearchRspBO qryBySearchBar(SearchReqBO searchReqBO) {
        RankCondition rankCondition;
        if (this.isDebugEnabled) {
            log.debug((Object)("\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + searchReqBO));
        }
        if (null == searchReqBO.getQueryLocation()) {
            searchReqBO.setQueryLocation(Integer.valueOf(0));
        }
        if (null == searchReqBO.getOrderByColumn()) {
            searchReqBO.setOrderByColumn(Integer.valueOf(0));
        } else if (null == searchReqBO.getOrderType()) {
            searchReqBO.setOrderType(Integer.valueOf(0));
        }
        SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
        searchBuilder.setIndexName(String.valueOf(this.prop.getProperty("os.appName")));
        if (searchReqBO.getPageSize() == null) {
            searchReqBO.setPageSize(Integer.valueOf(20));
        }
        if (searchReqBO.getPageNo() == null) {
            searchReqBO.setPageNo(Integer.valueOf(1));
        }
        int from = searchReqBO.getPageSize() * (searchReqBO.getPageNo() - 1);
        searchBuilder.setFrom(from);
        searchBuilder.setSize(searchReqBO.getPageSize().intValue());
        int os_total_count = Integer.parseInt(this.prop.getProperty("os.total_count"));
        if (from + searchReqBO.getPageSize() > os_total_count) {
            searchBuilder.setSize(os_total_count - from);
        }
        searchBuilder.fetchBuilder().addCol("sku_id").addCol("ext_sku_id").addCol("picture_url").addCol("sale_area").addCol("market_price").addCol("sale_price").addCol("member_price").addCol("sku_name").addCol("supplier_id").addCol("sku_location").addCol("supplier_name").addCol("agreement_id");
        BooleanFilterCondition filter = new BooleanFilterCondition();
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
        int queryLocation = searchReqBO.getQueryLocation();
        if (null != searchReqBO.getQueryParams() && !searchReqBO.getQueryParams().isEmpty()) {
            for (int i = 0; i < searchReqBO.getQueryParams().size(); ++i) {
                QueryParam param = (QueryParam)searchReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                BooleanFilterCondition listFilter = new BooleanFilterCondition();
                BooleanQueryCondition queryCondition = new BooleanQueryCondition();
                this.addFilterFromParam(param, listFilter, queryLocation, queryCondition);
                if (listFilter.should().size() > 0) {
                    filter.must().add(listFilter);
                }
                if (queryCondition.should().size() <= 0) continue;
                booleanQueryCondition.must().add(queryCondition);
            }
        }
        MatchQueryCondition match_status = new MatchQueryCondition();
        match_status.setColumnName("sku_status");
        match_status.setValue("'2'");
        booleanQueryCondition.must().add(match_status);
        if (searchReqBO.getQueryStr() != null) {
            if (StringUtils.isNumeric((CharSequence)searchReqBO.getQueryStr())) {
                MatchQueryCondition match_1 = new MatchQueryCondition();
                match_1.setColumnName("id");
                match_1.setValue("'" + searchReqBO.getQueryStr() + "'");
                booleanQueryCondition.must().add(match_1);
            } else {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("default");
                match_default.setValue("'" + searchReqBO.getQueryStr() + "'");
                rankCondition = new RankCondition();
                rankCondition.setSecondRankName("querybar");
                booleanQueryCondition.must().add(match_default);
                searchBuilder.rankBuilder().setRankCondition(rankCondition);
            }
        }
        searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
        if (searchReqBO.getQueryLocation() != 0) {
            MatchQueryCondition match_location = new MatchQueryCondition();
            match_location.setColumnName("sku_location");
            match_location.setValue("'" + searchReqBO.getQueryLocation() + "'");
            booleanQueryCondition.must().add(match_location);
        }
        if (searchReqBO.getCategoryId() != null && searchReqBO.getLevel() != null) {
            Integer location = searchReqBO.getQueryLocation();
            MatchFilterCondition match_6 = new MatchFilterCondition();
            if (searchReqBO.getLevel() == 1) {
                match_6.setColumnName("l1_category_id");
                match_6.setValue((Object)("'" + searchReqBO.getCategoryId() + "'"));
                filter.must().add(match_6);
            } else if (searchReqBO.getLevel() == 2) {
                match_6.setColumnName("l2_category_id");
                match_6.setValue((Object)("'" + searchReqBO.getCategoryId() + "'"));
                filter.must().add(match_6);
            } else if (searchReqBO.getLevel() == 3) {
                match_6.setColumnName("l3_category_id");
                if (location == 1 || location == 2 || location == 3) {
                    match_6.setValue((Object)("\"" + searchReqBO.getCategoryId() + "*~~" + location + "\""));
                    filter.must().add(match_6);
                } else if (location == 0) {
                    // empty if block
                }
            }
        }
        if (searchReqBO.getSupplierId() != null) {
            MatchFilterCondition match_7 = new MatchFilterCondition();
            match_7.setColumnName("supplier_id");
            match_7.setValue((Object)String.valueOf(searchReqBO.getSupplierId()));
            filter.must().add(match_7);
        }
        if (!filter.must().isEmpty() || !filter.should().isEmpty()) {
            searchBuilder.filterBuilder().setFilterCondition((FilterCondition)filter);
            searchBuilder.aggregateBuilder().setGroupId("brand_id").count();
            searchBuilder.aggregateBuilder().setGroupId("l3_category_id").count().filterBuilder().setFilterCondition((FilterCondition)filter);
            searchBuilder.aggregateBuilder().setGroupId("supplier_id").count();
            searchBuilder.aggregateBuilder().setNestedColName("properties").filterBuilder().setFilterCondition((FilterCondition)filter);
        } else {
            searchBuilder.aggregateBuilder().setGroupId("brand_id").count();
            searchBuilder.aggregateBuilder().setGroupId("l3_category_id").count();
            searchBuilder.aggregateBuilder().setGroupId("supplier_id").count();
            searchBuilder.aggregateBuilder().setNestedColName("properties");
        }
        String kvpairs = null;
        if (searchReqBO.getUserId() != null) {
            kvpairs = this.getagreementIds("user", searchReqBO.getUserId());
        }
        if (searchReqBO.getOrderByColumn() == 1) {
            if (searchReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.DESC);
            }
            if (searchReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.ASC);
            }
        } else if (searchReqBO.getOrderByColumn() == 2) {
            if (searchReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
            }
            if (searchReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.ASC);
            }
        } else if (searchReqBO.getOrderByColumn() == 3) {
            if (searchReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.DESC);
            }
            if (searchReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.ASC);
            }
        } else if (searchReqBO.getOrderByColumn() == 4) {
            if (searchReqBO.getOrderType() == 0) {
                searchBuilder.sortBuilder().addCol("discount_rate", SearchSortMode.DESC);
            }
            if (searchReqBO.getOrderType() == 1) {
                searchBuilder.sortBuilder().addCol("discount_rate", SearchSortMode.ASC);
            }
        } else if (kvpairs != null && searchReqBO.getQueryLocation() != 2) {
            rankCondition = new RankCondition();
            rankCondition.setSecondRankName("second");
            searchBuilder.rankBuilder().setRankCondition(rankCondition);
        }
        log.info((Object)searchBuilder);
        Result result = searchBuilder.build();
        if (result.getTotal() == 0L) {
            JSONArray errorJsonArr = result.getErrors();
            if (errorJsonArr.length() > 0) {
                int i = 0;
                if (i < errorJsonArr.length()) {
                    JSONObject errorJson = errorJsonArr.getJSONObject(i);
                    if (errorJson.getLong("code") == 6009L) {
                        throw new BusinessException("RSP_CODE_EXCEED_LENGTH", "\u8bf7\u6c42\u641c\u7d22\u4e2d\u5fc3\u8fd4\u56de\uff1a\u7b5b\u9009\u6761\u4ef6\u8fc7\u591a\uff01");
                    }
                    throw new BusinessException("RSP_CODE_EXCEED_LENGTH", "\u8bf7\u6c42\u641c\u7d22\u4e2d\u5fc3\u8fd4\u56de\uff1a" + errorJson.getString("message"));
                }
            } else {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u641c\u7d22\u680f\u641c\u7d22\u4e1a\u52a1 \u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6216\u641c\u7d22\u6761\u4ef6\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
        }
        ArrayList<SearchRspInfo> rspInfos = new ArrayList<SearchRspInfo>();
        SearchRspInfo rspInfo = new SearchRspInfo();
        JSONArray recordJsonArr = result.getItems();
        for (int i = 0; i < recordJsonArr.length(); ++i) {
            rspInfo = new SearchRspInfo();
            JSONObject recordJson = recordJsonArr.getJSONObject(i);
            rspInfo.setSkuId(String.valueOf(recordJson.get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(recordJson.get("ext_sku_id")));
            rspInfo.setPriPicUrl(String.valueOf(recordJson.get("picture_url")));
            rspInfo.setSaleArea(String.valueOf(recordJson.get("sale_area")));
            rspInfo.setSkuName(String.valueOf(recordJson.get("sku_name")));
            rspInfo.setSkuLocation(String.valueOf(recordJson.get("sku_location")));
            rspInfo.setSupplierId(String.valueOf(recordJson.get("supplier_id")));
            rspInfo.setSupplierName(String.valueOf(recordJson.get("supplier_name")));
            try {
                if (recordJson.get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(recordJson.get("market_price")))));
                }
                if (searchReqBO.getUserId() != null) {
                    log.debug((Object)"\u5546\u54c1\u4e2d\u5fc3\u641c\u7d22\u680f\u670d\u52a1-\u7528\u6237\u5df2\u767b\u5f55");
                    if (recordJson.get("sale_price") != null) {
                        rspInfo.setSalePrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(recordJson.get("sale_price")))));
                    }
                    if (recordJson.get("member_price") != null) {
                        rspInfo.setMemberPrice(MoneyUtil.Long2BigDecimal((Long)Long.parseLong(String.valueOf(recordJson.get("member_price")))));
                    }
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            rspInfos.add(rspInfo);
            log.debug(rspInfos);
        }
        SearchRspBO bo = new SearchRspBO();
        bo.setQueryStr(searchReqBO.getQueryStr());
        bo.setCategoryId(searchReqBO.getCategoryId());
        bo.setSupplierId(searchReqBO.getSupplierId());
        bo.setQueryLocation(searchReqBO.getQueryLocation());
        bo.setPageNo(searchReqBO.getPageNo());
        bo.setTotalCount(Long.valueOf(result.getTotal()));
        bo.setResult(rspInfos);
        if (searchReqBO.getUserId() != null) {
            bo.setLogin(Boolean.valueOf(true));
        } else {
            bo.setLogin(Boolean.valueOf(false));
        }
        JSONArray arr = result.getAggs();
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        block4: for (int i = 0; i < arr.length(); ++i) {
            String name;
            String valueFromObj;
            JSONObject itemObj;
            int j;
            LinkedList<String> valuesFromArr;
            JSONArray itemArr;
            JSONObject arrObj = arr.getJSONObject(i);
            if ("brand_id".equals(arrObj.get("key")) && !hiddenParamsForRsp.contains("brand_id_name")) {
                itemArr = arrObj.getJSONArray("items");
                valuesFromArr = new LinkedList<String>();
                for (j = 0; j < itemArr.length(); ++j) {
                    itemObj = itemArr.getJSONObject(j);
                    valueFromObj = itemObj.getString("value");
                    if ("".equals(valueFromObj) || valueFromObj == null) continue;
                    name = this.getInnerBrandByKey("brand", valueFromObj);
                    valueFromObj = valueFromObj + "*~~" + name;
                    valuesFromArr.add(valueFromObj);
                }
                if (valuesFromArr.size() > 0) {
                    QueryParam singleQP = new QueryParam();
                    singleQP.setFilterId("brand_id_name");
                    singleQP.setFilterName("\u54c1\u724c");
                    singleQP.setFilterValues(valuesFromArr);
                    testParams.add(singleQP);
                }
            }
            if ("supplier_id".equals(arrObj.get("key")) && !hiddenParamsForRsp.contains("supplier_id_name")) {
                itemArr = arrObj.getJSONArray("items");
                valuesFromArr = new LinkedList();
                for (j = 0; j < itemArr.length(); ++j) {
                    itemObj = itemArr.getJSONObject(j);
                    valueFromObj = itemObj.getString("value");
                    if ("".equals(valueFromObj) || valueFromObj == null) continue;
                    name = this.getInnerBrandByKey("supplier", valueFromObj);
                    valueFromObj = valueFromObj + "*~~" + name;
                    valuesFromArr.add(valueFromObj);
                }
                if (valuesFromArr.size() > 0) {
                    QueryParam singleQP = new QueryParam();
                    singleQP.setFilterId("supplier_id_name");
                    singleQP.setFilterName("\u4f9b\u5e94\u5546");
                    singleQP.setFilterValues(valuesFromArr);
                    testParams.add(singleQP);
                }
            }
            if ("l3_category_id".equals(arrObj.get("key")) && !hiddenParamsForRsp.contains("l3_category_id_name")) {
                itemArr = arrObj.getJSONArray("items");
                valuesFromArr = new LinkedList();
                for (int j2 = 0; j2 < itemArr.length(); ++j2) {
                    itemObj = itemArr.getJSONObject(j2);
                    valueFromObj = itemObj.getString("value");
                    String[] ids = valueFromObj.split("\\*~~");
                    if (ids.length <= 0 || ids[0] == null || ids[1] == null || "0".equals(ids[1])) continue;
                    String name2 = this.getInnerBrandByKey("category", ids[0]);
                    valueFromObj = ids[0] + "*~~" + name2;
                    if ("".equals(valueFromObj) || valueFromObj == null) continue;
                    valuesFromArr.add(valueFromObj);
                }
                if (valuesFromArr.size() > 0) {
                    QueryParam singleQP = new QueryParam();
                    singleQP.setFilterId("l3_category_id_name");
                    singleQP.setFilterName("\u5206\u7c7b");
                    singleQP.setFilterValues(valuesFromArr);
                    testParams.add(singleQP);
                }
            }
            if (!"properties".equals(arrObj.get("key"))) continue;
            itemArr = arrObj.getJSONArray("items");
            Hashtable<String, String> singleParam = new Hashtable<String, String>();
            LinkedList<Map<String, String>> singleParams = new LinkedList<Map<String, String>>();
            for (int j3 = 0; j3 < itemArr.length(); ++j3) {
                String name3;
                singleParam = new Hashtable();
                JSONObject itemObj2 = itemArr.getJSONObject(j3);
                String itemMapStr = itemObj2.getString("value");
                String[] itemMapStrs = itemMapStr.split("\\*~~");
                if (itemMapStrs.length <= 1 || "".equals(itemMapStrs[0]) || "".equals(itemMapStrs[1]) || (name3 = this.getInnerBrandByKey("property", itemMapStrs[0])) == null || name3.indexOf("\u54c1\u724c") != -1) continue;
                singleParam.put(itemMapStrs[0] + "*~~" + name3, itemMapStrs[1]);
                singleParams.add(singleParam);
            }
            if (singleParams.isEmpty()) continue;
            Map<String, List<String>> mapForListSearch = this.convertListMapToMap(singleParams);
            int cnt = 0;
            for (Map.Entry<String, List<String>> entry : mapForListSearch.entrySet()) {
                QueryParam singleParamFromProp = new QueryParam();
                String[] keyStr = entry.getKey().split("\\*~~");
                if (hiddenParamsForRsp.contains(keyStr[0])) continue;
                singleParamFromProp.setFilterId(keyStr[0]);
                singleParamFromProp.setFilterName(keyStr[1]);
                singleParamFromProp.setFilterValues(entry.getValue());
                testParams.add(singleParamFromProp);
                if (++cnt < 8) continue;
                continue block4;
            }
        }
        bo.setQueryParams(testParams);
        return bo;
    }

    private Map<String, List<String>> convertListMapToMap(List<Map<String, String>> list) {
        HashMap<String, HashSet<String>> setResult = new HashMap<String, HashSet<String>>();
        for (Map<String, String> map : list) {
            for (String key : map.keySet()) {
                HashSet<String> value = (HashSet<String>)setResult.get(key);
                if (value == null) {
                    value = new HashSet<String>();
                }
                value.add(map.get(key));
                setResult.put(key, value);
            }
        }
        HashMap<String, List<String>> listResult = new HashMap<String, List<String>>();
        for (String key : setResult.keySet()) {
            Set set = (Set)setResult.get(key);
            LinkedList valueList = new LinkedList();
            valueList.addAll(set);
            listResult.put(key, valueList);
        }
        return listResult;
    }

    private void addFilterFromParam(QueryParam param, BooleanFilterCondition filter, int queryLocation, BooleanQueryCondition queryCondition) {
        List values = param.getFilterValues();
        for (int i = 0; i < values.size(); ++i) {
            MatchQueryCondition matchQueryCondition = new MatchQueryCondition();
            MatchFilterCondition matchFilter = new MatchFilterCondition();
            String comStr = "";
            if ("supplier_id_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("supplier_id");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            if ("brand_id_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("brand_id");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            if ("l3_category_id_name".equals(param.getFilterId())) {
                if (queryLocation == 0) {
                    for (int j = 0; j < 3; ++j) {
                        matchQueryCondition = new MatchQueryCondition();
                        matchQueryCondition.setColumnName("l3_category_id");
                        String[] ids = ((String)values.get(i)).split("\\*~~");
                        comStr = "\"" + ids[0] + "*~~" + j + "\"";
                        matchQueryCondition.setValue(comStr);
                        queryCondition.should().add(matchQueryCondition);
                        matchFilter = new MatchFilterCondition();
                        matchFilter.setColumnName("l3_category_id");
                        matchFilter.setValue((Object)comStr);
                        filter.should().add(matchFilter);
                    }
                    continue;
                }
                matchQueryCondition.setColumnName("l3_category_id");
                String[] ids = ((String)values.get(i)).split("\\*~~");
                comStr = "\"" + ids[0] + "*~~" + queryLocation + "\"";
                matchQueryCondition.setValue(comStr);
                queryCondition.should().add(matchQueryCondition);
                matchFilter.setColumnName("l3_category_id");
                matchFilter.setValue((Object)comStr);
                filter.should().add(matchFilter);
                continue;
            }
            if ("current_location_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("current_location");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            if ("production_date_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("production_date");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            if ("lease_type_name".equals(param.getFilterId())) {
                MatchQueryCondition match_default = new MatchQueryCondition();
                match_default.setColumnName("lease_type");
                match_default.setValue("'" + ((String)values.get(i)).split("\\*~~")[0] + "'");
                queryCondition.should().add(match_default);
                continue;
            }
            matchQueryCondition.setColumnName("properties");
            String propStr = (String)values.get(i);
            if (SpecialSymbolUtils.isSpecialSymbols(propStr)) {
                char x = SpecialSymbolUtils.specialSymbol(propStr);
                propStr = propStr.replace(String.valueOf(x), "\\" + String.valueOf(x));
            }
            matchQueryCondition.setValue("\"" + param.getFilterId() + "*~~" + propStr + "\"");
            queryCondition.should().add(matchQueryCondition);
            matchFilter.setColumnName("properties");
            matchFilter.setValue((Object)("\"" + param.getFilterId() + "*~~" + propStr + "\""));
            filter.should().add(matchFilter);
        }
    }

    private String getInnerBrandByKey(String keyName, String key) {
        byte[] value = this.cacheManager.get((keyName + "_" + key).getBytes());
        if (value == null || value.length <= 0) {
            CommodityPropDef prop;
            log.debug((Object)"\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u6267\u884c\u672c\u5730\u6570\u636e\u67e5\u8be2\u5668\u67e5\u8be2\u6570\u636e");
            if (keyName.equals("brand")) {
                Brand brand = this.brandMapper.selectByPrimaryKey(Long.parseLong(key));
                if (brand != null) {
                    this.put("brand_" + key, brand.getBrandName());
                }
            } else if (keyName.equals("supplier")) {
                String supplierName = (String)this.prop.get("SUPPLIER_NAME_" + key);
                Object supplierInfoRepBO = null;
                try {
                    if (supplierName == null) {
                        Long supplierId = Long.parseLong(key);
                        supplierName = this.skuMapper.getSupplierNameById(supplierId);
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u4f9b\u5e94\u5546\u540d\u79f0\u51fa\u9519: " + e.getMessage());
                }
                if (supplierName != null) {
                    this.put("supplier_" + key, supplierName);
                }
            } else if (keyName.equals("category")) {
                CommodityGuideCatalog catalog = this.commodityGuideCatalogMapper.selectByPrimaryKey(Long.parseLong(key));
                if (catalog != null) {
                    this.put("category_" + key, catalog.getCatalogName());
                }
            } else if (keyName.equals("property") && (prop = this.commodityPropDefMapper.selectByPrimaryKey(Long.parseLong(key))) != null) {
                this.put("property_" + key, prop.getPropName());
            }
            return (String)SerializeUtils.deserialize((byte[])this.cacheManager.get((keyName + "_" + key).getBytes()));
        }
        return (String)SerializeUtils.deserialize((byte[])value);
    }

    private void put(String key, Object value) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize((Object)value), 600);
    }

    private void put(String key, Object value, int expire) {
        this.cacheManager.set(key.getBytes(), SerializeUtils.serialize((Object)value), expire);
    }

    private String getagreementIds(String keyName, Long userId) {
        byte[] value;
        block10: {
            value = this.cacheManager.get((keyName + "_" + userId).getBytes());
            if (value == null || value.length <= 0) {
                log.debug((Object)"\u767b\u9646\u7528\u6237\u534f\u8bae\u6570\u636e\u5728\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\uff01\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u6570\u636e");
                try {
                    HashSet<Long> agreementIds = new HashSet<Long>();
                    QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO = new QryLittleActOrgByUserReqBO();
                    qryLittleActOrgByUserReqBO.setUserParamId(userId);
                    QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO = this.qryLittleActOrgByUserBusiService.qryLittleActOrgByUser(qryLittleActOrgByUserReqBO);
                    if ("0000".equals(qryLittleActOrgByUserRspBO.getRespCode())) {
                        Long provId = qryLittleActOrgByUserRspBO.getProvId();
                        Long trade = qryLittleActOrgByUserRspBO.getTrade();
                        UserOrganisationBO branchComp = qryLittleActOrgByUserRspBO.getBranchComp();
                        UserOrganisationBO projectComp = qryLittleActOrgByUserRspBO.getProjectComp();
                        Long orgId = null;
                        List<Long> ids = null;
                        if (provId != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = provId, 1L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (trade != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = trade, 2L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (branchComp != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = branchComp.getAutoId(), 3L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (projectComp != null && (ids = this.agreementScopeMapper.selectAgreementIdsByScopeCode(orgId = projectComp.getAutoId(), 4L)).size() > 0) {
                            agreementIds.addAll(ids);
                        }
                        if (agreementIds.size() > 0) {
                            StringBuffer redisIds = new StringBuffer();
                            for (Long id : agreementIds) {
                                redisIds.append(id + ":");
                            }
                            redisIds.deleteCharAt(redisIds.length() - 1);
                            this.put("user_" + userId, redisIds.toString(), 600);
                            return (String)SerializeUtils.deserialize((byte[])this.cacheManager.get((keyName + "_" + userId).getBytes()));
                        }
                        break block10;
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u641c\u7d22\u680f\u670d\u52a1\u9519\u8bef\uff1a\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f[QryLittleActOrgByUserBusiService]\u8fd4\u56de" + qryLittleActOrgByUserRspBO.getRespDesc());
                }
                catch (Exception e) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u641c\u7d22\u680f\u670d\u52a1\u9519\u8bef\uff1a\u5f02\u5e38\u4fe1\u606f\u4e3a" + e.getMessage());
                }
            }
        }
        return (String)SerializeUtils.deserialize((byte[])value);
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }
}

