/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.base.util.BeanMapper;
import com.cgd.commodity.busi.BatQrySKUStockService;
import com.cgd.commodity.busi.bo.BatQrySKUStockReqBO;
import com.cgd.commodity.busi.bo.BatQrySKUStockRspBO;
import com.cgd.commodity.busi.vo.BatQrySKUStockReqVO;
import com.cgd.commodity.busi.vo.BatQrySKUStockRspVO;
import com.cgd.common.exception.BusinessException;
import com.cgd.electricitysupplier.busi.QryExtSkuIdService;
import com.cgd.electricitysupplier.busi.QrySKUStockFromInterService;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQryExtSkuIdRspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUStockReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUStockRspBO;
import com.cgd.electricitysupplier.busi.vo.BusiQrySKUStockRspVO;
import com.cgd.electricitysupplier.busi.vo.QrySKUStockSkuNumReqVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BatQrySKUStockServiceImpl
implements BatQrySKUStockService {
    private static final Logger logger = LoggerFactory.getLogger(BatQrySKUStockServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    private QrySKUStockFromInterService qrySKUStockFromInterService;
    private QryExtSkuIdService qryExtSkuIdService;

    public BatQrySKUStockRspBO batQrySKUStock(BatQrySKUStockReqBO batQrySKUStockReqBO) {
        String[] areas;
        if (this.isDebugEnabled) {
            logger.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u6709\u8d27/\u65e0\u8d27\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + batQrySKUStockReqBO.toString());
        }
        if (null == batQrySKUStockReqBO.getArea()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u6709\u8d27/\u65e0\u8d27\u7ec4\u5408\u670d\u52a1\u5730\u5740[area]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == batQrySKUStockReqBO.getSkuNums() || batQrySKUStockReqBO.getSkuNums().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u6709\u8d27/\u65e0\u8d27\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4fe1\u606f[skuNums]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BatQrySKUStockRspBO batQrySKUStockRspBO = new BatQrySKUStockRspBO();
        String area = batQrySKUStockReqBO.getArea();
        if (!StringUtils.isEmpty((Object)area) && (areas = area.split("_")).length == 4) {
            area = areas[0] + "_" + areas[1] + "_" + areas[2];
        }
        List skuNums = batQrySKUStockReqBO.getSkuNums();
        ArrayList<Long> noExistSkuIds = new ArrayList<Long>();
        this.initReqStr(batQrySKUStockReqBO, noExistSkuIds);
        BusiQrySKUStockReqBO busiQrySKUStockReqBO = new BusiQrySKUStockReqBO();
        busiQrySKUStockReqBO.setArea(area);
        ArrayList<BatQrySKUStockRspVO> vos = new ArrayList<BatQrySKUStockRspVO>();
        for (BatQrySKUStockReqVO batQrySKUStockReqVO : skuNums) {
            ArrayList<QrySKUStockSkuNumReqVO> qrySKUStockSkuNumReqVOs = new ArrayList<QrySKUStockSkuNumReqVO>();
            QrySKUStockSkuNumReqVO qrySKUStockSkuNumReqVO = new QrySKUStockSkuNumReqVO();
            qrySKUStockSkuNumReqVO.setNum(Integer.valueOf(1));
            qrySKUStockSkuNumReqVO.setSkuId(batQrySKUStockReqVO.getSkuId());
            qrySKUStockSkuNumReqVOs.add(qrySKUStockSkuNumReqVO);
            busiQrySKUStockReqBO.setSupplierId(batQrySKUStockReqVO.getSupplierId());
            busiQrySKUStockReqBO.setSkuNums(qrySKUStockSkuNumReqVOs);
            BusiQrySKUStockRspBO busiQrySKUStockRspBO = null;
            try {
                busiQrySKUStockRspBO = this.qrySKUStockFromInterService.qrySKUStock(busiQrySKUStockReqBO);
            }
            catch (Exception e) {
                batQrySKUStockRspBO.setResultMessage(batQrySKUStockRspBO.getResultMessage() == null ? "" : batQrySKUStockRspBO.getResultMessage() + "," + e.getMessage());
                continue;
            }
            if ("0000".equals(busiQrySKUStockRspBO.getRespCode())) {
                if (!busiQrySKUStockRspBO.getSkuStocks().isEmpty()) {
                    BusiQrySKUStockRspVO vo = (BusiQrySKUStockRspVO)busiQrySKUStockRspBO.getSkuStocks().get(0);
                    BatQrySKUStockRspVO rspVO = new BatQrySKUStockRspVO();
                    BeanMapper.copy((Object)vo, (Object)rspVO);
                    vos.add(rspVO);
                    continue;
                }
                batQrySKUStockRspBO.setResultMessage(batQrySKUStockRspBO.getResultMessage() + "," + busiQrySKUStockRspBO.getResultMessage());
                continue;
            }
            if ("0000".equals(busiQrySKUStockRspBO.getRespCode())) continue;
            if (this.isDebugEnabled) {
                logger.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u6709\u8d27/\u65e0\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u67e5\u8be2\u5e93\u5b58\u670d\u52a1\u5931\u8d25:" + busiQrySKUStockRspBO.getRespDesc());
            }
            BatQrySKUStockRspVO rspVO = new BatQrySKUStockRspVO();
            rspVO.setAreaId(area);
            rspVO.setSkuId(String.valueOf(batQrySKUStockReqVO.getSkuId()));
            rspVO.setStockStateDesc("\u65e0\u8d27");
            rspVO.setStockStateId(Integer.valueOf(34));
            vos.add(rspVO);
        }
        batQrySKUStockRspBO.setSkuStocks(vos);
        if (noExistSkuIds != null && noExistSkuIds.size() > 0) {
            batQrySKUStockRspBO.setResultMessage("\u5546\u54c1SKUID" + noExistSkuIds + "\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            for (Long skuId : noExistSkuIds) {
                BatQrySKUStockRspVO rspVO = new BatQrySKUStockRspVO();
                rspVO.setAreaId(area);
                rspVO.setSkuId(String.valueOf(skuId));
                rspVO.setStockStateDesc("\u65e0\u8d27");
                rspVO.setStockStateId(Integer.valueOf(34));
                vos.add(rspVO);
            }
        }
        batQrySKUStockRspBO.setSkuStocks(vos);
        return batQrySKUStockRspBO;
    }

    private void initReqStr(BatQrySKUStockReqBO batQrySKUStockReqBO, List<Long> noExistSkuIds) {
        BusiQryExtSkuIdReqBO busiQryExtSkuIdReqBO = new BusiQryExtSkuIdReqBO();
        List skuNums = batQrySKUStockReqBO.getSkuNums();
        for (BatQrySKUStockReqVO sku : skuNums) {
            ArrayList<Long> busiQryExtSkuIdReqSkuIds = new ArrayList<Long>();
            busiQryExtSkuIdReqSkuIds.add(sku.getSkuId());
            busiQryExtSkuIdReqBO.setSupplierId(sku.getSupplierId());
            busiQryExtSkuIdReqBO.setSkuIds(busiQryExtSkuIdReqSkuIds);
            BusiQryExtSkuIdRspBO busiQryExtSkuIdRspBO = this.qryExtSkuIdService.qryExtSkuId(busiQryExtSkuIdReqBO);
            if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode()) && busiQryExtSkuIdRspBO.getResult().isEmpty()) {
                noExistSkuIds.add(sku.getSkuId());
            }
            if ("0000".equals(busiQryExtSkuIdRspBO.getRespCode())) continue;
            if (this.isDebugEnabled) {
                logger.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u6709\u8d27/\u65e0\u8d27\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + busiQryExtSkuIdRspBO.getRespDesc());
            }
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u5916\u90e8\u7535\u5546skuId\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        for (Long longSkuId : noExistSkuIds) {
            for (int i = 0; i < skuNums.size(); ++i) {
                if (((BatQrySKUStockReqVO)skuNums.get(i)).getSkuId() != longSkuId) continue;
                skuNums.remove(i);
            }
        }
        batQrySKUStockReqBO.setSkuNums(skuNums);
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public QrySKUStockFromInterService getQrySKUStockFromInterService() {
        return this.qrySKUStockFromInterService;
    }

    public void setQrySKUStockFromInterService(QrySKUStockFromInterService qrySKUStockFromInterService) {
        this.qrySKUStockFromInterService = qrySKUStockFromInterService;
    }

    public QryExtSkuIdService getQryExtSkuIdService() {
        return this.qryExtSkuIdService;
    }

    public void setQryExtSkuIdService(QryExtSkuIdService qryExtSkuIdService) {
        this.qryExtSkuIdService = qryExtSkuIdService;
    }
}

