/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.CreatSkuPriceChangeLogService;
import com.cgd.commodity.busi.bo.CreatSkuPriceChangeReqBO;
import com.cgd.commodity.busi.bo.CreatSkuPriceChangeRspBO;
import com.cgd.commodity.busi.vo.CreatSkuPriceChangeReqVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuPriceChangeLogMapper;
import com.cgd.commodity.po.SkuPriceChangeLog;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatSkuPriceChangeLogServiceImpl
implements CreatSkuPriceChangeLogService {
    private static final Logger logger = LoggerFactory.getLogger(CreatSkuPriceChangeLogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuPriceChangeLogMapper skuPriceChangeLogMapper;

    public void setSkuPriceChangeLogMapper(SkuPriceChangeLogMapper skuPriceChangeLogMapper) {
        this.skuPriceChangeLogMapper = skuPriceChangeLogMapper;
    }

    public CreatSkuPriceChangeRspBO creatSkuPriceChangeLog(CreatSkuPriceChangeReqBO creatSkuPriceChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + creatSkuPriceChangeReqBO.toString());
        }
        if (creatSkuPriceChangeReqBO.getSkuPriceLogs().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u96c6\u5408[skuPriceLogs]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ArrayList<SkuPriceChangeLog> skuPriceChangeLogs = new ArrayList<SkuPriceChangeLog>();
            for (CreatSkuPriceChangeReqVO creatSkuPriceChangeReqVO : creatSkuPriceChangeReqBO.getSkuPriceLogs()) {
                SkuPriceChangeLog skuPriceChangeLog = new SkuPriceChangeLog();
                skuPriceChangeLog.setSkuId(creatSkuPriceChangeReqVO.getSkuId());
                skuPriceChangeLog.setSupplierId(creatSkuPriceChangeReqVO.getSupplierId());
                skuPriceChangeLog.setSkuName(creatSkuPriceChangeReqVO.getSkuName());
                skuPriceChangeLog.setCreateLoginId(creatSkuPriceChangeReqVO.getCreateLoginId());
                skuPriceChangeLog.setCreateTime(creatSkuPriceChangeReqVO.getCreateTime());
                skuPriceChangeLog.setIsDelete(Constant.IS_DELETE);
                skuPriceChangeLog.setRemark(creatSkuPriceChangeReqVO.getRemark());
                skuPriceChangeLog.setCurrencyType(creatSkuPriceChangeReqVO.getCurrencyType());
                skuPriceChangeLog.setPostAgreementPrice(creatSkuPriceChangeReqVO.getPostAgreementPrice());
                skuPriceChangeLog.setPostMarketPrice(creatSkuPriceChangeReqVO.getPostMarketPrice());
                skuPriceChangeLog.setPostMemberPrice(creatSkuPriceChangeReqVO.getPostMemberPrice());
                skuPriceChangeLog.setPostSalePrice(creatSkuPriceChangeReqVO.getPostSalePrice());
                skuPriceChangeLog.setPreAgreementPrice(creatSkuPriceChangeReqVO.getPreAgreementPrice());
                skuPriceChangeLog.setPreMarketPrice(creatSkuPriceChangeReqVO.getPreMarketPrice());
                skuPriceChangeLog.setPreMemberPrice(creatSkuPriceChangeReqVO.getPreMemberPrice());
                skuPriceChangeLog.setPreSalePrice(creatSkuPriceChangeReqVO.getPreSalePrice());
                skuPriceChangeLog.setSkuLocation(creatSkuPriceChangeReqVO.getSkuLocation());
                if (null != creatSkuPriceChangeReqVO.getUpdateLoginId()) {
                    skuPriceChangeLog.setUpdateLoginId(creatSkuPriceChangeReqVO.getUpdateLoginId());
                    skuPriceChangeLog.setUpdateTime(new Date());
                }
                skuPriceChangeLogs.add(skuPriceChangeLog);
            }
            this.skuPriceChangeLogMapper.insertBatch(skuPriceChangeLogs);
            CreatSkuPriceChangeRspBO creatSkuPriceChangeRspBO = new CreatSkuPriceChangeRspBO();
            creatSkuPriceChangeRspBO.setIsSuccess(Boolean.valueOf(true));
            return creatSkuPriceChangeRspBO;
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }
}

