/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.DelAgrDetailChangeService;
import com.cgd.commodity.busi.bo.agreement.DelAgrDetailChangeBO;
import com.cgd.commodity.busi.bo.agreement.DelAgrDetailChangeReqBO;
import com.cgd.commodity.busi.bo.agreement.DelAgrDetailChangeRspBO;
import com.cgd.commodity.dao.AgrAdjustPriceFormulaChangeMapper;
import com.cgd.commodity.dao.AgreementDetailChangeMapper;
import com.cgd.commodity.po.AgreementDetailChange;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelAgrDetailChangeServiceImpl
implements DelAgrDetailChangeService {
    private static final Logger logger = LoggerFactory.getLogger(DelAgrDetailChangeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementDetailChangeMapper agreementDetailChangeMapper;
    private AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper;

    public void setAgreementDetailChangeMapper(AgreementDetailChangeMapper agreementDetailChangeMapper) {
        this.agreementDetailChangeMapper = agreementDetailChangeMapper;
    }

    public void setAgrAdjustPriceFormulaChangeMapper(AgrAdjustPriceFormulaChangeMapper agrAdjustPriceFormulaChangeMapper) {
        this.agrAdjustPriceFormulaChangeMapper = agrAdjustPriceFormulaChangeMapper;
    }

    public DelAgrDetailChangeRspBO delAgrDetailChange(DelAgrDetailChangeReqBO delAgrDetailChangeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u79fb\u9664\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + delAgrDetailChangeReqBO.toString());
        }
        DelAgrDetailChangeRspBO rsp = new DelAgrDetailChangeRspBO();
        try {
            ArrayList<AgreementDetailChange> list = new ArrayList<AgreementDetailChange>();
            ArrayList<Long> agreementDetailChangeIds = new ArrayList<Long>();
            if (delAgrDetailChangeReqBO != null) {
                if (delAgrDetailChangeReqBO.getOperationType().equals(0) && delAgrDetailChangeReqBO.getDelAgrDetailChangeBOList().size() > 0) {
                    for (DelAgrDetailChangeBO agrDetailChange : delAgrDetailChangeReqBO.getDelAgrDetailChangeBOList()) {
                        AgreementDetailChange agreementDetailChange = new AgreementDetailChange();
                        Long detailChangeId = agrDetailChange.getDetailChangeId();
                        BeanUtils.copyProperties((Object)agreementDetailChange, (Object)agrDetailChange);
                        list.add(agreementDetailChange);
                        agreementDetailChangeIds.add(detailChangeId);
                    }
                    if (agreementDetailChangeIds != null && agreementDetailChangeIds.size() > 0) {
                        this.agrAdjustPriceFormulaChangeMapper.deleteByDetailChangeIds(agreementDetailChangeIds);
                    }
                    this.agreementDetailChangeMapper.deleteByList(list);
                } else {
                    List<Long> detailChangeIds = this.agreementDetailChangeMapper.selectByAgrIdAndSup(delAgrDetailChangeReqBO.getAgreementId(), delAgrDetailChangeReqBO.getSupplierId());
                    if (detailChangeIds != null && detailChangeIds.size() > 0) {
                        this.agrAdjustPriceFormulaChangeMapper.deleteByDetailChangeIds(detailChangeIds);
                    }
                    this.agreementDetailChangeMapper.deleteByIds(delAgrDetailChangeReqBO.getAgreementId(), delAgrDetailChangeReqBO.getSupplierId());
                }
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            rsp.setSuccess(false);
            logger.error("\u79fb\u9664\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u79fb\u9664\u8865\u5145\u534f\u8bae\u660e\u7ec6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }
}

