/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryAgrInfoByAgrIdService;
import com.cgd.commodity.busi.bo.agreement.QryAgrInfoByAgrIdReqBO;
import com.cgd.commodity.busi.bo.agreement.QryAgrInfoByAgrIdRspBO;
import com.cgd.commodity.busi.vo.agreement.QryAgrAddPricePropRspVO;
import com.cgd.commodity.busi.vo.agreement.QryAgrAttachRspVO;
import com.cgd.commodity.busi.vo.agreement.QryAgrOtherAttachRspVO;
import com.cgd.commodity.busi.vo.agreement.QryAgrScopeRspVO;
import com.cgd.commodity.dao.AgreementAddPricePropMapper;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.SupplierAgreementAttachMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.commodity.po.SupplierAgreementAttach;
import com.cgd.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryAgrInfoByAgrIdServiceImpl
implements QryAgrInfoByAgrIdService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrInfoByAgrIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    private AgreementScopeMapper agreementScopeMapper;
    private AgreementAddPricePropMapper agreementAddPricePropMapper;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementAttachMapper(SupplierAgreementAttachMapper supplierAgreementAttachMapper) {
        this.supplierAgreementAttachMapper = supplierAgreementAttachMapper;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public void setAgreementAddPricePropMapper(AgreementAddPricePropMapper agreementAddPricePropMapper) {
        this.agreementAddPricePropMapper = agreementAddPricePropMapper;
    }

    public QryAgrInfoByAgrIdRspBO qryAgrInfoByAgrId(QryAgrInfoByAgrIdReqBO qryAgrInfoByAgrIdReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u534f\u8bae\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrInfoByAgrIdReqBO.toString());
        }
        try {
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(qryAgrInfoByAgrIdReqBO.getAgreementId(), qryAgrInfoByAgrIdReqBO.getSupplierId());
            if (null != supplierAgreement) {
                List<SupplierAgreementAttach> supplierAgreementAttachs = this.supplierAgreementAttachMapper.qryAgrAttachById(qryAgrInfoByAgrIdReqBO.getAgreementId(), qryAgrInfoByAgrIdReqBO.getSupplierId());
                HashMap<String, Number> paramMap = new HashMap<String, Number>();
                paramMap.put("agreementId", qryAgrInfoByAgrIdReqBO.getAgreementId());
                paramMap.put("supplierId", qryAgrInfoByAgrIdReqBO.getSupplierId());
                paramMap.put("scopeType", supplierAgreement.getScopeType());
                List<QryAgrScopeRspVO> agreementScopes = this.agreementScopeMapper.selectByIdAndType(paramMap);
                List<QryAgrAddPricePropRspVO> agrAddPriceProps = this.agreementAddPricePropMapper.selectAddPriceDetailById(qryAgrInfoByAgrIdReqBO.getAgreementId(), qryAgrInfoByAgrIdReqBO.getSupplierId());
                return this.resolveResult(supplierAgreement, supplierAgreementAttachs, agreementScopes, agrAddPriceProps);
            }
            return new QryAgrInfoByAgrIdRspBO();
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u534f\u8bae\u8be6\u60c5\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u534f\u8bae\u8be6\u60c5\u670d\u52a1\u5931\u8d25");
        }
    }

    private QryAgrInfoByAgrIdRspBO resolveResult(SupplierAgreement supplierAgreement, List<SupplierAgreementAttach> supplierAgreementAttachs, List<QryAgrScopeRspVO> agreementScopes, List<QryAgrAddPricePropRspVO> agrAddPriceProps) {
        QryAgrInfoByAgrIdRspBO qryAgrInfoByAgrIdRspBO = new QryAgrInfoByAgrIdRspBO();
        if (null != supplierAgreement) {
            qryAgrInfoByAgrIdRspBO.setAdjustPrice(supplierAgreement.getAdjustPrice());
            qryAgrInfoByAgrIdRspBO.setAdjustPriceFormula(supplierAgreement.getAdjustPriceFormula());
            qryAgrInfoByAgrIdRspBO.setAgreementName(supplierAgreement.getAgreementName());
            qryAgrInfoByAgrIdRspBO.setAgreementSrc(supplierAgreement.getAgreementSrc());
            qryAgrInfoByAgrIdRspBO.setAgreementType(supplierAgreement.getAgreementType());
            qryAgrInfoByAgrIdRspBO.setEffDate(supplierAgreement.getEffDate());
            qryAgrInfoByAgrIdRspBO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
            qryAgrInfoByAgrIdRspBO.setExpDate(supplierAgreement.getExpDate());
            qryAgrInfoByAgrIdRspBO.setIsDispatch(supplierAgreement.getIsDispatch());
            qryAgrInfoByAgrIdRspBO.setMatPayEnt(supplierAgreement.getMatPayEnt());
            qryAgrInfoByAgrIdRspBO.setMatPaySup(supplierAgreement.getMatPaySup());
            qryAgrInfoByAgrIdRspBO.setMatterName(supplierAgreement.getMatterName());
            qryAgrInfoByAgrIdRspBO.setPayClause(supplierAgreement.getPayClause());
            qryAgrInfoByAgrIdRspBO.setPilPayEnt(supplierAgreement.getPilPayEnt());
            qryAgrInfoByAgrIdRspBO.setPilPaySup(supplierAgreement.getPilPaySup());
            qryAgrInfoByAgrIdRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
            qryAgrInfoByAgrIdRspBO.setPrePayEnt(supplierAgreement.getPrePayEnt());
            qryAgrInfoByAgrIdRspBO.setPrePaySup(supplierAgreement.getPrePaySup());
            qryAgrInfoByAgrIdRspBO.setProducerName(supplierAgreement.getProducerName());
            qryAgrInfoByAgrIdRspBO.setProduceTime(supplierAgreement.getProduceTime());
            qryAgrInfoByAgrIdRspBO.setProPayEnt(supplierAgreement.getProPayEnt());
            qryAgrInfoByAgrIdRspBO.setProPaySup(supplierAgreement.getProPaySup());
            qryAgrInfoByAgrIdRspBO.setQuaPayEnt(supplierAgreement.getQuaPayEnt());
            qryAgrInfoByAgrIdRspBO.setQuaPaySup(supplierAgreement.getQuaPaySup());
            qryAgrInfoByAgrIdRspBO.setRemark(supplierAgreement.getRemark());
            qryAgrInfoByAgrIdRspBO.setSignTime(supplierAgreement.getSignTime());
            qryAgrInfoByAgrIdRspBO.setSupplierName(supplierAgreement.getSupplierName());
            qryAgrInfoByAgrIdRspBO.setSupplyCycle(supplierAgreement.getSupplyCycle());
            qryAgrInfoByAgrIdRspBO.setTaxRate(supplierAgreement.getTaxRate());
            qryAgrInfoByAgrIdRspBO.setVendorContact(supplierAgreement.getVendorContact());
            qryAgrInfoByAgrIdRspBO.setVendorName(supplierAgreement.getVendorName());
            qryAgrInfoByAgrIdRspBO.setVendorPhone(supplierAgreement.getVendorPhone());
            qryAgrInfoByAgrIdRspBO.setVerPayEnt(supplierAgreement.getVerPayEnt());
            qryAgrInfoByAgrIdRspBO.setVerPaySup(supplierAgreement.getVerPaySup());
            qryAgrInfoByAgrIdRspBO.setWarantty(supplierAgreement.getWarantty());
            qryAgrInfoByAgrIdRspBO.setVendorId(supplierAgreement.getVendorId());
            qryAgrInfoByAgrIdRspBO.setProducerId(supplierAgreement.getProducerId());
            qryAgrInfoByAgrIdRspBO.setAgreementId(supplierAgreement.getAgreementId());
            qryAgrInfoByAgrIdRspBO.setCurrency(supplierAgreement.getCurrency());
            qryAgrInfoByAgrIdRspBO.setSupplierId(supplierAgreement.getSupplierId());
            qryAgrInfoByAgrIdRspBO.setScopeType(supplierAgreement.getScopeType());
            qryAgrInfoByAgrIdRspBO.setServiceRate(supplierAgreement.getServiceRate());
            qryAgrInfoByAgrIdRspBO.setAgreementStatus(supplierAgreement.getAgreementStatus());
            qryAgrInfoByAgrIdRspBO.setMaterialNameSum(supplierAgreement.getMaterialNameSum());
            qryAgrInfoByAgrIdRspBO.setIsAddPrice(supplierAgreement.getIsAddPrice());
            qryAgrInfoByAgrIdRspBO.setIsAdjustPriceFormula(supplierAgreement.getIsAdjustPriceFormula());
            qryAgrInfoByAgrIdRspBO.setIsModifyBuyPrice(supplierAgreement.getIsModifyBuyPrice());
            qryAgrInfoByAgrIdRspBO.setAgrAdjustPriceFormulaId(supplierAgreement.getAdjustPriceFormulaId());
            qryAgrInfoByAgrIdRspBO.setAgrAdjustPriceFormulaName(supplierAgreement.getAdjustPriceFormulaName());
            qryAgrInfoByAgrIdRspBO.setAgrAdjustPriceFormulaValue(supplierAgreement.getAdjustPriceFormulaValue());
        }
        ArrayList<QryAgrAttachRspVO> agrAttachs = new ArrayList<QryAgrAttachRspVO>();
        ArrayList<QryAgrOtherAttachRspVO> agrOtherAttachs = new ArrayList<QryAgrOtherAttachRspVO>();
        if (!supplierAgreementAttachs.isEmpty()) {
            for (SupplierAgreementAttach supplierAgreementAttach : supplierAgreementAttachs) {
                if (0 == supplierAgreementAttach.getAttachmentType().intValue()) {
                    QryAgrAttachRspVO qryAgrAttachRspVO = new QryAgrAttachRspVO();
                    qryAgrAttachRspVO.setAttachmentAddr(supplierAgreementAttach.getAttachmentAddr());
                    qryAgrAttachRspVO.setAttachmentId(supplierAgreementAttach.getAttachmentId());
                    qryAgrAttachRspVO.setAttachmentName(supplierAgreementAttach.getAttachmentName());
                    qryAgrAttachRspVO.setAttachmentType(supplierAgreementAttach.getAttachmentType());
                    agrAttachs.add(qryAgrAttachRspVO);
                }
                if (1 != supplierAgreementAttach.getAttachmentType().intValue() && 2 != supplierAgreementAttach.getAttachmentType().intValue()) continue;
                QryAgrOtherAttachRspVO qryAgrOtherAttachRspVO = new QryAgrOtherAttachRspVO();
                qryAgrOtherAttachRspVO.setAttachmentAddr(supplierAgreementAttach.getAttachmentAddr());
                qryAgrOtherAttachRspVO.setAttachmentId(supplierAgreementAttach.getAttachmentId());
                qryAgrOtherAttachRspVO.setAttachmentName(supplierAgreementAttach.getAttachmentName());
                qryAgrOtherAttachRspVO.setAttachmentType(supplierAgreementAttach.getAttachmentType());
                agrOtherAttachs.add(qryAgrOtherAttachRspVO);
            }
        }
        qryAgrInfoByAgrIdRspBO.setAgrAttachs(agrAttachs);
        qryAgrInfoByAgrIdRspBO.setAgrOtherAttachs(agrOtherAttachs);
        if (!agreementScopes.isEmpty()) {
            qryAgrInfoByAgrIdRspBO.setAgrScopes(agreementScopes);
        }
        if (null != agrAddPriceProps && agrAddPriceProps.size() > 0) {
            qryAgrInfoByAgrIdRspBO.setAgrAddPriceProps(agrAddPriceProps);
        }
        return qryAgrInfoByAgrIdRspBO;
    }
}

