/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryOnShelvesAndRejectDetailService;
import com.cgd.commodity.busi.bo.QryOnShelvesAndRejectDetailReqBO;
import com.cgd.commodity.busi.bo.QryOnShelvesAndRejectDetailRspBO;
import com.cgd.commodity.busi.vo.QryOnShelvesAndRejectDetailRspVO;
import com.cgd.commodity.dao.SkuApproveDetailLogMapper;
import com.cgd.commodity.dao.SkuApproveLogMapper;
import com.cgd.commodity.po.SkuApproveDetailLog;
import com.cgd.commodity.po.SkuApproveLog;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryOnShelvesAndRejectDetailServiceImpl
implements QryOnShelvesAndRejectDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QryOnShelvesAndRejectDetailServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuApproveLogMapper skuApproveLogMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;

    public void setSkuApproveLogMapper(SkuApproveLogMapper skuApproveLogMapper) {
        this.skuApproveLogMapper = skuApproveLogMapper;
    }

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public QryOnShelvesAndRejectDetailRspBO qryOnShelvesAndRejectDetail(QryOnShelvesAndRejectDetailReqBO qryOnShelvesAndRejectDetailReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryOnShelvesAndRejectDetailReqBO.toString());
        }
        if (null == qryOnShelvesAndRejectDetailReqBO.getApproveId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5ba1\u6279Id[approveId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SkuApproveLog skuApproveLog = this.skuApproveLogMapper.selectByPrimaryKey(qryOnShelvesAndRejectDetailReqBO.getApproveId());
            QryOnShelvesAndRejectDetailRspBO qrySkuOnShelvesAndRejectDetailRspBO = new QryOnShelvesAndRejectDetailRspBO();
            Page page = new Page(qryOnShelvesAndRejectDetailReqBO.getPageNo(), qryOnShelvesAndRejectDetailReqBO.getPageSize());
            RspPageBO rspPageBO = new RspPageBO();
            if (null != skuApproveLog) {
                List<SkuApproveDetailLog> approveLogs = null;
                if (null == qryOnShelvesAndRejectDetailReqBO.getSkuId()) {
                    approveLogs = this.skuApproveDetailLogMapper.selectByApproveId((Page<SkuApproveDetailLog>)page, qryOnShelvesAndRejectDetailReqBO.getApproveId(), skuApproveLog.getApproveType());
                    qrySkuOnShelvesAndRejectDetailRspBO.setOperatorSkuNum(skuApproveLog.getSkuNumber());
                } else {
                    approveLogs = this.skuApproveDetailLogMapper.selectPagesByApproveSkuId((Page<SkuApproveDetailLog>)page, qryOnShelvesAndRejectDetailReqBO.getApproveId(), qryOnShelvesAndRejectDetailReqBO.getSkuId(), skuApproveLog.getApproveType());
                    qrySkuOnShelvesAndRejectDetailRspBO.setOperatorSkuNum(Integer.valueOf(approveLogs.size()));
                }
                List<QryOnShelvesAndRejectDetailRspVO> qrySkuOnShelvesAndRejectDetailVOs = this.resolveRsp(approveLogs);
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qryOnShelvesAndRejectDetailReqBO.getPageNo());
                rspPageBO.setRows(qrySkuOnShelvesAndRejectDetailVOs);
                qrySkuOnShelvesAndRejectDetailRspBO.setOperatorId(skuApproveLog.getCreateLoginId());
                qrySkuOnShelvesAndRejectDetailRspBO.setOperatorName(skuApproveLog.getApprover());
                qrySkuOnShelvesAndRejectDetailRspBO.setOperatorTime(skuApproveLog.getApproveTime());
                qrySkuOnShelvesAndRejectDetailRspBO.setOperatorType(Integer.valueOf(skuApproveLog.getApproveType()));
                qrySkuOnShelvesAndRejectDetailRspBO.setRejectContent(skuApproveLog.getRejectContent());
                qrySkuOnShelvesAndRejectDetailRspBO.setSuggestContent(skuApproveLog.getSuggestContent());
                qrySkuOnShelvesAndRejectDetailRspBO.setSkuOffShelfApproveDetails(rspPageBO);
            }
            return qrySkuOnShelvesAndRejectDetailRspBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryOnShelvesAndRejectDetailRspVO> resolveRsp(List<SkuApproveDetailLog> approveLogs) {
        try {
            if (!approveLogs.isEmpty()) {
                ArrayList<QryOnShelvesAndRejectDetailRspVO> qrySkuOnShelvesAndRejectDetailVOs = new ArrayList<QryOnShelvesAndRejectDetailRspVO>();
                for (SkuApproveDetailLog skuApproveDetailLog : approveLogs) {
                    QryOnShelvesAndRejectDetailRspVO qrySkuOnShelvesAndRejectDetailVO = new QryOnShelvesAndRejectDetailRspVO();
                    qrySkuOnShelvesAndRejectDetailVO.setBrandName(skuApproveDetailLog.getBrandName());
                    NumberFormat nFromat = NumberFormat.getPercentInstance();
                    String rates = nFromat.format(skuApproveDetailLog.getDiscountRate());
                    qrySkuOnShelvesAndRejectDetailVO.setDiscountRate(rates);
                    if (0 == skuApproveDetailLog.getSuccess()) {
                        qrySkuOnShelvesAndRejectDetailVO.setIsSuccess(Boolean.valueOf(false));
                    } else {
                        qrySkuOnShelvesAndRejectDetailVO.setIsSuccess(Boolean.valueOf(true));
                    }
                    qrySkuOnShelvesAndRejectDetailVO.setAgreementPrice(MoneyUtil.Long2BigDecimal((Long)skuApproveDetailLog.getAgreementPrice()));
                    qrySkuOnShelvesAndRejectDetailVO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)skuApproveDetailLog.getMarketPrice()));
                    qrySkuOnShelvesAndRejectDetailVO.setResultMsg(skuApproveDetailLog.getResultMsg());
                    qrySkuOnShelvesAndRejectDetailVO.setSkuCatalog(skuApproveDetailLog.getSkuCatalog());
                    qrySkuOnShelvesAndRejectDetailVO.setSkuId(skuApproveDetailLog.getSkuId());
                    qrySkuOnShelvesAndRejectDetailVO.setSkuName(skuApproveDetailLog.getSkuName());
                    qrySkuOnShelvesAndRejectDetailVO.setSupplierId(skuApproveDetailLog.getSupplierId());
                    qrySkuOnShelvesAndRejectDetailVO.setSupplierName(skuApproveDetailLog.getSupplierName());
                    qrySkuOnShelvesAndRejectDetailVO.setPublishTime(skuApproveDetailLog.getPubTime());
                    qrySkuOnShelvesAndRejectDetailVOs.add(qrySkuOnShelvesAndRejectDetailVO);
                }
                return qrySkuOnShelvesAndRejectDetailVOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0a\u67b6\u53ca\u9a73\u56de\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25\uff1a" + e);
            return null;
        }
    }
}

