/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.SkuRecoveryOnShelfService;
import com.cgd.commodity.busi.bo.SkuRecoveryOnShelfReqBO;
import com.cgd.commodity.busi.bo.SkuRecoveryOnShelfRspBO;
import com.cgd.commodity.busi.vo.SkuRecoveryOnShelfVO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.dao.SkuRecoveOnShelveLogMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuRecoveOnShelveLog;
import com.cgd.common.exception.BusinessException;
import com.cgd.workflow.bo.BpmStartBatchReqBO;
import com.cgd.workflow.bo.BpmStartBatchRspBO;
import com.cgd.workflow.bo.BpmStartBatchVO;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.busin.service.BpmStartBatchBusinService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class SkuRecoveryOnShelfServiceImpl
implements SkuRecoveryOnShelfService {
    private static final Logger logger = LoggerFactory.getLogger(SkuRecoveryOnShelfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private BpmStartBatchBusinService bpmStartBatchBusinService;
    @Autowired
    private SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper;
    @Autowired
    private SkuOnShelveLogMapper skuOnShelveLogMapper;

    public SkuRecoveryOnShelfRspBO skuRecoveryOnShelf(SkuRecoveryOnShelfReqBO skuRecoveryOnShelfReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuRecoveryOnShelfReqBO.toString());
        }
        if (null == skuRecoveryOnShelfReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SkuRecoveryOnShelfRspBO rsp = new SkuRecoveryOnShelfRspBO();
        try {
            List skus = skuRecoveryOnShelfReqBO.getSkus();
            LinkedList<BpmStartReqBO> bpmStartReqBOS = new LinkedList<BpmStartReqBO>();
            BpmStartReqBO bpmStartReqBO = null;
            HashMap<String, Long> variables = null;
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            Map<String, Object> resultMap = null;
            Sku sku = null;
            if (skus != null && skus.size() > 0) {
                for (SkuRecoveryOnShelfVO vo : skus) {
                    sku = this.skuMapper.selectBySkuIdAndSupplier(vo.getSkuId(), vo.getSupplierId());
                    if (sku == null) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1[" + vo.getSkuId() + "]\u4e0d\u5b58\u5728");
                    }
                    if (this.skuOnShelveLogMapper.checkSkuApproveOnWay(vo.getSkuId(), vo.getSupplierId()) > 0) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1[" + vo.getSkuId() + "]\u72b6\u6001\u6b63\u5904\u4e8e\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c");
                    }
                    if (sku.getSkuStatus() != null && sku.getSkuStatus() != 5) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6240\u9009\u5546\u54c1[" + vo.getSkuId() + "]\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u8fd4\u56de\u91cd\u65b0\u9009\u62e9");
                    }
                    bpmStartReqBO = new BpmStartReqBO();
                    variables = new HashMap<String, Long>();
                    bpmStartReqBO.setApplyerId(skuRecoveryOnShelfReqBO.getUserId());
                    bpmStartReqBO.setBusinessTitle("\u6062\u590d\u4e0a\u67b6");
                    bpmStartReqBO.setBusinessType("12");
                    bpmStartReqBO.setBusinessId(String.valueOf(vo.getSkuId()));
                    bpmStartReqBO.setDetailUrl("11");
                    bpmStartReqBO.setStartFlag("1");
                    variables.put("supplierId", vo.getSupplierId());
                    bpmStartReqBO.setVariables(variables);
                    bpmStartReqBOS.add(bpmStartReqBO);
                    resultMap = this.skuMapper.selectById(vo.getSkuId(), vo.getSupplierId());
                    resultMap.put("SUPPLIER_ID", vo.getSupplierId());
                    map.put(String.valueOf(vo.getSkuId()), resultMap);
                }
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4fe1\u606f\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bpmStartReqBOS.size() > 0) {
                BpmStartBatchReqBO bpmStartBatchReqBO = new BpmStartBatchReqBO();
                bpmStartBatchReqBO.setBpmStartReqBOS(bpmStartReqBOS);
                bpmStartBatchReqBO.setUserId(skuRecoveryOnShelfReqBO.getUserId());
                BpmStartBatchRspBO bpmStartBatchRspBO = this.bpmStartBatchBusinService.bpmStartBatch(bpmStartBatchReqBO);
                if (bpmStartBatchRspBO == null) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u51fa\u9519:\u65e0\u5e94\u7b54\uff01");
                }
                if (!"0000".equals(bpmStartBatchRspBO.getRespCode())) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u51fa\u9519:" + bpmStartBatchRspBO.getRespDesc());
                }
                List bpmStartBatchVOs = bpmStartBatchRspBO.getBpmStartBatchVOs();
                if (bpmStartBatchVOs.size() > 0) {
                    ArrayList<SkuRecoveOnShelveLog> logs = new ArrayList<SkuRecoveOnShelveLog>();
                    SkuRecoveOnShelveLog skuRecoveOnShelveLog = null;
                    Byte approveType = 2;
                    Byte isDelete = 0;
                    Date createTime = new Date();
                    Map resMap = null;
                    Long agreementId = 0L;
                    Long agreementSkuId = 0L;
                    Long supplierId = 0L;
                    for (BpmStartBatchVO vo : bpmStartBatchVOs) {
                        Long businessId = vo.getBusinessId();
                        String procinstId = vo.getProcinstId();
                        skuRecoveOnShelveLog = new SkuRecoveOnShelveLog();
                        skuRecoveOnShelveLog.setProcInstlId(procinstId);
                        skuRecoveOnShelveLog.setSkuId(businessId);
                        skuRecoveOnShelveLog.setApproveType(approveType);
                        skuRecoveOnShelveLog.setIsDelete(isDelete);
                        resMap = (Map)map.get(String.valueOf(businessId));
                        if (resMap != null) {
                            if (null != resMap.get("AGREEMENT_ID")) {
                                agreementId = (Long)resMap.get("AGREEMENT_ID");
                            }
                            if (null != resMap.get("AGREEMENT_SKU_ID")) {
                                agreementSkuId = (Long)resMap.get("AGREEMENT_SKU_ID");
                            }
                            supplierId = (Long)resMap.get("SUPPLIER_ID");
                        }
                        skuRecoveOnShelveLog.setAgreementId(agreementId);
                        skuRecoveOnShelveLog.setAgreementSkuId(agreementSkuId);
                        skuRecoveOnShelveLog.setSupplierId(supplierId);
                        skuRecoveOnShelveLog.setCreateLoginId(skuRecoveryOnShelfReqBO.getUserId());
                        skuRecoveOnShelveLog.setCreateLoginName(skuRecoveryOnShelfReqBO.getUserName());
                        skuRecoveOnShelveLog.setCreateTime(createTime);
                        logs.add(skuRecoveOnShelveLog);
                    }
                    this.skuRecoveOnShelveLogMapper.batchSkuRecoOnShelveLog(logs);
                } else if (bpmStartBatchVOs == null || bpmStartBatchVOs != null && bpmStartBatchVOs.size() == 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u672a\u8fd4\u56de\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\uff01");
                }
            }
            rsp.setFailCount(Integer.valueOf(0));
            rsp.setRespDesc("\u6062\u590d\u4e0a\u67b6\u6210\u529f");
            rsp.setSuccessCount(Integer.valueOf(skus.size()));
            rsp.setTotalCount(Integer.valueOf(skus.size()));
            return rsp;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }
}

