/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.intfce.impl;

import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.cgd.commodity.busi.SkuHandOffShelfService;
import com.cgd.commodity.busi.bo.SkuHandOffShelfReqBO;
import com.cgd.commodity.busi.bo.SkuHandOffShelfRspBO;
import com.cgd.commodity.busi.vo.SkuHandOffShelfVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.SkuHandOffShelfBatchService;
import com.cgd.commodity.intfce.bo.SkuHandOffShelfBatchReqBO;
import com.cgd.commodity.intfce.bo.SkuHandOffShelfBatchRspBO;
import com.cgd.commodity.intfce.impl.OnShelfOrRejectSkuBatchServiceImpl;
import com.cgd.commodity.po.Sku;
import com.cgd.common.exception.BusinessException;
import com.cgd.search.builder.search.SearchBuilder;
import com.cgd.search.builder.search.SearchRequestBuilder;
import com.cgd.search.builder.search.SearchRequestBuilderAdapter;
import com.cgd.search.builder.search.filter.BooleanFilterCondition;
import com.cgd.search.builder.search.filter.FilterCondition;
import com.cgd.search.builder.search.filter.MatchFilterCondition;
import com.cgd.search.builder.search.query.BooleanQueryCondition;
import com.cgd.search.builder.search.query.MatchQueryCondition;
import com.cgd.search.builder.search.query.QueryCondition;
import com.cgd.search.builder.search.result.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuHandOffShelfBatchServiceImpl
implements SkuHandOffShelfBatchService {
    private static final Logger logger = LoggerFactory.getLogger(OnShelfOrRejectSkuBatchServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private static final int BATCH_NUM = 500;
    private static final int OPEN_SEARCH_PAGE_NUM = 500;
    private static final String SUPPLIER_FLAG = "SUPPLIER_";
    private SkuHandOffShelfService skuHandOffShelfService;
    private SkuMapper skuMapper;
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;

    public void setSkuHandOffShelfService(SkuHandOffShelfService skuHandOffShelfService) {
        this.skuHandOffShelfService = skuHandOffShelfService;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSearchRequestBuilderAdapter(SearchRequestBuilderAdapter searchRequestBuilderAdapter) {
        this.searchRequestBuilderAdapter = searchRequestBuilderAdapter;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public SkuHandOffShelfBatchRspBO skuHandOffShelfBatch(SkuHandOffShelfBatchReqBO skuHandOffShelfBatchReqBO) {
        if (null == skuHandOffShelfBatchReqBO.getOperateType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u64cd\u4f5c\u7c7b\u578b[operateType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0 == skuHandOffShelfBatchReqBO.getOperateType()) {
            if (null == skuHandOffShelfBatchReqBO.getSupplierId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u4f9b\u5e94\u5546[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuHandOffShelfBatchReqBO.getGuideCatalogId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u7c7b\u76ee[guideCatalogId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuHandOffShelfBatchReqBO.getSkuLocation()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u4f4d\u7f6e\u53c2\u6570[skuLocation]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (null != skuHandOffShelfBatchReqBO.getSkus() ? skuHandOffShelfBatchReqBO.getSkus().isEmpty() : skuHandOffShelfBatchReqBO.getSkus().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int totalCount = 0;
        int successCount = 0;
        int errorCount = 0;
        if (0 == skuHandOffShelfBatchReqBO.getOperateType()) {
            List<Long> skuIds = this.getAllSku(skuHandOffShelfBatchReqBO);
            ArrayList<Object> skus = new ArrayList<Object>();
            if (!skuIds.isEmpty()) {
                SkuHandOffShelfVO skuHandOffShelfVO = new SkuHandOffShelfVO();
                skuHandOffShelfVO.setSkuIds(skuIds);
                skuHandOffShelfVO.setSupplierId(skuHandOffShelfBatchReqBO.getSupplierId());
                skus.add(skuHandOffShelfVO);
            }
            skuHandOffShelfBatchReqBO.setSkus(skus);
        }
        if (!skuHandOffShelfBatchReqBO.getSkus().isEmpty()) {
            Map<String, SkuHandOffShelfVO> skuHandOffShelfVOMap = this.splitReqList(skuHandOffShelfBatchReqBO);
            Boolean stateResult = this.isHasNotMatchState(skuHandOffShelfVOMap);
            if (!stateResult.booleanValue()) {
                throw new BusinessException("RSP_CODE_SKU_STATE_ERROR", "\u6240\u9009\u5546\u54c1\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u8fd4\u56de\u91cd\u65b0\u9009\u62e9");
            }
            try {
                for (Map.Entry entry : skuHandOffShelfVOMap.entrySet()) {
                    totalCount += ((SkuHandOffShelfVO)entry.getValue()).getSkuIds().size();
                    try {
                        Boolean result = this.callSkuHandOffShelfService(skuHandOffShelfBatchReqBO, (SkuHandOffShelfVO)entry.getValue());
                        if (result.booleanValue()) {
                            successCount += ((SkuHandOffShelfVO)entry.getValue()).getSkuIds().size();
                            continue;
                        }
                        errorCount += ((SkuHandOffShelfVO)entry.getValue()).getSkuIds().size();
                    }
                    catch (Exception e) {
                        logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u6267\u884c\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u51fa\u9519\uff1a" + e);
                        errorCount += ((SkuHandOffShelfVO)entry.getValue()).getSkuIds().size();
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u5931\u8d25:" + e);
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u5931\u8d25");
            }
        }
        SkuHandOffShelfBatchRspBO skuHandOffShelfBatchRspBO = new SkuHandOffShelfBatchRspBO();
        skuHandOffShelfBatchRspBO.setTotalCount(Integer.valueOf(totalCount));
        skuHandOffShelfBatchRspBO.setSuccessCount(Integer.valueOf(successCount));
        skuHandOffShelfBatchRspBO.setErrorCount(Integer.valueOf(errorCount));
        if (!skuHandOffShelfBatchReqBO.getSkus().isEmpty() && ((SkuHandOffShelfVO)skuHandOffShelfBatchReqBO.getSkus().get(0)).getSkuIds().size() > 5000) {
            skuHandOffShelfBatchRspBO.setResultMsg("\u8be5\u641c\u7d22\u6761\u4ef6\u67e5\u8be2\u51fa\u7684\u5546\u54c1\u6570\u91cf\u8d85\u8fc75000\u6761\uff0c\u8bf7\u518d\u6b21\u64cd\u4f5c\u4e0b\u67b6");
        }
        return skuHandOffShelfBatchRspBO;
    }

    private Map<String, SkuHandOffShelfVO> splitReqList(SkuHandOffShelfBatchReqBO skuHandOffShelfBatchReqBO) {
        HashMap<String, SkuHandOffShelfVO> skuHandOffShelfVOMap = new HashMap<String, SkuHandOffShelfVO>();
        List skus = skuHandOffShelfBatchReqBO.getSkus();
        for (SkuHandOffShelfVO sku : skus) {
            int skuIdSize = sku.getSkuIds().size();
            if (skuIdSize <= 500) {
                skuHandOffShelfVOMap.put(SUPPLIER_FLAG + sku.getSupplierId(), sku);
                continue;
            }
            int listCount = 0;
            for (int i = 0; i < skuIdSize; i += 500) {
                SkuHandOffShelfVO newSku;
                List newSkuIds;
                if (i + 500 < skuIdSize) {
                    newSkuIds = sku.getSkuIds().subList(i, i + 500);
                    newSku = new SkuHandOffShelfVO();
                    newSku.setSkuIds(newSkuIds);
                    newSku.setSupplierId(sku.getSupplierId());
                    skuHandOffShelfVOMap.put(SUPPLIER_FLAG + sku.getSupplierId() + "_" + listCount, newSku);
                } else {
                    newSkuIds = sku.getSkuIds().subList(i, skuIdSize);
                    newSku = new SkuHandOffShelfVO();
                    newSku.setSkuIds(newSkuIds);
                    newSku.setSupplierId(sku.getSupplierId());
                    skuHandOffShelfVOMap.put(SUPPLIER_FLAG + sku.getSupplierId() + "_" + listCount, newSku);
                }
                ++listCount;
            }
        }
        return skuHandOffShelfVOMap;
    }

    private Boolean callSkuHandOffShelfService(SkuHandOffShelfBatchReqBO skuHandOffShelfBatchReqBO, SkuHandOffShelfVO skuHandOffShelfVO) {
        SkuHandOffShelfReqBO skuHandOffShelfReqBO = new SkuHandOffShelfReqBO();
        skuHandOffShelfReqBO.setOperatorId(skuHandOffShelfBatchReqBO.getUserId());
        skuHandOffShelfReqBO.setSku(skuHandOffShelfVO);
        skuHandOffShelfReqBO.setOperatorName(skuHandOffShelfBatchReqBO.getUserName());
        SkuHandOffShelfRspBO skuHandOffShelfRspBO = this.skuHandOffShelfService.skuHandOffShelf(skuHandOffShelfReqBO);
        if ("0000".equals(skuHandOffShelfRspBO.getRespCode())) {
            if (skuHandOffShelfRspBO.getIsSuccess().booleanValue()) {
                return true;
            }
            return false;
        }
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + skuHandOffShelfRspBO.getRespDesc());
        }
        throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
    }

    private Boolean isHasNotMatchState(Map<String, SkuHandOffShelfVO> skuHandOffShelfVOMap) {
        ArrayList<Sku> skus = new ArrayList<Sku>();
        int count = 0;
        for (Map.Entry<String, SkuHandOffShelfVO> map : skuHandOffShelfVOMap.entrySet()) {
            count += map.getValue().getSkuIds().size();
            try {
                skus.addAll(this.skuMapper.selectByIdAndState(map.getValue().getSupplierId(), Constant.SKU_STATUS_SHELVED, map.getValue().getSkuIds()));
            }
            catch (Exception e) {
                logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u67e5\u8be2\u7b26\u5408\u72b6\u6001\u8981\u6c42\u7684\u5355\u54c1\u51fa\u9519\uff1a" + e);
                return false;
            }
        }
        if (count == skus.size()) {
            return true;
        }
        return false;
    }

    private List<Long> getAllSku(SkuHandOffShelfBatchReqBO skuHandOffShelfBatchReqBO) {
        try {
            Result result = this.getSku(skuHandOffShelfBatchReqBO, 0);
            List<Long> skuIds = this.resolveResult(result);
            long total = result.getTotal();
            long totalPage = 0L;
            totalPage = total <= 500L ? 0L : (total % 500L != 0L ? total / 500L + 1L : total / 500L);
            int i = 1;
            while ((long)i < totalPage) {
                Result newResult = this.getSku(skuHandOffShelfBatchReqBO, i);
                skuIds.addAll(this.resolveResult(newResult));
                ++i;
            }
            return skuIds;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u904d\u5386\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u6570\u636e\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u904d\u5386\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u6570\u636e\u51fa\u9519");
        }
    }

    private Result getSku(SkuHandOffShelfBatchReqBO skuHandOffShelfBatchReqBO, Integer pageNo) {
        try {
            SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
            searchBuilder.setIndexName(String.valueOf(this.prop.getProperty("os.appName")));
            searchBuilder.fetchBuilder().addCol("sku_id").addCol("supplier_id");
            int from = 500 * pageNo;
            searchBuilder.setFrom(from);
            searchBuilder.setSize(500);
            int os_total_count = Integer.parseInt(this.prop.getProperty("os.total_count"));
            if (from + 500 > os_total_count) {
                searchBuilder.setSize(os_total_count - from);
            }
            BooleanQueryCondition booleanQueryCondition = this.getBooleanQueryCondition(skuHandOffShelfBatchReqBO);
            searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
            BooleanFilterCondition filter = new BooleanFilterCondition();
            if (null != skuHandOffShelfBatchReqBO.getGuideCatalogId()) {
                MatchFilterCondition match = new MatchFilterCondition();
                match.setColumnName("l3_category_id");
                match.setValue((Object)("\"" + skuHandOffShelfBatchReqBO.getGuideCatalogId() + "*~~" + "2\""));
                filter.must().add(match);
            }
            if (!filter.must().isEmpty() || !filter.should().isEmpty()) {
                searchBuilder.filterBuilder().setFilterCondition((FilterCondition)filter);
            }
            return searchBuilder.build();
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u5931\u8d25:" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5df2\u4e0a\u67b6\u5546\u54c1\u5931\u8d25");
        }
    }

    private BooleanQueryCondition getBooleanQueryCondition(SkuHandOffShelfBatchReqBO skuHandOffShelfBatchReqBO) {
        try {
            BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
            if (skuHandOffShelfBatchReqBO.getSkuLocation() == 1 || skuHandOffShelfBatchReqBO.getSkuLocation() == 2) {
                MatchQueryCondition match_1 = new MatchQueryCondition();
                match_1.setColumnName("sku_location");
                match_1.setValue("'" + skuHandOffShelfBatchReqBO.getSkuLocation() + "'");
                booleanQueryCondition.must().add(match_1);
            }
            MatchQueryCondition match_2 = new MatchQueryCondition();
            match_2.setColumnName("sku_status");
            match_2.setValue("'" + Constant.SKU_STATUS_SHELVED + "'");
            booleanQueryCondition.must().add(match_2);
            if (null != skuHandOffShelfBatchReqBO.getSupplierId()) {
                MatchQueryCondition match_3 = new MatchQueryCondition();
                match_3.setColumnName("supplier_id");
                match_3.setValue("'" + skuHandOffShelfBatchReqBO.getSupplierId() + "'");
                booleanQueryCondition.must().add(match_3);
            }
            if (null != skuHandOffShelfBatchReqBO.getSkuId()) {
                MatchQueryCondition match_5 = new MatchQueryCondition();
                match_5.setColumnName("id");
                match_5.setValue("'" + skuHandOffShelfBatchReqBO.getSkuId() + "'");
                booleanQueryCondition.must().add(match_5);
            }
            if (null != skuHandOffShelfBatchReqBO.getSkuName()) {
                MatchQueryCondition match_6 = new MatchQueryCondition();
                match_6.setColumnName("sku_name");
                match_6.setValue("'" + skuHandOffShelfBatchReqBO.getSkuName().replaceAll(" ", "") + "'");
                booleanQueryCondition.must().add(match_6);
            }
            if (null != skuHandOffShelfBatchReqBO.getBrandName()) {
                MatchQueryCondition match_7 = new MatchQueryCondition();
                match_7.setColumnName("brand_name");
                match_7.setValue("'" + skuHandOffShelfBatchReqBO.getBrandName().replaceAll(" ", "") + "'");
                booleanQueryCondition.must().add(match_7);
            }
            return booleanQueryCondition;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u89e3\u6790\u67e5\u8be2\u6761\u4ef6\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u89e3\u6790\u67e5\u8be2\u6761\u4ef6\u51fa\u9519");
        }
    }

    private List<Long> resolveResult(Result result) throws Exception {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            if (result.isStatus()) {
                JSONArray skuInfoResultJson = result.getItems();
                for (int i = 0; i < skuInfoResultJson.length(); ++i) {
                    JSONObject obj = skuInfoResultJson.getJSONObject(i);
                    list.add(obj.getLong("sku_id"));
                }
            }
            return list;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u4e0b\u67b6\u7ec4\u5408\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u51fa\u9519\uff1a" + e);
            throw new RuntimeException("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u51fa\u9519");
        }
    }
}

