/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCommodityTaxCodeService;
import com.cgd.commodity.busi.bo.QryCommodityTaxCodeReqBO;
import com.cgd.commodity.busi.bo.QryCommodityTaxCodeRspBO;
import com.cgd.commodity.busi.vo.QryCommodityTaxCodeVO;
import com.cgd.commodity.busi.vo.QryCommodityTypeIdVO;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.CommodityType;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.SkuUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryCommodityTaxCodeServiceImpl
implements QryCommodityTaxCodeService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTaxCodeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private CommodityTypeMapper commodityTypeMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityTypeMapper(CommodityTypeMapper commodityTypeMapper) {
        this.commodityTypeMapper = commodityTypeMapper;
    }

    public QryCommodityTaxCodeRspBO qryCommodityTaxCode(QryCommodityTaxCodeReqBO qryCommodityTaxCodeReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u83b7\u53d6\u5546\u54c1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u670d\u52a1\u5165\u53c2\uff1a" + qryCommodityTaxCodeReqBO.toString());
        }
        QryCommodityTaxCodeRspBO qryCommodityTaxCodeRspBO = new QryCommodityTaxCodeRspBO();
        try {
            ArrayList<QryCommodityTaxCodeVO> qryCommodityCodes = new ArrayList<QryCommodityTaxCodeVO>();
            if (qryCommodityTaxCodeReqBO.getSkuIds().size() > 0) {
                String isInquirySkuIdStr = String.valueOf(qryCommodityTaxCodeReqBO.getSkuIds().get(0));
                if (15 == isInquirySkuIdStr.length() || 14 == isInquirySkuIdStr.length()) {
                    for (Long skuId : qryCommodityTaxCodeReqBO.getSkuIds()) {
                        String catalogIdStr = SkuUtil.resolveSku((Long)skuId);
                        CommodityType commodityType = this.commodityTypeMapper.selectByCatalogIdStr(catalogIdStr);
                        if (null == commodityType) continue;
                        QryCommodityTaxCodeVO qryCommodityTaxCodeVO = new QryCommodityTaxCodeVO();
                        qryCommodityTaxCodeVO.setCommodityTypeId(commodityType.getCommodityTypeId());
                        qryCommodityTaxCodeVO.setSkuId(skuId);
                        qryCommodityTaxCodeVO.setTaxCatCode(commodityType.getTaxCatCode());
                        qryCommodityCodes.add(qryCommodityTaxCodeVO);
                    }
                } else {
                    List<QryCommodityTypeIdVO> commodityTypeIdList = this.skuMapper.qryCommodityType(qryCommodityTaxCodeReqBO.getSupplierId(), qryCommodityTaxCodeReqBO.getSkuIds());
                    HashSet<Long> commodityTypeIds = new HashSet<Long>();
                    for (QryCommodityTypeIdVO qryCommodityTypeIdVO : commodityTypeIdList) {
                        commodityTypeIds.add(qryCommodityTypeIdVO.getCommodityTypeId());
                    }
                    List<QryCommodityTaxCodeVO> taxCodes = this.commodityTypeMapper.qryCommodityTaxCode(new ArrayList<Long>(commodityTypeIds));
                    if (null != taxCodes && taxCodes.size() > 0) {
                        HashMap<Long, Long> skuIdAndCommodityTypeId = new HashMap<Long, Long>();
                        for (QryCommodityTaxCodeVO commodityTaxCodeVO : taxCodes) {
                            skuIdAndCommodityTypeId.put(commodityTaxCodeVO.getCommodityTypeId(), commodityTaxCodeVO.getTaxCatCode());
                        }
                        for (QryCommodityTypeIdVO commodityTypeIdVO : commodityTypeIdList) {
                            if (!skuIdAndCommodityTypeId.containsKey(commodityTypeIdVO.getCommodityTypeId())) continue;
                            QryCommodityTaxCodeVO taxCatCode = new QryCommodityTaxCodeVO();
                            taxCatCode.setCommodityTypeId(commodityTypeIdVO.getCommodityTypeId());
                            taxCatCode.setTaxCatCode((Long)skuIdAndCommodityTypeId.get(commodityTypeIdVO.getCommodityTypeId()));
                            taxCatCode.setSkuId(commodityTypeIdVO.getSkuId());
                            qryCommodityCodes.add(taxCatCode);
                        }
                    }
                }
            }
            qryCommodityTaxCodeRspBO.setSupplierId(qryCommodityTaxCodeReqBO.getSupplierId());
            qryCommodityTaxCodeRspBO.setQryCommodityTaxCode(qryCommodityCodes);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u5546\u54c1\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u670d\u52a1\u51fa\u9519");
        }
        return qryCommodityTaxCodeRspBO;
    }
}

