/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.QryOnShelvesApproveService;
import com.cgd.commodity.busi.bo.QryOnShelvesApproveReqBO;
import com.cgd.commodity.busi.bo.QryOnShelvesApproveRspBO;
import com.cgd.commodity.busi.vo.QryOnShelvesApproveRspVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuOnShelveLog;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.workflow.task.busin.service.QryTodoTaskProcInstMapBusiService;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapReqBO;
import com.cgd.workflow.task.busin.service.bo.QueryTodoTaskProcInstMapRspBO;
import com.cgd.workflow.task.busin.service.bo.TaskRspBO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryOnShelvesApproveServiceImpl
implements QryOnShelvesApproveService {
    private static final Logger logger = LoggerFactory.getLogger(QryOnShelvesApproveServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private SkuMapper skuMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setQryTodoTaskProcInstMapBusiService(QryTodoTaskProcInstMapBusiService qryTodoTaskProcInstMapBusiService) {
        this.qryTodoTaskProcInstMapBusiService = qryTodoTaskProcInstMapBusiService;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public RspPageBO<QryOnShelvesApproveRspBO> qryOnShelvesApprove(QryOnShelvesApproveReqBO qryOnShelvesApproveReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryOnShelvesApproveReqBO.toString());
        }
        if (null == qryOnShelvesApproveReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237Id[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (qryOnShelvesApproveReqBO.getFlag() == 0 && qryOnShelvesApproveReqBO.getAgreementId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u534f\u8baeId[agreementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)qryOnShelvesApproveReqBO.getBrandName())) {
            qryOnShelvesApproveReqBO.setBrandName(qryOnShelvesApproveReqBO.getBrandName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qryOnShelvesApproveReqBO.getSkuName())) {
            qryOnShelvesApproveReqBO.setSkuName(qryOnShelvesApproveReqBO.getSkuName().replaceAll(" ", ""));
        }
        RspPageBO rspPageBO = new RspPageBO();
        Page page = new Page(qryOnShelvesApproveReqBO.getPageNo(), qryOnShelvesApproveReqBO.getPageSize());
        try {
            SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoByUserIdReqBO.setUserId(qryOnShelvesApproveReqBO.getUserId());
            Long supplierId = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO).getCompId();
            QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO = new QueryTodoTaskProcInstMapReqBO();
            queryTodoTaskProcInstMapReqBO.setUserId(qryOnShelvesApproveReqBO.getUserId());
            queryTodoTaskProcInstMapReqBO.setBusinessType("10");
            QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst = this.queryTodoTaskProcInst(queryTodoTaskProcInstMapReqBO);
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryOnShelvesApproveReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryOnShelvesApproveReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            ArrayList<Sku> skuList = new ArrayList<Sku>();
            if (queryTodoTaskProcInst != null && queryTodoTaskProcInst.getProcinstTaskMap() != null && queryTodoTaskProcInst.getProcinstTaskMap().size() > 0) {
                for (String key : queryTodoTaskProcInst.getProcinstTaskMap().keySet()) {
                    Sku sku;
                    SkuOnShelveLog skuOnShelveLog;
                    TaskRspBO taskRspBO = (TaskRspBO)queryTodoTaskProcInst.getProcinstTaskMap().get(key);
                    String procInstId = taskRspBO.getProcInstId();
                    if (procInstId == null || "".equals(procInstId) || (skuOnShelveLog = this.skuOnShelveLogMapper.selectByProcInstId(procInstId, supplierId, qryOnShelvesApproveReqBO.getAgreementId())) == null || (sku = this.skuMapper.selectBySkuIdAndSupplier(skuOnShelveLog.getSkuId(), skuOnShelveLog.getSupplierId())) == null) continue;
                    sku.setTaskId(taskRspBO.getTaskId());
                    skuList.add(sku);
                }
                List<Object> qryOnShelvesApproveRspBO = new ArrayList();
                if (skuList != null && skuList.size() > 0) {
                    List<QryOnShelvesApproveRspVO> qryOnShelvesApproveReqVos;
                    int indexOf;
                    String skuName = qryOnShelvesApproveReqBO.getSkuName();
                    if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                        String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                        qryOnShelvesApproveReqBO.setSkuName(name);
                    }
                    if ((qryOnShelvesApproveReqVos = this.skuMapper.qryOnShelvesApprove((Page<QryOnShelvesApproveRspVO>)page, qryOnShelvesApproveReqBO, commodityTypeIds, skuList)) != null && qryOnShelvesApproveReqVos.size() > 0) {
                        for (QryOnShelvesApproveRspVO qryOnShelvesApproveRspVO : qryOnShelvesApproveReqVos) {
                            for (Sku sku : skuList) {
                                if (!qryOnShelvesApproveRspVO.getSkuId().equals(sku.getSkuId()) || !qryOnShelvesApproveRspVO.getSupplierId().equals(sku.getSupplierId())) continue;
                                qryOnShelvesApproveRspVO.setTaskId(sku.getTaskId());
                            }
                        }
                    }
                    qryOnShelvesApproveRspBO = this.resolveRsp(qryOnShelvesApproveReqVos);
                }
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qryOnShelvesApproveReqBO.getPageNo());
                rspPageBO.setRows(qryOnShelvesApproveRspBO);
                if (this.isDebugEnabled) {
                    logger.debug("\u67e5\u8be2\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + qryOnShelvesApproveReqBO.toString());
                }
                return rspPageBO;
            }
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryOnShelvesApproveReqBO.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInst(QueryTodoTaskProcInstMapReqBO queryTodoTaskProcInstMapReqBO) {
        try {
            QueryTodoTaskProcInstMapRspBO queryTodoTaskProcInstMap = this.qryTodoTaskProcInstMapBusiService.queryTodoTaskProcInstMap(queryTodoTaskProcInstMapReqBO);
            return queryTodoTaskProcInstMap;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u5de5\u4f5c\u6d41\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u4e0e\u6d41\u7a0b\u5b9e\u4f8bid\u5173\u8054\u7684map\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryOnShelvesApproveRspBO> resolveRsp(List<QryOnShelvesApproveRspVO> qryOnShelvesApproveReqVos) throws Exception {
        ArrayList<QryOnShelvesApproveRspBO> qryOnShelvesApproveRspBOs = new ArrayList<QryOnShelvesApproveRspBO>();
        if (!qryOnShelvesApproveReqVos.isEmpty()) {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            for (QryOnShelvesApproveRspVO qryOnShelvesApproveRspVO : qryOnShelvesApproveReqVos) {
                commodityTypeIds.add(qryOnShelvesApproveRspVO.getCommodityTypeId());
            }
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
            for (QryOnShelvesApproveRspVO qryOnShelvesApproveRspVO : qryOnShelvesApproveReqVos) {
                QryOnShelvesApproveRspBO qryOnShelvesApproveRspBO = new QryOnShelvesApproveRspBO();
                qryOnShelvesApproveRspBO = this.getOnShelvesApproveRspBO(qryOnShelvesApproveRspBO, qryOnShelvesApproveRspVO);
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qryOnShelvesApproveRspVO.getCommodityTypeId())) continue;
                        qryOnShelvesApproveRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        qryOnShelvesApproveRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        qryOnShelvesApproveRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                qryOnShelvesApproveRspBOs.add(qryOnShelvesApproveRspBO);
            }
        }
        return qryOnShelvesApproveRspBOs;
    }

    private QryOnShelvesApproveRspBO getOnShelvesApproveRspBO(QryOnShelvesApproveRspBO qryOnShelvesApproveRspBO, QryOnShelvesApproveRspVO qryOnShelvesApproveRspVO) throws Exception {
        qryOnShelvesApproveRspBO.setBrandName(qryOnShelvesApproveRspVO.getBrandName());
        qryOnShelvesApproveRspBO.setCreateTime(qryOnShelvesApproveRspVO.getCreateTime());
        qryOnShelvesApproveRspBO.setFigure(qryOnShelvesApproveRspVO.getFigure());
        qryOnShelvesApproveRspBO.setMarketPrice(MoneyUtil.Long2BigDecimal((Long)qryOnShelvesApproveRspVO.getMarketPrice()));
        qryOnShelvesApproveRspBO.setModel(qryOnShelvesApproveRspVO.getModel());
        qryOnShelvesApproveRspBO.setSkuDetail(qryOnShelvesApproveRspVO.getSkuDetail());
        qryOnShelvesApproveRspBO.setSkuId(qryOnShelvesApproveRspVO.getSkuId());
        qryOnShelvesApproveRspBO.setSkuMainPicUrl(qryOnShelvesApproveRspVO.getSkuMainPicUrl());
        qryOnShelvesApproveRspBO.setSkuName(qryOnShelvesApproveRspVO.getSkuName());
        qryOnShelvesApproveRspBO.setSpec(qryOnShelvesApproveRspVO.getSpec());
        qryOnShelvesApproveRspBO.setTexture(qryOnShelvesApproveRspVO.getTexture());
        qryOnShelvesApproveRspBO.setTaskId(qryOnShelvesApproveRspVO.getTaskId());
        qryOnShelvesApproveRspBO.setSupplierId(qryOnShelvesApproveRspVO.getSupplierId());
        qryOnShelvesApproveRspBO.setAgreementId(qryOnShelvesApproveRspVO.getAgreementId());
        qryOnShelvesApproveRspBO.setAgreementSkuId(qryOnShelvesApproveRspVO.getAgreementSkuId());
        String packParam = qryOnShelvesApproveRspVO.getPackParam();
        if (packParam != null && !"".equals(packParam)) {
            JSONObject parseObject = JSONObject.parseObject((String)packParam);
            qryOnShelvesApproveRspBO.setPackParamLong((String)parseObject.get((Object)"packParamLong"));
            qryOnShelvesApproveRspBO.setPackParamWide((String)parseObject.get((Object)"packParamWide"));
            qryOnShelvesApproveRspBO.setPackParamHigh((String)parseObject.get((Object)"packParamHigh"));
            qryOnShelvesApproveRspBO.setPackParamWeight((String)parseObject.get((Object)"packParamWeight"));
            qryOnShelvesApproveRspBO.setPackParamList((String)parseObject.get((Object)"packParamList"));
        }
        return qryOnShelvesApproveRspBO;
    }
}

