/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryWaitAgrSkuService;
import com.cgd.commodity.busi.bo.supply.QryWaitAgrSkuReqBO;
import com.cgd.commodity.busi.bo.supply.QryWaitAgrSkuRspBO;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.po.SupplierAgreementSku;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QryWaitAgrSkuServiceImpl
implements QryWaitAgrSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QryWaitAgrSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public RspPageBO<QryWaitAgrSkuRspBO> qryWaitAgrSku(QryWaitAgrSkuReqBO qryWaitAgrSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5f85\u53d1\u5e03\u7269\u6599\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryWaitAgrSkuReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            ArrayList<QryWaitAgrSkuRspBO> list = new ArrayList<QryWaitAgrSkuRspBO>();
            Page page = new Page(qryWaitAgrSkuReqBO.getPageNo().intValue(), qryWaitAgrSkuReqBO.getPageSize().intValue());
            List<Object> supplierAgreementSkuList = new ArrayList();
            supplierAgreementSkuList = this.supplierAgreementSkuMapper.selectWaitAgrSkuByIds((Page<Map<String, Object>>)page, qryWaitAgrSkuReqBO.getAgreementId(), qryWaitAgrSkuReqBO.getSupplierId());
            if (supplierAgreementSkuList != null && supplierAgreementSkuList.size() > 0) {
                QryWaitAgrSkuRspBO qryWaitAgrSkuRspBO = null;
                for (SupplierAgreementSku supplierAgreementSku : supplierAgreementSkuList) {
                    qryWaitAgrSkuRspBO = new QryWaitAgrSkuRspBO();
                    BeanUtils.copyProperties((Object)supplierAgreementSku, (Object)qryWaitAgrSkuRspBO);
                    qryWaitAgrSkuRspBO.setBuyPrice(MoneyUtil.Long2BigDecimal((Long)supplierAgreementSku.getBuyPrice()));
                    qryWaitAgrSkuRspBO.setSalePrice(MoneyUtil.Long2BigDecimal((Long)supplierAgreementSku.getSalePrice()));
                    if (supplierAgreementSku.getMaterialId() != null) {
                        qryWaitAgrSkuRspBO.setMaterialId(supplierAgreementSku.getMaterialId().toString());
                    }
                    list.add(qryWaitAgrSkuRspBO);
                }
            }
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setRows(list);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f85\u53d1\u5e03\u7269\u6599\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5f85\u53d1\u5e03\u7269\u6599\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }
}

