/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryWaitOnShelveSkusByMyAgrService;
import com.cgd.commodity.busi.bo.QryWaitOnShelveSkusByMyAgrReqBO;
import com.cgd.commodity.busi.bo.QryWaitOnShelveSkusByMyAgrRspBO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryWaitOnShelveSkusByMyAgrServiceImpl
implements QryWaitOnShelveSkusByMyAgrService {
    private static final Logger logger = LoggerFactory.getLogger(QryWaitOnShelveSkusByMyAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public RspPageBO<QryWaitOnShelveSkusByMyAgrRspBO> qryWaitOnShelveSkus(QryWaitOnShelveSkusByMyAgrReqBO qryWaitOnShelveSkusByMyAgrReqBO) {
        RspPageBO rsp;
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryWaitOnShelveSkusByMyAgrReqBO.toString());
        }
        if (null == qryWaitOnShelveSkusByMyAgrReqBO.getAgreementId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u534f\u8baeID[agreementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qryWaitOnShelveSkusByMyAgrReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u94fa\u8d27\u5355\u4f4dID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryWaitOnShelveSkusByMyAgrReqBO.getGuideCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryWaitOnShelveSkusByMyAgrReqBO.getGuideCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            Page page = new Page(qryWaitOnShelveSkusByMyAgrReqBO.getPageNo(), qryWaitOnShelveSkusByMyAgrReqBO.getPageSize());
            List<Object> results = new ArrayList();
            Byte skuStatus = 1;
            qryWaitOnShelveSkusByMyAgrReqBO.setSkuStatus(skuStatus);
            results = this.skuMapper.QryWaitOnShelveSkusByMyAgr((Page<QryWaitOnShelveSkusByMyAgrReqBO>)page, qryWaitOnShelveSkusByMyAgrReqBO, commodityTypeIds);
            if (results.size() > 0) {
                LinkedList<Long> typeIds = new LinkedList<Long>();
                for (QryWaitOnShelveSkusByMyAgrRspBO qryWaitOnShelveSkusByMyAgrRspBO : results) {
                    typeIds.add(qryWaitOnShelveSkusByMyAgrRspBO.getCommodityTypeId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(typeIds);
                if (!catalogMaps.isEmpty()) {
                    for (QryWaitOnShelveSkusByMyAgrRspBO qryWaitOnShelveSkusByMyAgrRspBO : results) {
                        for (Map<String, Object> map : catalogMaps) {
                            if (!map.get("commodityTypeId").equals(qryWaitOnShelveSkusByMyAgrRspBO.getCommodityTypeId())) continue;
                            qryWaitOnShelveSkusByMyAgrRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                            qryWaitOnShelveSkusByMyAgrRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                            qryWaitOnShelveSkusByMyAgrRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                        }
                    }
                }
            }
            rsp = new RspPageBO();
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setPageNo(qryWaitOnShelveSkusByMyAgrReqBO.getPageNo());
            rsp.setRows(results);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rsp;
    }
}

